/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.busicommon.order.api.DycCommonUploadService;
import com.tydic.dyc.busicommon.order.bo.DycCommonUploadServiceReqBo;
import com.tydic.dyc.busicommon.order.bo.DycCommonUploadServiceReqDataBo;
import com.tydic.dyc.busicommon.order.bo.DycCommonUploadServiceRspBo;
import com.tydic.dyc.busicommon.order.bo.DycCommonUploadServiceRspDataBo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycCommonUploadService"})
public class DycCommonUploadServiceImpl
implements DycCommonUploadService {
    private static final Logger log = LoggerFactory.getLogger(DycCommonUploadServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${obs.fileUrl:}")
    private String obsFileUrl;
    @Value(value="${obs.accessUrl:}")
    private String obsAccessUrl;
    @Value(value="${common.fileUploadPath:dyc-common/}")
    private String fileUploadPath;
    @Value(value="#{'${canBeUploadFileTypes:TXT,DOC,DOCX,XLS,XLSX,PDF,JPG,JPEG,BPM,PNG,DWG,DWS,DXF,WPS,ET,JEPG,DXS,XML,OFD}'.split(',')}")
    private List<String> canBeUploadFileTypes;

    @Override
    @PostMapping(value={"uploadFile"})
    public DycCommonUploadServiceRspBo uploadFile(@RequestBody DycCommonUploadServiceReqBo reqBo) {
        DycCommonUploadServiceRspBo rspBo = new DycCommonUploadServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setFileList(new ArrayList<DycCommonUploadServiceRspDataBo>());
        List<DycCommonUploadServiceReqDataBo> files = reqBo.getFiles();
        for (DycCommonUploadServiceReqDataBo file : files) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            String fileName = file.getFileName();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            if (!this.verify(suffix)) {
                throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            String path = this.fileClient.uploadFileByInputStream(this.fileUploadPath + fileDir, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else if ("OBS".equals(this.fileType)) {
                if (path.startsWith("http")) {
                    innerFileUrl = path;
                    fileUrl = path;
                } else {
                    innerFileUrl = this.obsAccessUrl + path;
                    fileUrl = this.obsFileUrl + path;
                }
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            DycCommonUploadServiceRspDataBo fileRspBo = new DycCommonUploadServiceRspDataBo();
            fileRspBo.setName(file.getFileName());
            fileRspBo.setUrl(fileUrl);
            fileRspBo.setInnerUrl(innerFileUrl);
            rspBo.getFileList().add(fileRspBo);
        }
        return rspBo;
    }

    private boolean verify(String suffix) {
        String toCheck = suffix.replace(".", "").toUpperCase();
        log.info("verify suffix:{}", (Object)toCheck);
        return this.canBeUploadFileTypes.stream().map(String::toUpperCase).collect(Collectors.toList()).contains(toCheck);
    }
}

