/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycPullMasterInfoFunction;
import com.tydic.dyc.atom.common.bo.DycPullMasterInfoFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycPullMasterInfoFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycPullMasterInfoResultBO;
import com.tydic.dyc.umc.service.common.UmcGetSyncDataInfoService;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoReqBO;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoRspBO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycPullMasterInfoFunctionImpl
implements DycPullMasterInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycPullMasterInfoFunctionImpl.class);
    @Autowired
    private UmcGetSyncDataInfoService umcGetSyncDataInfoService;
    @Value(value="${pullMasterInfo.syncPullOrgUrl:${ESB_ACCESS_IP}/OSN/api/pullOrgInfo/v1}")
    private String syncPullOrgUrl;
    @Value(value="${pullMasterInfo.syncPullDeptUrl:${ESB_ACCESS_IP}/OSN/api/pullDeptInfo/v1}")
    private String syncPullDeptUrl;
    @Value(value="${pullMasterInfo.syncPullUserUrl:${ESB_ACCESS_IP}/OSN/api/pullUserInfo/v1}")
    private String syncPullUserUrl;
    @Value(value="${pullMasterInfo.syncPullProjectUrl:${ESB_ACCESS_IP}/OSN/api/pullProjectInfo/v1}")
    private String syncPullProjectUrl;
    @Value(value="${pullMasterInfo.syncPullOrgUrl:${ESB_ACCESS_IP}/OSN/api/pushOrgInfo/v1}")
    private String syncPushOrgUrl;
    @Value(value="${pullMasterInfo.syncPullDeptUrl:${ESB_ACCESS_IP}/OSN/api/pushDeptInfo/v1}")
    private String syncPushDeptUrl;
    @Value(value="${pullMasterInfo.syncPullUserUrl:${ESB_ACCESS_IP}/OSN/api/pushUserInfo/v1}")
    private String syncPushUserUrl;
    @Value(value="${pullMasterInfo.syncPullProjectUrl:${ESB_ACCESS_IP}/OSN/api/pushProjectInfo/v1}")
    private String syncPushProjectUrl;
    private static final Long success_code = 100000L;

    @Override
    public DycPullMasterInfoFuncRspBO pullMasterInfo(DycPullMasterInfoFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSyncId())) {
            throw new ZTBusinessException("\u540c\u6b65ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycPullMasterInfoFuncRspBO rspBO = new DycPullMasterInfoFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UmcGetSyncDataInfoReqBO dataInfoReqBO = new UmcGetSyncDataInfoReqBO();
        dataInfoReqBO.setSyncId(reqBO.getSyncId());
        UmcGetSyncDataInfoRspBO dataInfoRspBO = this.umcGetSyncDataInfoService.getSyncDataInfo(dataInfoReqBO);
        if (ObjectUtil.isEmpty((Object)dataInfoRspBO) || !"0000".equals(dataInfoRspBO.getRespCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5bfc\u540c\u6b65\u4fe1\u606f");
        }
        if ("SYNC_ORG".equals(dataInfoRspBO.getSyncCode())) {
            int pageIndex = 1;
            while (true) {
                String result;
                DycPullMasterInfoResultBO resultBO;
                if (!success_code.equals((resultBO = (DycPullMasterInfoResultBO)JSON.parseObject((String)(result = this.pullMasterInfo(dataInfoRspBO, this.syncPullOrgUrl, pageIndex)), DycPullMasterInfoResultBO.class)).getCode())) {
                    throw new ZTBusinessException("\u67e5\u8be2\u4e3b\u6570\u636e\u673a\u6784\u4fe1\u606f\u62a5\u9519\uff1a" + resultBO.getMessage());
                }
                if (CollectionUtils.isEmpty(resultBO.getData())) {
                    return rspBO;
                }
                this.pushMallInfo(result, this.syncPushOrgUrl);
                ++pageIndex;
            }
        }
        if ("SYNC_DEPT".equals(dataInfoRspBO.getSyncCode())) {
            int pageIndex = 1;
            while (true) {
                String result;
                DycPullMasterInfoResultBO resultBO;
                if (!success_code.equals((resultBO = (DycPullMasterInfoResultBO)JSON.parseObject((String)(result = this.pullMasterInfo(dataInfoRspBO, this.syncPullDeptUrl, pageIndex)), DycPullMasterInfoResultBO.class)).getCode())) {
                    throw new ZTBusinessException("\u67e5\u8be2\u4e3b\u6570\u636e\u90e8\u95e8\u4fe1\u606f\u62a5\u9519\uff1a" + resultBO.getMessage());
                }
                if (CollectionUtils.isEmpty(resultBO.getData())) {
                    return rspBO;
                }
                this.pushMallInfo(result, this.syncPushDeptUrl);
                ++pageIndex;
            }
        }
        if ("SYNC_USER".equals(dataInfoRspBO.getSyncCode())) {
            int pageIndex = 1;
            while (true) {
                String result;
                DycPullMasterInfoResultBO resultBO;
                if (!success_code.equals((resultBO = (DycPullMasterInfoResultBO)JSON.parseObject((String)(result = this.pullMasterInfo(dataInfoRspBO, this.syncPullUserUrl, pageIndex)), DycPullMasterInfoResultBO.class)).getCode())) {
                    throw new ZTBusinessException("\u67e5\u8be2\u4e3b\u6570\u636e\u7528\u6237\u4fe1\u606f\u62a5\u9519\uff1a" + resultBO.getMessage());
                }
                if (CollectionUtils.isEmpty(resultBO.getData())) {
                    return rspBO;
                }
                this.pushMallInfo(result, this.syncPushUserUrl);
                ++pageIndex;
            }
        }
        if ("SYNC_PROJECT".equals(dataInfoRspBO.getSyncCode())) {
            int pageIndex = 1;
            while (true) {
                String result;
                DycPullMasterInfoResultBO resultBO;
                if (!success_code.equals((resultBO = (DycPullMasterInfoResultBO)JSON.parseObject((String)(result = this.pullMasterInfo(dataInfoRspBO, this.syncPullProjectUrl, pageIndex)), DycPullMasterInfoResultBO.class)).getCode())) {
                    throw new ZTBusinessException("\u67e5\u8be2\u4e3b\u6570\u636e\u9879\u76ee\u4fe1\u606f\u62a5\u9519\uff1a" + resultBO.getMessage());
                }
                if (CollectionUtils.isEmpty(resultBO.getData())) {
                    return rspBO;
                }
                this.pushMallInfo(result, this.syncPushProjectUrl);
                ++pageIndex;
            }
        }
        return rspBO;
    }

    private String pullMasterInfo(UmcGetSyncDataInfoRspBO dataInfoRspBO, String url, Integer pageIndex) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", dataInfoRspBO.getOperationCode());
        headers.put("ESB-ClientId", dataInfoRspBO.getClientId());
        headers.put("ESB-Content-Type", "application/json");
        Map map = dataInfoRspBO.getConfigInfo().toMap();
        JSONArray filter = new JSONArray((String)map.get("filter"));
        if (null != dataInfoRspBO.getSyncTime()) {
            JSONObject modifyStartDate = new JSONObject();
            modifyStartDate.put("field", (Object)"SYS_MODIFYDATE_");
            modifyStartDate.put("op", (Object)"1");
            modifyStartDate.put("value", (Object)this.DateConvert(dataInfoRspBO.getSyncTime()));
            modifyStartDate.put("rl", (Object)"1");
            filter.put((Object)modifyStartDate);
        }
        JSONObject modifyEndDate = new JSONObject();
        modifyEndDate.put("field", (Object)"SYS_MODIFYDATE_");
        modifyEndDate.put("op", (Object)"3");
        modifyEndDate.put("value", (Object)this.DateConvert(null));
        modifyEndDate.put("rl", (Object)"1");
        filter.put((Object)modifyEndDate);
        map.put("pageIndex", pageIndex + "");
        map.put("filter", filter.toString());
        return SSLClient.doPost((String)url, (Map)map, headers);
    }

    private String DateConvert(Date date) {
        if (date == null) {
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return currentDate.format(formatter);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    private void pushMallInfo(String data, String url) {
        SSLClient.doPost((String)url, (String)data);
    }
}

