/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycPullSupplierInfoFunction;
import com.tydic.dyc.atom.common.bo.DycPullProjectUserAndRoleResultBO;
import com.tydic.dyc.atom.common.bo.DycPullSupplierInfoFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycPullSupplierInfoFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycPullSupplierInfoResultBO;
import com.tydic.dyc.atom.common.bo.DycPullSupplierUserAndLimitResultBO;
import com.tydic.dyc.atom.common.bo.DycSupplierAttachBO;
import com.tydic.dyc.atom.common.bo.DycSupplierResultBO;
import com.tydic.dyc.umc.service.common.UmcGetSyncDataInfoService;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoReqBO;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoRspBO;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycPullSupplierInfoFunctionImpl
implements DycPullSupplierInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycPullSupplierInfoFunctionImpl.class);
    @Autowired
    private UmcGetSyncDataInfoService umcGetSyncDataInfoService;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenUrl:${ESB_ACCESS_IP}/OSN/api/getSupplierToken/v1}")
    private String syncGetSupplierTokenUrl;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientId:4785dd12-729e-4672-a5ab-da1fe94d776a}")
    private String syncGetSupplierTokenClientId;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientSecret:7ab207ac-ea8a-4c06-8c70-ffa24d60f8ae}")
    private String syncGetSupplierTokenClientSecret;
    @Value(value="${pullSupplierInfo.syncPullSupplierUrl:${ESB_ACCESS_IP}/OSN/api/pullSupplierInfo/v1}")
    private String syncPullSupplierUrl;
    @Value(value="${pullSupplierInfo.syncPushSupplierUrl:${ESB_ACCESS_IP}/OSN/api/pushSupplierInfo/v1}")
    private String syncPushSupplierUrl;
    @Value(value="${pullSupplierInfo.syncPullSupplierUserUrl:${ESB_ACCESS_IP}/OSN/api/pullSupplierUserInfo/v1}")
    private String syncPullSupplierUserUrl;
    @Value(value="${pullSupplierInfo.syncPushSupplierUserUrl:${ESB_ACCESS_IP}/OSN/api/pushSupplierUserInfo/v1}")
    private String syncPushSupplierUserUrl;
    @Value(value="${pullSupplierInfo.syncPullSupplierLimitUrl:${ESB_ACCESS_IP}/OSN/api/pullSupplierLimit/v1}")
    private String syncPullSupplierLimitUrl;
    @Value(value="${pullSupplierInfo.syncPushSupplierLimitUrl:${ESB_ACCESS_IP}/OSN/api/pushSupplierLimit/v1}")
    private String syncPushSupplierLimitUrl;
    @Value(value="${pullSupplierInfo.syncPullProjectRoleUrl:${ESB_ACCESS_IP}/OSN/api/pullProjectRole/v1}")
    private String syncPullProjectRoleUrl;
    @Value(value="${pullSupplierInfo.syncPushProjectRoleUrl:${ESB_ACCESS_IP}/OSN/api/pushProjectRole/v1}")
    private String syncPushProjectRoleUrl;
    @Value(value="${pullSupplierInfo.syncPullProjectUserInfoUrl:${ESB_ACCESS_IP}/OSN/api/pullProjectUserInfo/v1}")
    private String syncPullProjectUserInfoUrl;
    @Value(value="${pullSupplierInfo.syncPushProjectUserInfoUrl:${ESB_ACCESS_IP}/OSN/api/pushProjectUserInfo/v1}")
    private String syncPushProjectUserInfoUrl;
    @Value(value="${pullSupplierInfo.accessoryDownloadUrl:https://testzc.cncecoa.com:8999/epointgateway/share/fjxzjk?cmd=download&AttachGuid=}")
    private String accessoryDownloadUrl;
    @Value(value="${pullSupplierInfo.xAuthenticatedClientId:a49f5a41-464a-4cc1-aee7-3ab2868d25a0}")
    private String xAuthenticatedClientId;
    @Value(value="#{'${canBeUploadFileTypes:TXT,DOC,DOCX,XLS,XLSX,PDF,JPG,JPEG,BPM,PNG,DWG,DWS,DXF,WPS,ET,JEPG,DXS,XML,OFD}'.split(',')}")
    private List<String> canBeUploadFileTypes;
    @Value(value="#{'${clientTypes:A001,Ns001,A008}'.split(',')}")
    private List<String> clientTypes;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Autowired
    private FileClient fileClient;

    @Override
    public DycPullSupplierInfoFuncRspBO pullSupplierInfo(DycPullSupplierInfoFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSyncId())) {
            throw new ZTBusinessException("\u540c\u6b65ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycPullSupplierInfoFuncRspBO rspBO = new DycPullSupplierInfoFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UmcGetSyncDataInfoReqBO dataInfoReqBO = new UmcGetSyncDataInfoReqBO();
        dataInfoReqBO.setSyncId(reqBO.getSyncId());
        UmcGetSyncDataInfoRspBO dataInfoRspBO = this.umcGetSyncDataInfoService.getSyncDataInfo(dataInfoReqBO);
        if (ObjectUtil.isEmpty((Object)dataInfoRspBO) || !"0000".equals(dataInfoRspBO.getRespCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u540c\u6b65\u4fe1\u606f");
        }
        UmcGetSyncDataInfoReqBO getTokenReqBO = new UmcGetSyncDataInfoReqBO();
        getTokenReqBO.setSyncId(Long.valueOf(100L));
        UmcGetSyncDataInfoRspBO getTokenRspBO = this.umcGetSyncDataInfoService.getSyncDataInfo(getTokenReqBO);
        if (ObjectUtil.isEmpty((Object)getTokenRspBO) || !"0000".equals(getTokenRspBO.getRespCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u83b7\u53d6token\u4fe1\u606f");
        }
        String authToken = this.getAuthToken(getTokenRspBO);
        int pageIndex = 1;
        if ("SYNC_SUPPLIER".equals(dataInfoRspBO.getSyncCode())) {
            while (true) {
                String result = this.pullSupplierInfo(dataInfoRspBO, dataInfoRspBO.getSyncCode(), pageIndex, authToken);
                DycPullSupplierInfoResultBO resultBO = null;
                try {
                    resultBO = (DycPullSupplierInfoResultBO)JSON.parseObject((String)result, DycPullSupplierInfoResultBO.class);
                    if (CollectionUtils.isEmpty(resultBO.getGysinfo())) {
                        return rspBO;
                    }
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u67e5\u8be2\u62db\u91c7\u4f9b\u5e94\u5546\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage());
                }
                for (DycSupplierResultBO supplierResultBO : resultBO.getGysinfo()) {
                    if (CollectionUtils.isEmpty(supplierResultBO.getFjinfo())) continue;
                    List<DycSupplierAttachBO> filterList = supplierResultBO.getFjinfo().stream().filter(item -> this.clientTypes.contains(item.getClienttype()) && this.verify(item.getAttachfilename().substring(item.getAttachfilename().lastIndexOf(".")))).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(filterList)) {
                        filterList.forEach(attachBO -> this.setAttachFilePath((DycSupplierAttachBO)attachBO, authToken));
                    }
                    supplierResultBO.setFjinfo(filterList);
                }
                this.pushMallInfo(JSON.toJSONString((Object)resultBO), this.syncPushSupplierUrl);
                ++pageIndex;
            }
        }
        if ("SYNC_SUPPLIER_USER".equals(dataInfoRspBO.getSyncCode())) {
            while (true) {
                String result = this.pullSupplierInfo(dataInfoRspBO, dataInfoRspBO.getSyncCode(), pageIndex, authToken);
                try {
                    DycPullSupplierUserAndLimitResultBO resultBO = (DycPullSupplierUserAndLimitResultBO)JSON.parseObject((String)result, DycPullSupplierUserAndLimitResultBO.class);
                    if (!resultBO.getCode().equals("succ")) {
                        throw new ZTBusinessException(resultBO.getMsg());
                    }
                    if (CollectionUtils.isEmpty(resultBO.getData())) {
                        return rspBO;
                    }
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u67e5\u8be2\u62db\u91c7\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage());
                }
                this.pushMallInfo(result, this.syncPushSupplierUserUrl);
                ++pageIndex;
            }
        }
        if ("SYNC_SUPPLIER_LIMIT".equals(dataInfoRspBO.getSyncCode())) {
            String result = this.pullSupplierInfo(dataInfoRspBO, dataInfoRspBO.getSyncCode(), pageIndex, authToken);
            try {
                DycPullSupplierUserAndLimitResultBO resultBO = (DycPullSupplierUserAndLimitResultBO)JSON.parseObject((String)result, DycPullSupplierUserAndLimitResultBO.class);
                if (!resultBO.getCode().equals("succ")) {
                    throw new ZTBusinessException(resultBO.getMsg());
                }
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u67e5\u8be2\u62db\u91c7\u4f9b\u5e94\u5546\u9650\u5236\u4ea4\u6613\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage());
            }
            this.pushMallInfo(result, this.syncPushSupplierLimitUrl);
        } else {
            if ("SYNC_PROJECT_ROLE".equals(dataInfoRspBO.getSyncCode())) {
                while (true) {
                    String result = this.pullSupplierInfo(dataInfoRspBO, dataInfoRspBO.getSyncCode(), pageIndex, authToken);
                    try {
                        DycPullProjectUserAndRoleResultBO resultBO = (DycPullProjectUserAndRoleResultBO)JSON.parseObject((String)result, DycPullProjectUserAndRoleResultBO.class);
                        if (!resultBO.getStatus().getCode().equals("1")) {
                            throw new ZTBusinessException(resultBO.getStatus().getText());
                        }
                        if (CollectionUtils.isEmpty(resultBO.getCustom().getData())) {
                            return rspBO;
                        }
                    }
                    catch (Exception e) {
                        throw new ZTBusinessException("\u67e5\u8be2\u62db\u91c7\u9879\u76ee\u89d2\u8272\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage());
                    }
                    this.pushMallInfo(result, this.syncPushProjectRoleUrl);
                    ++pageIndex;
                }
            }
            if ("SYNC_PROJECT_USER".equals(dataInfoRspBO.getSyncCode())) {
                while (true) {
                    String result = this.pullSupplierInfo(dataInfoRspBO, dataInfoRspBO.getSyncCode(), pageIndex, authToken);
                    try {
                        DycPullProjectUserAndRoleResultBO resultBO = (DycPullProjectUserAndRoleResultBO)JSON.parseObject((String)result, DycPullProjectUserAndRoleResultBO.class);
                        if (!resultBO.getStatus().getCode().equals("1")) {
                            throw new ZTBusinessException(resultBO.getStatus().getText());
                        }
                        if (CollectionUtils.isEmpty(resultBO.getCustom().getData())) {
                            return rspBO;
                        }
                    }
                    catch (Exception e) {
                        throw new ZTBusinessException("\u67e5\u8be2\u62db\u91c7\u9879\u76ee\u7528\u6237\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage());
                    }
                    this.pushMallInfo(result, this.syncPushProjectUserInfoUrl);
                    ++pageIndex;
                }
            }
        }
        return rspBO;
    }

    private void setAttachFilePath(DycSupplierAttachBO attachBO, String token) {
        InputStream inputStream = null;
        try {
            URL url = new URL(this.accessoryDownloadUrl + attachBO.getAttachguid());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("pttpye", "dspt");
            connection.setRequestProperty("Authorization", "Bearer " + token);
            connection.setRequestProperty("Token", token);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                log.info("\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u8fd4\u56de\u6210\u529f");
                inputStream = connection.getInputStream();
            }
            log.debug("\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb=========");
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            if (!this.instDataPath.endsWith("/")) {
                this.instDataPath = this.instDataPath + "/";
            }
            String path = this.fileClient.uploadFileByInputStream(this.instDataPath + fileDir, attachBO.getAttachfilename(), inputStream);
            attachBO.setFilePath(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
                }
            } else {
                log.error("\u8fd4\u56de\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
            }
        }
    }

    private String getAuthToken(UmcGetSyncDataInfoRspBO getTokenRspBO) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", getTokenRspBO.getOperationCode());
        headers.put("ESB-ClientId", getTokenRspBO.getClientId());
        headers.put("ESB-Content-Type", "application/json");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("client_id", this.syncGetSupplierTokenClientId);
        body.put("client_secret", this.syncGetSupplierTokenClientSecret);
        body.put("grant_type", "client_credentials");
        body.put("scope", "default");
        String getTokenResult = SSLClient.doPost((String)this.syncGetSupplierTokenUrl, body, headers);
        JSONObject getTokenResultObj = JSON.parseObject((String)getTokenResult);
        String custom = getTokenResultObj.getString("custom");
        JSONObject customObj = JSON.parseObject((String)custom);
        return customObj.getString("access_token");
    }

    private String pullSupplierInfo(UmcGetSyncDataInfoRspBO dataInfoRspBO, String syncCode, Integer pageIndex, String authToken) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", dataInfoRspBO.getOperationCode());
        headers.put("ESB-ClientId", dataInfoRspBO.getClientId());
        headers.put("ESB-Content-Type", "application/json");
        headers.put("ESB-Authorization", "Bearer " + authToken);
        headers.put("ESB-x-authenticated-clientid", this.xAuthenticatedClientId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("pageIndex", pageIndex + "");
        body.put("pageSize", "100");
        if ("SYNC_SUPPLIER".equals(syncCode)) {
            if (null != dataInfoRspBO.getSyncTime()) {
                body.put("xiugaidate_start", this.DateConvert(dataInfoRspBO.getSyncTime()));
            }
            body.put("xiugaidate_end", this.DateConvert(null));
            return SSLClient.doPost((String)this.syncPullSupplierUrl, body, headers);
        }
        if ("SYNC_SUPPLIER_USER".equals(syncCode)) {
            if (null != dataInfoRspBO.getSyncTime()) {
                body.put("xiugaidate_start", this.DateConvert(dataInfoRspBO.getSyncTime()));
            }
            body.put("xiugaidate_end", this.DateConvert(null));
            return SSLClient.doPost((String)this.syncPullSupplierUserUrl, body, headers);
        }
        if ("SYNC_SUPPLIER_LIMIT".equals(syncCode)) {
            body.put("sxstatus", "1");
            return SSLClient.doPost((String)this.syncPullSupplierLimitUrl, body, headers);
        }
        if ("SYNC_PROJECT_ROLE".equals(syncCode)) {
            return SSLClient.doPost((String)this.syncPullProjectRoleUrl, body, headers);
        }
        if ("SYNC_PROJECT_USER".equals(syncCode)) {
            if (null != dataInfoRspBO.getSyncTime()) {
                body.put("sys_modifydate_", this.DateConvert(dataInfoRspBO.getSyncTime()));
            }
            body.put("sys_modifydate__t_10241713596500605", this.DateConvert(null));
            return SSLClient.doPost((String)this.syncPullProjectUserInfoUrl, body, headers);
        }
        return null;
    }

    private void pushMallInfo(String data, String url) {
        SSLClient.doPost((String)url, (String)data);
    }

    private String DateConvert(Date date) {
        if (date == null) {
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd ");
            return currentDate.format(formatter);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    private boolean verify(String suffix) {
        String toCheck = suffix.replace(".", "").toUpperCase();
        log.debug("verify suffix:{}", (Object)toCheck);
        return this.canBeUploadFileTypes.stream().map(String::toUpperCase).collect(Collectors.toList()).contains(toCheck);
    }
}

