/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycPushExtTodoFunction;
import com.tydic.dyc.atom.common.bo.DycPushExtTodoFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycPushExtTodoFuncRspBO;
import com.tydic.dyc.umc.service.common.UmcGetSyncDataInfoService;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoReqBO;
import com.tydic.dyc.umc.service.common.bo.UmcGetSyncDataInfoRspBO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycPushExtTodoFunctionImpl
implements DycPushExtTodoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycPushExtTodoFunctionImpl.class);
    @Autowired
    private UmcGetSyncDataInfoService umcGetSyncDataInfoService;
    @Value(value="${pushExtTodo.pushExtTodoUrl:${ESB_ACCESS_IP}/OSN/api/pushExtTodo/v1}")
    private String pushExtTodoUrl;
    @Value(value="${pushExtTodo.operationCode:cn.cncec.group.jcptUAT.project.dbjsjk2}")
    private String operationCode;
    @Value(value="${pushExtTodo.clientId:cn.cncec.group.hxdsUAT}")
    private String clientId;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenUrl:${ESB_ACCESS_IP}/OSN/api/getSupplierToken/v1}")
    private String syncGetSupplierTokenUrl;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientId:4785dd12-729e-4672-a5ab-da1fe94d776a}")
    private String syncGetSupplierTokenClientId;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientSecret:7ab207ac-ea8a-4c06-8c70-ffa24d60f8ae}")
    private String syncGetSupplierTokenClientSecret;
    @Value(value="${pullSupplierInfo.xAuthenticatedClientId:a49f5a41-464a-4cc1-aee7-3ab2868d25a0}")
    private String xAuthenticatedClientId;

    @Override
    public DycPushExtTodoFuncRspBO pushExtTodo(DycPushExtTodoFuncReqBO reqBO) {
        DycPushExtTodoFuncRspBO rspBO = new DycPushExtTodoFuncRspBO();
        UmcGetSyncDataInfoReqBO getTokenReqBO = new UmcGetSyncDataInfoReqBO();
        getTokenReqBO.setSyncId(Long.valueOf(100L));
        UmcGetSyncDataInfoRspBO getTokenRspBO = this.umcGetSyncDataInfoService.getSyncDataInfo(getTokenReqBO);
        if (ObjectUtil.isEmpty((Object)getTokenRspBO) || !"0000".equals(getTokenRspBO.getRespCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u83b7\u53d6token\u4fe1\u606f");
        }
        String authToken = this.getAuthToken(getTokenRspBO);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", this.operationCode);
        headers.put("ESB-ClientId", this.clientId);
        headers.put("ESB-Content-Type", "application/json");
        headers.put("ESB-Authorization", "Bearer " + authToken);
        headers.put("ESB-x-authenticated-clientid", this.xAuthenticatedClientId);
        try {
            String body = "[" + JSON.toJSONString((Object)reqBO) + "]";
            log.info("\u63a8\u9001\u5916\u90e8\u4ee3\u529e\u5165\u53c2\u4e3a\uff1a{}", (Object)body);
            String result = SSLClient.doPost((String)this.pushExtTodoUrl, (String)body, headers);
            log.info("\u63a8\u9001\u5916\u90e8\u4ee3\u529e\u51fa\u53c2\u4e3a\uff1a{}", (Object)result);
            JSONObject resultObj = JSON.parseObject((String)result);
            if (!"S".equals(resultObj.getString("ReturnStatus"))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(resultObj.getString("ReturnMsg"));
                return rspBO;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getAuthToken(UmcGetSyncDataInfoRspBO getTokenRspBO) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", getTokenRspBO.getOperationCode());
        headers.put("ESB-ClientId", getTokenRspBO.getClientId());
        headers.put("ESB-Content-Type", "application/json");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("client_id", this.syncGetSupplierTokenClientId);
        body.put("client_secret", this.syncGetSupplierTokenClientSecret);
        body.put("grant_type", "client_credentials");
        body.put("scope", "default");
        String getTokenResult = SSLClient.doPost((String)this.syncGetSupplierTokenUrl, body, headers);
        JSONObject getTokenResultObj = JSON.parseObject((String)getTokenResult);
        String custom = getTokenResultObj.getString("custom");
        JSONObject customObj = JSON.parseObject((String)custom);
        return customObj.getString("access_token");
    }
}

