/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycSupplierLoginFunciton;
import com.tydic.dyc.atom.common.bo.DycSupplierLoginFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycSupplierLoginFuncRspBO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycSupplierLoginFuncitonImpl
implements DycSupplierLoginFunciton {
    private static final Logger log = LoggerFactory.getLogger(DycSupplierLoginFuncitonImpl.class);
    @Value(value="${supplierLogin.getAccessToken:${ESB_ACCESS_IP}/OSN/api/getAccessToken/v1}")
    private String getAccessTokenUrl;
    @Value(value="${supplierLogin.getLoginId:${ESB_ACCESS_IP}/OSN/api/getLoginId/v1}")
    private String getLoginIdUrl;
    @Value(value="${supplierLogin.heardClientId:cn.cncec.group.hxdsUAT}")
    private String heardClientId;
    @Value(value="${supplierLogin.heardOperationCode:cn.cncec.group.jcptUAT.auth.hytoken}")
    private String heardOperationCodeByHytoken;
    @Value(value="${supplierLogin.heardOperationCode:cn.cncec.group.jcptUAT.auth.loginid}")
    private String heardOperationCodeByLoginId;
    @Value(value="${supplierLogin.clientId:d055996f-3db4-4e61-af47-b1db52284ff1}")
    private String clientId;
    @Value(value="${supplierLogin.clientSecret:0a708933-7528-4463-a70c-b7ef4b25cf37}")
    private String clientSecret;
    @Value(value="${supplierLogin.redirectUri:http%3A%2F%2F10.255.163.4%2FtransferPage}")
    private String redirectUri;
    private static final String GRANT_TYPE = "authorization_code";

    @Override
    public DycSupplierLoginFuncRspBO supplierLogin(DycSupplierLoginFuncReqBO reqBO) {
        if (StringUtil.isBlank((String)reqBO.getCode())) {
            throw new ZTBusinessException("\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycSupplierLoginFuncRspBO rspBO = new DycSupplierLoginFuncRspBO();
        String getAccessTokenResult = this.getAccessToken(reqBO);
        String access_token = "";
        String data = "";
        try {
            JSONObject json = JSON.parseObject((String)getAccessTokenResult);
            access_token = json.getString("access_token");
            rspBO.setExpiresIn(json.getString("expires_in"));
            data = (String)json.get((Object)"error_description");
            rspBO.setAccessToken(access_token);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        if (StringUtil.isNotBlank((String)data)) {
            rspBO.setRespCode("8888");
            JSONObject dataObj = JSON.parseObject((String)data);
            rspBO.setRespDesc(dataObj.getString("error_description"));
            return rspBO;
        }
        if (StringUtil.isBlank((String)access_token)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("access_token\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", this.heardOperationCodeByLoginId);
        headers.put("ESB-ClientId", this.heardClientId);
        headers.put("ESB-Authorization", "Bearer " + access_token);
        try {
            String loginId = SSLClient.doPost((String)this.getLoginIdUrl, (String)"{}", headers);
            rspBO.setLoginName(loginId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getAccessToken(DycSupplierLoginFuncReqBO reqBO) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", this.heardOperationCodeByHytoken);
        headers.put("ESB-ClientId", this.heardClientId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", reqBO.getCode());
        body.put("client_id", this.clientId);
        body.put("client_secret", this.clientSecret);
        body.put("redirect_uri", this.redirectUri);
        body.put("grant_type", GRANT_TYPE);
        String getAccessTokenResult = SSLClient.doPost((String)this.getAccessTokenUrl, body, headers);
        return getAccessTokenResult;
    }
}

