/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.ZhGetSchemeInfoFunction;
import com.tydic.dyc.atom.common.bo.ZhGetSchemeInfoFuncReqBO;
import com.tydic.dyc.atom.common.bo.ZhGetSchemeInfoFuncRspBO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ZhGetSchemeInfoFunctionImpl
implements ZhGetSchemeInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(ZhGetSchemeInfoFunctionImpl.class);
    @Value(value="${TokenClientId:cn.cncec.group.hxdsUAT}")
    private String clientId;
    @Value(value="AuthenticatedClientId:a49f5a41-464a-4cc1-aee7-3ab2868d25a0")
    private String authenticatedClientId;
    @Value(value="${pullSchemeInfo.syncGetSchemeInfoUrl:${ESB_ACCESS_IP}/OSN/api/getSchemeInfo/v1}")
    private String syncGetSchemeInfoUrl;
    @Value(value="${CLIE:DSXT")
    private String clie;

    @Override
    public ZhGetSchemeInfoFuncRspBO getSchemeInfoList(ZhGetSchemeInfoFuncReqBO reqBO) {
        ZhGetSchemeInfoFuncRspBO rspBO = new ZhGetSchemeInfoFuncRspBO();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ESB-OperationCode", reqBO.getOperationCode());
        headers.put("ESB-ClientId", this.clientId);
        headers.put("ESB-Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + reqBO.getToken());
        headers.put("x-authenticated-clientid", this.authenticatedClientId);
        headers.put("CLIE", this.clie);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("pageIndex", reqBO.getPageIndex() + "");
        body.put("pageSize", reqBO.getPageSize() + "");
        body.put("purchaselevelrange", reqBO.getPurchaselevelrange());
        body.put("shr_date_start", this.DateConvert(reqBO.getShr_date_start()));
        body.put("shr_date_end", this.DateConvert(reqBO.getShr_date_end()));
        body.put("isuseoutzbr", reqBO.getIsuseoutzbr());
        String result = "";
        try {
            result = SSLClient.doPost((String)this.syncGetSchemeInfoUrl, body, headers);
            rspBO = (ZhGetSchemeInfoFuncRspBO)((Object)JSON.parseObject((String)result, ZhGetSchemeInfoFuncRspBO.class));
            if (CollectionUtils.isEmpty(rspBO.getCaigoufangan())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String DateConvert(Date date) {
        if (date == null) {
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd ");
            return currentDate.format(formatter);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }
}

