/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.ZhGetTokenFunction;
import com.tydic.dyc.atom.common.bo.ZhGetTokenFuncReqBO;
import com.tydic.dyc.atom.common.bo.ZhGetTokenFuncRspBO;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZhGetTokenFunctionImpl
implements ZhGetTokenFunction {
    @Value(value="${TokenClientId:cn.cncec.group.hxdsUAT}")
    private String clientId;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenUrl:${ESB_ACCESS_IP}/OSN/api/getSupplierToken/v1}")
    private String syncGetSupplierTokenUrl;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientId:4785dd12-729e-4672-a5ab-da1fe94d776a}")
    private String syncGetSupplierTokenClientId;
    @Value(value="${pullSupplierInfo.syncGetSupplierTokenClientSecret:7ab207ac-ea8a-4c06-8c70-ffa24d60f8ae}")
    private String syncGetSupplierTokenClientSecret;

    @Override
    public ZhGetTokenFuncRspBO getToken(ZhGetTokenFuncReqBO reqBO) {
        ZhGetTokenFuncRspBO rspBO = new ZhGetTokenFuncRspBO();
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("ESB-OperationCode", reqBO.getEsbOperationCode());
            headers.put("ESB-ClientId", this.clientId);
            headers.put("ESB-Content-Type", "application/json");
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("client_id", this.syncGetSupplierTokenClientId);
            body.put("client_secret", this.syncGetSupplierTokenClientSecret);
            body.put("grant_type", "client_credentials");
            body.put("scope", "default");
            String getTokenResult = SSLClient.doPost((String)this.syncGetSupplierTokenUrl, body, headers);
            JSONObject getTokenResultObj = JSON.parseObject((String)getTokenResult);
            String custom = getTokenResultObj.getString("custom");
            JSONObject customObj = JSON.parseObject((String)custom);
            rspBO.setToken(customObj.getString("access_token"));
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

