/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.estore.api.DycUocJdAddressQryFunction;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionRspBO;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.mall.order.api.DycUocCheckBargainingRulesService;
import com.tydic.dyc.mall.order.api.DycUocCreateBargainingService;
import com.tydic.dyc.mall.order.bo.DycUocCheckBargainingRulesReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCheckBargainingRulesRspBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateBargainingCommodityBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateBargainingContextBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateBargainingReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateBargainingRspBO;
import com.tydic.dyc.mall.order.bo.DycUocShoppingCartSkuCheckBO;
import com.tydic.dyc.oc.service.bargaining.UocCreateBargainingService;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingCreateResultBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingItemBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateSupplierInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartRspBo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCreateBargainingService"})
public class DycUocCreateBargainingServiceImpl
implements DycUocCreateBargainingService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCreateBargainingServiceImpl.class);
    @Autowired
    private DycUocCheckBargainingRulesService dycUocCheckBargainingRulesService;
    @Autowired
    private DycUocJdAddressQryFunction dycUocJdAddressQryFunction;
    @Autowired
    private DycUocCommodityBatchQryFunction dycUocCommodityBatchQryFunction;
    @Autowired
    private UmcRemoveShoppingCartService umcRemoveShoppingCartService;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    @Value(value="${JH_BARGAINING_BUSI_FLOW:BARGAINING_SHEET_BUSI_FLOW1}")
    String jhBargainingBusiFlow;
    @Autowired
    private UocCreateBargainingService uocCreateBargainingService;

    @Override
    @PostMapping(value={"createBargaining"})
    public DycUocCreateBargainingRspBO createBargaining(@RequestBody DycUocCreateBargainingReqBO reqBO) {
        this.verifyParam(reqBO);
        this.verifyCheckRule(reqBO);
        DycUocCreateBargainingContextBO contextBO = (DycUocCreateBargainingContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocCreateBargainingContextBO.class));
        this.queryAndVerifyJdAddressInfo(contextBO);
        this.batchQuerySkuInfo(contextBO);
        this.querySupplierInfo(contextBO);
        this.createBargaining(contextBO);
        this.startBargainingProcess(contextBO);
        this.deleteShopCartGoods(contextBO);
        DycUocCreateBargainingRspBO rspBO = new DycUocCreateBargainingRspBO();
        rspBO.setBargainingParentId(contextBO.getBargainingParentId());
        return rspBO;
    }

    private void verifyParam(DycUocCreateBargainingReqBO reqBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u5165\u53c2\u6821\u9a8c");
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getTotalSaleFee())) {
            throw new ZTBusinessException("\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getQuotationExpiryTime())) {
            throw new ZTBusinessException("\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressBo())) {
            throw new ZTBusinessException("\u9884\u8ba1\u9001\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getAddressBo();
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressBo().getProvinceId())) {
            throw new ZTBusinessException("\u5730\u5740-\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressBo().getCityId())) {
            throw new ZTBusinessException("\u5730\u5740-\u5730\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBO.getCommodityBos())) {
            throw new ZTBusinessException("\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getCommodityBos().forEach(obj -> {
            if (ObjectUtil.isEmpty((Object)obj.getPurchaseCount())) {
                throw new ZTBusinessException("\u5546\u54c1\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getPurchaseCount().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u5546\u54c1\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSkuId())) {
                throw new ZTBusinessException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getBrandId())) {
                throw new ZTBusinessException("\u5546\u54c1\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSupplierId())) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSalePrice())) {
                throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getSalePrice().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a0");
            }
            if (ObjectUtil.isEmpty((Object)obj.getPriceSub())) {
                throw new ZTBusinessException("\u5546\u54c1\u5c0f\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getPriceSub().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u5546\u54c1\u5c0f\u8ba1\u4e0d\u80fd\u4e3a0");
            }
            if (ObjectUtil.isEmpty((Object)obj.getPurPurposeId())) {
                throw new ZTBusinessException("\u91c7\u8d2d\u7528\u9014ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getPurPurposeName())) {
                throw new ZTBusinessException("\u91c7\u8d2d\u7528\u9014\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }

    private void verifyCheckRule(DycUocCreateBargainingReqBO reqBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u6821\u9a8c\u8bae\u4ef7\u89c4\u5219\uff01");
        if (null == reqBO.getCommodityBos()) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DycUocShoppingCartSkuCheckBO> shoppingCartSkuList = reqBO.getCommodityBos().stream().map(commodityBo -> {
            DycUocShoppingCartSkuCheckBO skuCheckBO = new DycUocShoppingCartSkuCheckBO();
            skuCheckBO.setSupplierId(commodityBo.getSupplierId());
            skuCheckBO.setSkuId(commodityBo.getSkuId());
            skuCheckBO.setSkuSource(commodityBo.getSkuSource());
            skuCheckBO.setBrandId(commodityBo.getBrandId());
            skuCheckBO.setPrice(commodityBo.getSalePrice());
            skuCheckBO.setPriceSub(commodityBo.getPriceSub());
            skuCheckBO.setSaleNum(commodityBo.getPurchaseCount());
            return skuCheckBO;
        }).collect(Collectors.toList());
        DycUocCheckBargainingRulesReqBO bargainingRulesReqBO = new DycUocCheckBargainingRulesReqBO();
        bargainingRulesReqBO.setShoppingCartSkuList(shoppingCartSkuList);
        DycUocCheckBargainingRulesRspBO bargainingRulesRspBO = this.dycUocCheckBargainingRulesService.checkBargainingRules(bargainingRulesReqBO);
        if (ObjectUtil.isEmpty(bargainingRulesRspBO.getShoppingCartSkuList()) || bargainingRulesRspBO.getShoppingCartSkuList().size() < reqBO.getCommodityBos().size()) {
            throw new ZTBusinessException("\u63d0\u4ea4\u7684\u8bae\u4ef7\u5546\u54c1\u4e2d\u6709\u4e0d\u7b26\u5408\u8bae\u4ef7\u8c03\u4ef7\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff01");
        }
    }

    private void queryAndVerifyJdAddressInfo(DycUocCreateBargainingContextBO contextBO) {
        List supplierIdList = contextBO.getCommodityBos().stream().map(v -> String.valueOf(v.getSupplierId())).collect(Collectors.toList());
        if (supplierIdList.contains(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
            if (Objects.isNull(contextBO.getAddressBo()) || StringUtils.isEmpty((Object)contextBO.getAddressBo().getAddress())) {
                throw new ZTBusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u4eac\u4e1c\u5730\u5740\u6821\u9a8c");
            DycUocJdAddressQryFunctionReqBO dycUocJdAddressQryFunctionReqBO = new DycUocJdAddressQryFunctionReqBO();
            dycUocJdAddressQryFunctionReqBO.setAddress(contextBO.getAddressBo().getAddress());
            dycUocJdAddressQryFunctionReqBO.setSupplierId(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"));
            dycUocJdAddressQryFunctionReqBO.setContactProvinceId(contextBO.getAddressBo().getProvinceId());
            dycUocJdAddressQryFunctionReqBO.setContactCityId(contextBO.getAddressBo().getCityId());
            dycUocJdAddressQryFunctionReqBO.setContactCountyId(contextBO.getAddressBo().getCountyId());
            dycUocJdAddressQryFunctionReqBO.setContactTownId(contextBO.getAddressBo().getTownId());
            dycUocJdAddressQryFunctionReqBO.setIsCheckArea(Boolean.valueOf(true));
            DycUocJdAddressQryFunctionRspBO dycUocJdAddressQryFunctionRspBO = this.dycUocJdAddressQryFunction.qryAddressInfo(dycUocJdAddressQryFunctionReqBO);
            if ("0000".equals(dycUocJdAddressQryFunctionRspBO.getRespCode())) {
                contextBO.getAddressBo().setCountryId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountryId());
                contextBO.getAddressBo().setProvinceId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactProvinceId());
                contextBO.getAddressBo().setCityId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCityId());
                contextBO.getAddressBo().setCountyId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountyId());
                contextBO.getAddressBo().setTownId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactTownId());
            } else {
                throw new ZTBusinessException(dycUocJdAddressQryFunctionRspBO.getRespDesc());
            }
        }
    }

    private void batchQuerySkuInfo(DycUocCreateBargainingContextBO contextBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u9879\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u8bf7\u6c42\u5546\u54c1\u4fe1\u606f");
        DycUocCommodityBatchQryFuncReqBO dycUocCommodityBatchQryFuncReqBO = new DycUocCommodityBatchQryFuncReqBO();
        BeanUtils.copyProperties((Object)((Object)contextBO), (Object)dycUocCommodityBatchQryFuncReqBO);
        dycUocCommodityBatchQryFuncReqBO.setProvince(Long.valueOf(contextBO.getAddressBo().getProvinceId()));
        dycUocCommodityBatchQryFuncReqBO.setCity(Long.valueOf(contextBO.getAddressBo().getCityId()));
        if (!StringUtils.isEmpty((Object)contextBO.getAddressBo().getCountyId())) {
            dycUocCommodityBatchQryFuncReqBO.setCounty(Long.valueOf(contextBO.getAddressBo().getCountyId()));
        }
        if (!StringUtils.isEmpty((Object)contextBO.getAddressBo().getTownId())) {
            dycUocCommodityBatchQryFuncReqBO.setTown(Long.valueOf(contextBO.getAddressBo().getTownId()));
        }
        List skuOrderList = JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(DycUocCommodityBatchQryFuncBO.class);
        dycUocCommodityBatchQryFuncReqBO.setSkuOrderList(skuOrderList);
        DycUocCommodityBatchQryFuncRspBO dycUocCommodityBatchQryFuncRspBO = this.dycUocCommodityBatchQryFunction.qryCommodityByBatch(dycUocCommodityBatchQryFuncReqBO);
        if (!"0000".equals(dycUocCommodityBatchQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocCommodityBatchQryFuncRspBO.getRespDesc());
        }
        contextBO.setCommodityInfos(dycUocCommodityBatchQryFuncRspBO.getCommodityInfos());
    }

    private void querySupplierInfo(DycUocCreateBargainingContextBO contextBO) {
        List<UocSupplierInfoBo> supplierBos = contextBO.getCommodityBos().stream().map(dycUocCommodityFuncBO -> {
            UocSupplierInfoBo supplierInfoBo = new UocSupplierInfoBo();
            supplierInfoBo.setSupplierId(dycUocCommodityFuncBO.getSupplierId());
            supplierInfoBo.setSupplierName(dycUocCommodityFuncBO.getSupplierName());
            return supplierInfoBo;
        }).distinct().collect(Collectors.toList());
        contextBO.setSupplierBos(supplierBos);
    }

    private void createBargaining(DycUocCreateBargainingContextBO contextBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u5f00\u59cb\u8bb0\u5f55\u8bae\u4ef7\u4fe1\u606f");
        UocCreateBargainingReqBo uocCreateBargainingReqBo = new UocCreateBargainingReqBo();
        uocCreateBargainingReqBo.setTraceId(contextBO.getTraceId());
        uocCreateBargainingReqBo.setUserId(contextBO.getUserId());
        uocCreateBargainingReqBo.setName(contextBO.getName());
        uocCreateBargainingReqBo.setUserName(contextBO.getUserName());
        uocCreateBargainingReqBo.setOrgId(contextBO.getOrgId());
        uocCreateBargainingReqBo.setOrgName(contextBO.getOrgName());
        uocCreateBargainingReqBo.setOrgPath(contextBO.getOrgPath());
        uocCreateBargainingReqBo.setCompanyId(contextBO.getCompanyId());
        uocCreateBargainingReqBo.setCompanyName(contextBO.getCompanyName());
        uocCreateBargainingReqBo.setUserTypeIn(contextBO.getUserTypeIn());
        uocCreateBargainingReqBo.setTotalSaleFee(contextBO.getTotalSaleFee());
        uocCreateBargainingReqBo.setRemark(contextBO.getRemark());
        uocCreateBargainingReqBo.setModelSettle(contextBO.getModelSettle());
        uocCreateBargainingReqBo.setQuotationExpiryTime(contextBO.getQuotationExpiryTime());
        List bargainingItemBos = JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityInfos())).toJavaList(UocCreateBargainingItemBo.class);
        Map<Long, DycUocCreateBargainingCommodityBO> skuIdMap = contextBO.getCommodityBos().stream().collect(Collectors.toMap(DycUocCreateBargainingCommodityBO::getSkuId, obj -> obj));
        log.debug("bargainingItemBos:" + JSON.toJSONString((Object)bargainingItemBos));
        log.debug("skuIdMap:" + JSON.toJSONString(skuIdMap));
        for (UocCreateBargainingItemBo itemBo : bargainingItemBos) {
            DycUocCreateBargainingCommodityBO commodityBOS = skuIdMap.get(Long.valueOf(itemBo.getSkuId()));
            itemBo.setPurPurposeId(commodityBOS.getPurPurposeId());
            itemBo.setPurPurposeName(commodityBOS.getPurPurposeName());
            itemBo.setPaymentProjectId(commodityBOS.getPaymentProjectId());
            itemBo.setPaymentProjectName(commodityBOS.getPaymentProjectName());
            itemBo.setExtSkuId(itemBo.getSkuExtSkuId());
        }
        uocCreateBargainingReqBo.setBargainingItemBos(bargainingItemBos);
        uocCreateBargainingReqBo.setSupplierBos(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getSupplierBos())).toJavaList(UocCreateSupplierInfoBo.class));
        uocCreateBargainingReqBo.setAddressBo((UocCreateBargainingAddressBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getAddressBo()), UocCreateBargainingAddressBo.class));
        log.debug("contextBO.getCommodityBos()" + JSON.toJSONString(contextBO.getCommodityBos()));
        log.debug("contextBO.getCommodityInfos()" + JSON.toJSONString(contextBO.getCommodityInfos()));
        log.debug("uocCreateBargainingReqBo.getOrderItems()" + JSON.toJSONString((Object)uocCreateBargainingReqBo.getBargainingItemBos()));
        UocCreateBargainingRspBo uocCreateBargainingRspBo = this.uocCreateBargainingService.createBargaining(uocCreateBargainingReqBo);
        if (!"0000".equals(uocCreateBargainingRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u8bae\u4ef7\u5355\u5931\u8d25\uff1a" + uocCreateBargainingRspBo.getRespDesc());
        }
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355\u5b8c\u6210\u51fa\u53c2\uff01" + JSON.toJSONString((Object)uocCreateBargainingRspBo));
        contextBO.setUocBargainingList(uocCreateBargainingRspBo.getUocBargainingList());
        contextBO.setBargainingParentId(uocCreateBargainingRspBo.getBargainingParentId());
    }

    private void startBargainingProcess(DycUocCreateBargainingContextBO contextBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u5f00\u59cb\u6279\u91cf\u542f\u52a8\u4e1a\u52a1\u6d41\u7a0b\uff01");
        for (UocBargainingCreateResultBo bargainingCreateInfo : contextBO.getUocBargainingList()) {
            if (!StringUtils.isEmpty((Object)this.jhBargainingBusiFlow)) {
                DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
                dycBusiProcessStartFuncReqBO.setProcDefKey(this.jhBargainingBusiFlow);
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("bargainingId", bargainingCreateInfo.getBargainingId());
                variables.put("orgId", contextBO.getOrgId());
                variables.put("orgName", contextBO.getOrgName());
                variables.put("userId", contextBO.getUserId());
                variables.put("createOperId", contextBO.getUserId());
                variables.put("userName", contextBO.getName());
                dycBusiProcessStartFuncReqBO.setVariables(variables);
                dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
                dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(bargainingCreateInfo.getBargainingId()));
                DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
                if ("0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u8bae\u4ef7\u5355\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
            }
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u9700\u8981\u542f\u52a8\u7684\u6d41\u7a0bkey");
        }
    }

    private void deleteShopCartGoods(DycUocCreateBargainingContextBO contextBO) {
        log.debug("\u521b\u5efa\u8bae\u4ef7\u5355-\u6e05\u9664\u8d2d\u7269\u8f66");
        UmcRemoveShoppingCartReqBo umcRemoveShoppingCartReqBo = new UmcRemoveShoppingCartReqBo();
        umcRemoveShoppingCartReqBo.setUserId(contextBO.getUserId());
        umcRemoveShoppingCartReqBo.setGoodsInfoList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(UmcAddShoppingCartBo.class));
        UmcRemoveShoppingCartRspBo umcRemoveShoppingCartRspBo = this.umcRemoveShoppingCartService.removeShoppingCart(umcRemoveShoppingCartReqBo);
        if (!"0000".equals(umcRemoveShoppingCartRspBo.getRespCode())) {
            throw new ZTBusinessException("\u6e05\u9664\u8d2d\u7269\u8f66\u4e2d\u672c\u6b21\u5df2\u4e0b\u5355\u7684\u5546\u54c1\u5931\u8d25\uff1a" + umcRemoveShoppingCartRspBo.getRespDesc());
        }
    }
}

