/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.config.thread.SaasThreadPool;
import com.tydic.dyc.mall.order.api.DycUocCreateOrderConcurrentService;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderContextBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderRspBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateSaleOrderBO;
import com.tydic.dyc.mall.order.impl.DycUocCreateOrderServiceImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCreateOrderConcurrentService"})
public class DycUocCreateOrderConcurrentServiceImpl
implements DycUocCreateOrderConcurrentService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCreateOrderConcurrentServiceImpl.class);
    @Autowired
    private DycUocCreateOrderServiceImpl dycUocCreateOrderService;
    @Autowired
    private SaasThreadPool saasThreadPool;
    @Value(value="${dyc.system.name:DYC}")
    private String systemName;

    @Override
    @PostMapping(value={"createOrder"})
    public DycUocCreateOrderRspBO createOrder(@RequestBody DycUocCreateOrderReqBO reqBO) {
        Instant start;
        this.dycUocCreateOrderService.verifyParam(reqBO);
        DycUocCreateOrderContextBO contextBO = (DycUocCreateOrderContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocCreateOrderContextBO.class));
        this.dycUocCreateOrderService.createOrderApproveExt(reqBO, contextBO);
        this.dycUocCreateOrderService.queryAndVerifyJdAddressInfo(contextBO);
        this.dycUocCreateOrderService.batchQuerySkuAndAgreementInfo(contextBO);
        if (reqBO.isConcurrentFlag()) {
            start = Instant.now();
            this.concurrentDeal(contextBO);
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            log.info("\u7ebf\u7a0b\u6267\u884c\u65f6\u95f4\uff1a" + duration.toMillis());
        } else {
            start = Instant.now();
            this.dycUocCreateOrderService.queryProfessionalInfo(contextBO);
            this.dycUocCreateOrderService.querySupplierInfo(contextBO);
            this.dycUocCreateOrderService.minusInventory(contextBO);
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            log.info("\u5e38\u89c4\u6267\u884c\u65f6\u95f4\uff1a" + duration.toMillis());
        }
        this.dycUocCreateOrderService.createSaleOrder(contextBO);
        this.dycUocCreateOrderService.startSaleOrderProcess(contextBO);
        log.info("\u542f\u52a8\u9500\u552e\u5355\u4e1a\u52a1\u6d41\u7a0b\u6210\u529f");
        if ("DYC".equals(this.systemName)) {
            this.dycUocCreateOrderService.minusPlan(contextBO);
        }
        this.dycUocCreateOrderService.deleteShopCartGoods(contextBO);
        this.dycUocCreateOrderService.buryPoint(contextBO);
        if ("DYC".equals(this.systemName)) {
            this.dycUocCreateOrderService.invokPrice(contextBO);
        }
        this.dycUocCreateOrderService.callBargain(contextBO);
        DycUocCreateOrderRspBO rspBO = new DycUocCreateOrderRspBO();
        rspBO.setOrderId(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
        rspBO.setSaleOrderList(JSONArray.parseArray((String)JSON.toJSONString((Object)contextBO.getCreateOrderResult().getSaleOrderList()), DycUocCreateSaleOrderBO.class));
        return rspBO;
    }

    private void concurrentDeal(DycUocCreateOrderContextBO contextBO) {
        try {
            CompletableFuture<Void> infoFuture = CompletableFuture.runAsync(() -> this.dycUocCreateOrderService.queryProfessionalInfo(contextBO), this.saasThreadPool.getExecutor());
            CompletableFuture<Void> supplierFuture = CompletableFuture.runAsync(() -> this.dycUocCreateOrderService.querySupplierInfo(contextBO), this.saasThreadPool.getExecutor());
            CompletableFuture<Void> minusInventoryFuture = CompletableFuture.runAsync(() -> this.dycUocCreateOrderService.minusInventory(contextBO), this.saasThreadPool.getExecutor());
            CompletableFuture<Void> result = CompletableFuture.allOf(infoFuture, supplierFuture, minusInventoryFuture);
            result.get();
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

