/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.settlement.advice;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.settlement.annotations.CustomRequest;
import com.tydic.settlement.base.bo.ExternalRspBO;
import com.tydic.settlement.bo.ExternalRequestRecordReqBO;
import com.tydic.settlement.service.ExternalRequestRecordService;
import com.tydic.settlement.service.SysRequestRecordService;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExternalRequestRecordAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExternalRequestRecordAdvice.class);
    private ExternalRequestRecordService externalRequestRecordService;
    private SysRequestRecordService sysRequestRecordService;

    public ExternalRequestRecordAdvice(ExternalRequestRecordService externalRequestRecordService, SysRequestRecordService sysRequestRecordService) {
        this.externalRequestRecordService = externalRequestRecordService;
        this.sysRequestRecordService = sysRequestRecordService;
    }

    @Pointcut(value="(execution(* com.tydic.settlement.service..*(..)))")
    public void apiPointCut() {
    }

    @Around(value="apiPointCut()")
    public Object doAround(ProceedingJoinPoint jp) throws Throwable {
        Method method = this.getMethod(jp);
        if (ObjectUtil.isNull((Object)method)) {
            return jp.proceed();
        }
        if (method.isAnnotationPresent(CustomRequest.class)) {
            Object result;
            Long requestId;
            CustomRequest externalRequest;
            block7: {
                externalRequest = method.getAnnotation(CustomRequest.class);
                String content = this.getContent(jp);
                JSONObject jsonObject = JSONObject.parseObject((String)content);
                requestId = null;
                result = null;
                try {
                    requestId = this.doIdempotence(externalRequest, jsonObject);
                    this.doExternalRequest(jp, externalRequest, content, jsonObject);
                    result = jp.proceed();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    if (!(throwable instanceof ZTBusinessException)) break block7;
                    if (ObjectUtil.isNotEmpty((Object)requestId)) {
                        this.sysRequestRecordService.handleFail(requestId, externalRequest.businessType());
                    }
                    if (externalRequest.isExternal()) {
                        ExternalRspBO rspBo = new ExternalRspBO();
                        return rspBo.returnFail(throwable.getMessage());
                    }
                    throw new ZTBusinessException(throwable.getMessage());
                }
            }
            if (ObjectUtil.isNotEmpty((Object)requestId)) {
                this.sysRequestRecordService.handleSuccess(requestId, externalRequest.businessType());
            }
            return result;
        }
        return jp.proceed();
    }

    private String getContent(ProceedingJoinPoint jp) {
        Object[] args = jp.getArgs();
        String content = "";
        if (ObjectUtil.isNotNull((Object)args) && args.length > 0) {
            content = JSONObject.toJSONString((Object)args[0]);
        }
        return content;
    }

    private void doExternalRequest(ProceedingJoinPoint jp, CustomRequest externalRequest, String content, JSONObject jsonObject) {
        if (externalRequest.isExternal()) {
            int businessType = externalRequest.businessType();
            String pathName = jp.getSignature().toLongString();
            Long userId = 1L;
            if (jsonObject.containsKey((Object)"userId")) {
                userId = Long.valueOf(jsonObject.getString("userId"));
            }
            ExternalRequestRecordReqBO externalRequestRecordReqBO = ExternalRequestRecordReqBO.builder().businessType(businessType).content(content).requestTime((Date)DateUtil.date()).requestOperId(userId).packetPath(pathName).build();
            this.externalRequestRecordService.add(externalRequestRecordReqBO);
        }
    }

    private Long doIdempotence(CustomRequest externalRequest, JSONObject jsonObject) {
        Long requestId = null;
        if (externalRequest.idempotence()) {
            if (!jsonObject.containsKey((Object)"serialNo")) {
                throw new ZTBusinessException("\u8bf7\u6c42\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            requestId = this.sysRequestRecordService.addIfAbsent(jsonObject.getString("serialNo"));
            if (ObjectUtil.isEmpty((Object)requestId)) {
                throw new ZTBusinessException("\u8bf7\u6c42\u91cd\u590d\u63d0\u4ea4!");
            }
        }
        return requestId;
    }

    private Method getMethod(ProceedingJoinPoint jp) {
        Object target = jp.getTarget();
        String methodName = jp.getSignature().getName();
        Method[] declaredMethods = target.getClass().getDeclaredMethods();
        Method method = Arrays.stream(declaredMethods).filter(m -> m.getName().equals(methodName)).findFirst().orElse(null);
        return method;
    }
}

