/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.settlement.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownListService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownTreeService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDropDownTreeBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListRspBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownTreeReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownTreeRspBO;
import com.tydic.settlement.bo.OrgReqBo;
import com.tydic.settlement.service.CommonService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SETTLEMENT_GROUP_DEV/1.0.0/com.tydic.settlement.service.CommonService"})
public class CommonServiceImpl
implements CommonService {
    @Autowired
    UmcQryOrgDropDownTreeService umcQryOrgDropDownTreeService;
    @Autowired
    UmcQryOrgDropDownListService umcQryOrgDropDownListService;

    @Override
    @PostMapping(value={"getChildCompanyIds"})
    public List<Long> getChildCompanyIds(@RequestBody Long companyIdIn, @RequestBody List<Long> result) {
        UmcQryOrgDropDownTreeReqBO umcQryOrgDropDownTreeReqBO = new UmcQryOrgDropDownTreeReqBO();
        umcQryOrgDropDownTreeReqBO.setParentId(companyIdIn);
        UmcQryOrgDropDownTreeRspBO umcQryOrgDropDownTreeRspBO = this.umcQryOrgDropDownTreeService.qryOrgDropDownTree(umcQryOrgDropDownTreeReqBO);
        String code = umcQryOrgDropDownTreeRspBO.getCode();
        if ("0".equals(code)) {
            List rows = umcQryOrgDropDownTreeRspBO.getRows();
            for (UmcDropDownTreeBO r : rows) {
                result.add(new Long(r.getOrgId()));
                this.getChildCompanyIds(new Long(r.getOrgId()), result);
            }
        }
        return result;
    }

    @Override
    @PostMapping(value={"getCompanyCode"})
    public String getCompanyCode(@RequestBody Long companyId) {
        UmcDropDownTreeBO company = this.getCompany(companyId);
        return company.getOrgCode();
    }

    @Override
    @PostMapping(value={"getCompanyName"})
    public String getCompanyName(@RequestBody Long companyId) {
        UmcDropDownTreeBO company = this.getCompany(companyId);
        return company.getOrgName();
    }

    private UmcDropDownTreeBO getCompany(Long companyId) {
        UmcQryOrgDropDownTreeReqBO umcQryOrgDropDownTreeReqBO = new UmcQryOrgDropDownTreeReqBO();
        umcQryOrgDropDownTreeReqBO.setOrgId(companyId);
        UmcQryOrgDropDownTreeRspBO umcQryOrgDropDownTreeRspBO = this.umcQryOrgDropDownTreeService.qryOrgDropDownTree(umcQryOrgDropDownTreeReqBO);
        String code = umcQryOrgDropDownTreeRspBO.getCode();
        if ("0".equals(code)) {
            List rows = umcQryOrgDropDownTreeRspBO.getRows();
            return (UmcDropDownTreeBO)rows.get(0);
        }
        return new UmcDropDownTreeBO();
    }

    @Override
    @PostMapping(value={"getSupplierName"})
    public String getSupplierName(@RequestBody Long supplierId) {
        return this.getSupplier(supplierId).getOrgName();
    }

    private UmcDropDownTreeBO getSupplier(Long supplierId) {
        List rows;
        UmcQryOrgDropDownListReqBO umcQryOrgDropDownListReqBO = new UmcQryOrgDropDownListReqBO();
        umcQryOrgDropDownListReqBO.setOrgTagId("2");
        umcQryOrgDropDownListReqBO.setOrgId(supplierId);
        UmcQryOrgDropDownListRspBO umcQryOrgDropDownListRspBO = this.umcQryOrgDropDownListService.qryOrgDropDownList(umcQryOrgDropDownListReqBO);
        String code = umcQryOrgDropDownListRspBO.getCode();
        UmcDropDownTreeBO umcDropDownTreeBO = new UmcDropDownTreeBO();
        if ("0".equals(code) && (rows = umcQryOrgDropDownListRspBO.getRows()).size() >= 1) {
            umcDropDownTreeBO = (UmcDropDownTreeBO)rows.get(0);
        }
        return umcDropDownTreeBO;
    }

    @Override
    @PostMapping(value={"getSupplierCode"})
    public String getSupplierCode(@RequestBody Long supplierId) {
        return this.getSupplier(supplierId).getOrgCode();
    }

    @Override
    @PostMapping(value={"getChildCompany"})
    public UmcQryOrgDropDownTreeRspBO getChildCompany(@RequestBody OrgReqBo reqBO) {
        UmcDropDownTreeBO company = this.getCompany(reqBO.getParentIdWeb());
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u673a\u6784\u4e0b\u62c9\u6846\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgIdWeb()) && ObjectUtil.isEmpty((Object)reqBO.getParentIdWeb())) {
            throw new ZTBusinessException("\u673a\u6784\u4e0b\u62c9\u6846\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        UmcQryOrgDropDownTreeReqBO abilityReqBO = new UmcQryOrgDropDownTreeReqBO();
        abilityReqBO.setOrgId(reqBO.getOrgIdWeb());
        abilityReqBO.setParentId(reqBO.getParentIdWeb());
        abilityReqBO.setOrgName(reqBO.getOrgNameWeb());
        abilityReqBO.setQueryArea(reqBO.getQueryArea());
        abilityReqBO.setOrgClassList(reqBO.getOrgClassList());
        abilityReqBO.setQryChild(reqBO.getQryChild());
        abilityReqBO.setOrgStatus(reqBO.getOrgStatus());
        abilityReqBO.setNotInOrgIds(reqBO.getNotInOrgIds());
        abilityReqBO.setOrgTagId(reqBO.getOrgTagId());
        UmcQryOrgDropDownTreeRspBO abilityRspBO = this.umcQryOrgDropDownTreeService.qryOrgDropDownTree(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u673a\u6784\u4e0b\u62c9\u6846\u67e5\u8be2:\u5931\u8d25" + abilityRspBO.getRespDesc());
        }
        List rows = abilityRspBO.getRows();
        rows.add(company);
        abilityRspBO.setRows(rows);
        return abilityRspBO;
    }
}

