<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<mapper namespace="${package.Mapper}.${table.mapperName}">

<#if enableCache>
    <!-- 开启二级缓存 -->
    <cache type="org.mybatis.caches.ehcache.LoggingEhcache"/>

</#if>
<#if baseResultMap>
    <!-- 通用查询映射结果 -->
    <resultMap id="BaseResultMap" type="${package.Entity?replace("entity","bo")}.${entity}RspBO">
<#list table.fields as field>
<#if field.keyFlag><#--生成主键排在第一位-->
        <id column="${field.name}" property="${field.propertyName}" />
</#if>
</#list>
<#list table.commonFields as field><#--生成公共字段 -->
    <result column="${field.name}" property="${field.propertyName}" />
</#list>
<#list table.fields as field>
<#if !field.keyFlag><#--生成普通字段 -->
        <result column="${field.name}" property="${field.propertyName}" />
</#if>
</#list>
    </resultMap>

</#if>
<#if baseColumnList>
    <!-- 通用查询结果列 -->
    <sql id="Base_Column_List">
<#list table.fields as field>
    <#if field_index == table.fields?size-1>
        ${field.name} AS ${field.propertyName}
        <#else >
        ${field.name} AS ${field.propertyName},
    </#if>
</#list>
    </sql>

    <sql id="Base_Column_List_t1">
<#list table.fields as field>
    <#if field_index == table.fields?size-1>
        t1.${field.name} AS ${field.propertyName}
    <#else >
        t1.${field.name} AS ${field.propertyName},
    </#if>
</#list>
    </sql>

    <sql id="select_column">
    select <include refid="Base_Column_List_t1"/><#list table.fields as field><#if field.name=="PROJECT_ID">,</#if></#list>
        <#list table.fields as field>
            <#if field.name=="PROJECT_ID">
    p.project_name as projectName
            </#if>
        </#list>
    from ${table.name} t1
    <#list table.fields as field>
        <#if field.name=="PROJECT_ID">
    left join pmc_mc_project p on t1.project_id = p.project_id
        </#if>
    </#list>
    </sql>

</#if>

    <sql id="order_contion">
        order by t1.able,t1.is_default,t1.create_time desc,t1.update_time desc
    </sql>

    <select id="get" resultMap="BaseResultMap">
        <include refid="select_column"/>
        where <#list table.fields as field><#if field.keyFlag>t1.${field.name}= #<#nt>{${field.propertyName}}</#if></#list>
    </select>

    <select id="${entity?uncap_first}Page" resultMap="BaseResultMap">
        <include refid="select_column"/>
        <#assign isDelFlag=false/>
        <#list table.fields as field>
            <#if field.name=="DEL_FLAG">
        where t1.del_flag = 'N'
                <#assign isDelFlag=true/>
            </#if>
        </#list>
        <#if isDelFlag==false>
            <where>
        </#if>
        <#list table.fields as field>
            <#if field.columnType == 'LONG' || field.columnType == 'BIGDECIMAL' || field.columnType == 'DATE'>
            <if test="map.${field.propertyName} != null and map.${field.propertyName} != ''">
                and t1.${field.name} = #<#nt>{map.${field.propertyName}}
            </if>
            </#if>
            <#if field.columnType == 'INTEGER'>
            <if test="map.${field.propertyName} != null">
                and t1.${field.name} = #<#nt>{map.${field.propertyName}}
            </if>
            </#if>
            <#if field.columnType == 'STRING'>
            <if test="map.${field.propertyName} != null and map.${field.propertyName} != ''">
                and t1.${field.name} like concat('%',#<#nt>{map.${field.propertyName}},'%')
            </if>
            </#if>
        </#list>
        <#if isDelFlag==false>
            </where>
        </#if>
    </select>

</mapper>
