/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.AttrValueBO;
import com.tydic.commodity.base.bo.CommodityPropDefIdBo;
import com.tydic.commodity.base.bo.PropertyBo;
import com.tydic.commodity.base.bo.UccTemplateExportBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetActiveColumnBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetBaseBO;
import com.tydic.commodity.base.bo.UccTemplateExportSheetRuleInfoBaseBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccQueryPropertyBusiService;
import com.tydic.commodity.busibase.busi.bo.UccQryPropReqBo;
import com.tydic.commodity.busibase.busi.bo.UccQryPropRspBo;
import com.tydic.commodity.common.ability.api.UccAgrImportUpdateTemplateExportAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrImportUpdateTemplateExportAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccAgrImportUpdateTemplateExportAbilityRspBo;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPackagePo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccMallBrandDetailInfoGroupListAbilityPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccSpuSpecPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAgrImportUpdateTemplateExportAbilityService"})
public class UccAgrImportUpdateTemplateExportAbilityServiceImpl
implements UccAgrImportUpdateTemplateExportAbilityService {
    @Value(value="${uccImportUpdate.agrDefaultTableName:defaultName}")
    private String defaultName;
    @Value(value="#{'${uccImportUpdate.defaultCommodityStatus:0}'.split(',')}")
    private List<Integer> defaultCommodityStatus;
    @Value(value="#{'${uccImportUpdate.defaultSkuStatus:0}'.split(',')}")
    private List<Integer> defaultSkuStatus;
    @Autowired
    private UccQueryPropertyBusiService uccQueryPropertyBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    public static final Integer COMMODITY_PROP_GRP = 1;
    public static final Integer SKU_PROP_GRP = 2;
    public static final Integer QRY_PROP_YES = 1;

    @PostMapping(value={"exportUpdateTemplate"})
    public UccAgrImportUpdateTemplateExportAbilityRspBo exportUpdateTemplate(@RequestBody UccAgrImportUpdateTemplateExportAbilityReqBo reqBo) {
        this.var(reqBo);
        UccAgrImportUpdateTemplateExportAbilityRspBo uccTemplateExportBaseBO = this.prepareTemplateData();
        this.populateCommoditySheet(reqBo, (UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        List<CommodityPropDefIdBo> dataSheetActiveDataList = this.populateSkuSheetData(reqBo, (UccTemplateExportBaseBO)uccTemplateExportBaseBO);
        this.populateDataSheetData((UccTemplateExportBaseBO)uccTemplateExportBaseBO, dataSheetActiveDataList);
        return uccTemplateExportBaseBO;
    }

    private List<CommodityPropDefIdBo> populateSkuSheetData(UccAgrImportUpdateTemplateExportAbilityReqBo reqBo, UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccQryPropRspBo uccQryPropRspBo = this.getProp(reqBo, SKU_PROP_GRP);
        List skuProperty = uccQryPropRspBo.getProperty();
        List addColumnInfos = ((UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(1)).getAddColumnInfos();
        Map<Long, CommodityPropDefIdBo> skuPropDefIdBoMap = skuProperty.stream().map(PropertyBo::getCommodityPropDefIds).flatMap(Collection::stream).collect(Collectors.toMap(CommodityPropDefIdBo::getCommodityPropDefId, Function.identity(), (old, cur) -> cur));
        this.createSkuTableData(skuPropDefIdBoMap, uccTemplateExportBaseBO, reqBo.getIsQryProp());
        for (CommodityPropDefIdBo commodityPropDefIdBo : skuPropDefIdBoMap.values()) {
            UccTemplateExportSheetActiveColumnBaseBO skuAddColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
            skuAddColumnInfo.setDataRuleField(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()));
            skuAddColumnInfo.setHeaderName(commodityPropDefIdBo.getPropName());
            addColumnInfos.add(skuAddColumnInfo);
        }
        return new ArrayList<CommodityPropDefIdBo>(skuPropDefIdBoMap.values());
    }

    private void populateDataSheetData(UccTemplateExportBaseBO uccTemplateExportBaseBO, List<CommodityPropDefIdBo> dataSheetActiveDataList) {
        UccTemplateExportSheetBaseBO dataSheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(2);
        List addColumnInfos = dataSheet.getAddColumnInfos();
        HashMap<String, List<String>> tableDataMap = new HashMap<String, List<String>>();
        for (CommodityPropDefIdBo commodityPropDefIdBo : dataSheetActiveDataList) {
            UccTemplateExportSheetActiveColumnBaseBO dataAddColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
            dataAddColumnInfo.setFieldName(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()));
            dataAddColumnInfo.setHeaderName(commodityPropDefIdBo.getPropName());
            addColumnInfos.add(dataAddColumnInfo);
            if (CollectionUtils.isEmpty((Collection)commodityPropDefIdBo.getAttrValues())) continue;
            tableDataMap.put(Convert.toStr((Object)commodityPropDefIdBo.getCommodityPropDefId()), commodityPropDefIdBo.getAttrValues().stream().map(AttrValueBO::getPropValue).collect(Collectors.toList()));
        }
        this.getStableData(tableDataMap);
        dataSheet.getRuleInfos().addAll(this.wrapDataTableData(tableDataMap));
    }

    private void getStableData(Map<String, List<String>> tableDataMap) {
        List skuOnShelveWayList;
        Page page = new Page(-1, -1);
        List getMallBrandDetailGroupList = this.uccBrandExtMapper.getMallBrandDetailGroupList(page, null, null, null, null);
        if (!CollectionUtils.isEmpty((Collection)getMallBrandDetailGroupList)) {
            tableDataMap.put("brand", getMallBrandDetailGroupList.stream().map(UccMallBrandDetailInfoGroupListAbilityPO::getMallBrandName).distinct().collect(Collectors.toList()));
        }
        UccCommodityPoolPO uccCommodityPoolPO = new UccCommodityPoolPO();
        uccCommodityPoolPO.setPoolState(Integer.valueOf(1));
        uccCommodityPoolPO.setPoolType(Integer.valueOf(1));
        List uccCommodityPoolPOS = this.uccCommodityPoolMapper.getList(uccCommodityPoolPO);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPoolPOS)) {
            tableDataMap.put("pool", uccCommodityPoolPOS.stream().map(UccCommodityPoolPO::getPoolName).distinct().collect(Collectors.toList()));
        }
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setStatus(Integer.valueOf(1));
        uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
            tableDataMap.put("measure", uccCommodityMeasurePos.stream().map(UccCommodityMeasurePo::getMeasureName).distinct().collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(skuOnShelveWayList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("SKU_ON_SHELVE_WAY")))) {
            tableDataMap.put("shelfWay", skuOnShelveWayList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList()));
        }
        List batchUpdateType = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("COMMODITY_BATCH_UPDATE_TYPE");
        if (!CollectionUtils.isEmpty((Collection)skuOnShelveWayList)) {
            tableDataMap.put("batchUpdateType", batchUpdateType.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList()));
        }
    }

    private List<UccTemplateExportSheetRuleInfoBaseBO> wrapDataTableData(Map<String, List<String>> tableDataMap) {
        return tableDataMap.entrySet().stream().map(e -> {
            UccTemplateExportSheetRuleInfoBaseBO uccTemplateExportSheetRuleInfoBaseBO = new UccTemplateExportSheetRuleInfoBaseBO();
            uccTemplateExportSheetRuleInfoBaseBO.setRuleValues((List)e.getValue());
            uccTemplateExportSheetRuleInfoBaseBO.setFiledCode((String)e.getKey());
            return uccTemplateExportSheetRuleInfoBaseBO;
        }).collect(Collectors.toList());
    }

    private void createSkuTableData(Map<Long, CommodityPropDefIdBo> skuPropDefIdBoMap, UccTemplateExportBaseBO uccTemplateExportBaseBO, Integer isQryProp) {
        UccTemplateExportSheetBaseBO commoditySheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(0);
        Map<Long, JSONObject> commoditySheetDataMap = commoditySheet.getTableData().stream().collect(Collectors.toMap(e -> ((JSONObject)e).getLong("commodityId"), e -> (JSONObject)e));
        UccTemplateExportSheetBaseBO skuSheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(1);
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityIds(new ArrayList<Long>(commoditySheetDataMap.keySet()));
        uccSkuPo.setSkuStatusList(this.defaultSkuStatus);
        List uccSkuPos = this.uccSkuMapper.getList(uccSkuPo);
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5355\u54c1\u6570\u636e\u4e3a\u7a7a");
        }
        List<Long> skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        Map<Long, List<UccSkuSpecPo>> skuSpecMap = this.getSkuPropMap(skuIds, isQryProp);
        List uccSkuPricePos = this.uccSkuPriceMapper.qryPriceBySkuIds(skuIds);
        Map skuPricePoMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
        JSONArray tableData = skuSheet.getTableData();
        for (int i = 0; i < uccSkuPos.size(); ++i) {
            UccSkuPricePo uccSkuPricePo;
            UccSkuPo uccSku = (UccSkuPo)uccSkuPos.get(i);
            JSONObject rowData = JSON.parseObject((String)JSON.toJSONString((Object)uccSku));
            rowData.put("rowSkuSerial", (Object)(i + 1));
            JSONObject commodityData = commoditySheetDataMap.get(uccSku.getCommodityId());
            rowData.putAll((Map)commodityData);
            if (!CollectionUtils.isEmpty((Collection)skuSpecMap.get(uccSku.getSkuId()))) {
                for (UccSkuSpecPo uccSkuSpecPo : skuSpecMap.get(uccSku.getSkuId())) {
                    rowData.put(Convert.toStr((Object)uccSkuSpecPo.getCommodityPropDefId()), (Object)uccSkuSpecPo.getPropValue());
                    this.dealMissingProp(skuPropDefIdBoMap, uccSkuSpecPo);
                }
            }
            if (null != (uccSkuPricePo = (UccSkuPricePo)skuPricePoMap.get(uccSku.getSkuId()))) {
                rowData.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)uccSkuPricePo)));
            }
            tableData.add((Object)rowData);
        }
    }

    private Map<Long, List<UccSkuSpecPo>> getSkuPropMap(List<Long> skuIds, Integer isQryProp) {
        if (QRY_PROP_YES.equals(isQryProp)) {
            List uccSkuSpecPos = this.uccSkuSpecMapper.qryBatchBySkus(skuIds);
            return uccSkuSpecPos.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
        }
        return new HashMap<Long, List<UccSkuSpecPo>>();
    }

    private void dealMissingProp(Map<Long, CommodityPropDefIdBo> skuPropDefIdBoMap, UccSkuSpecPo uccSkuSpecPo) {
        skuPropDefIdBoMap.computeIfAbsent(uccSkuSpecPo.getCommodityPropDefId(), k -> {
            CommodityPropDefIdBo commodityPropDefIdBo = new CommodityPropDefIdBo();
            commodityPropDefIdBo.setCommodityPropDefId(k);
            commodityPropDefIdBo.setPropName(uccSkuSpecPo.getPropName());
            AttrValueBO attrValueBO = new AttrValueBO();
            attrValueBO.setPropValue(uccSkuSpecPo.getPropValue());
            commodityPropDefIdBo.setAttrValues(Collections.singletonList(attrValueBO));
            return commodityPropDefIdBo;
        });
        List propValueList = skuPropDefIdBoMap.get(uccSkuSpecPo.getCommodityPropDefId()).getAttrValues().stream().map(AttrValueBO::getPropValue).collect(Collectors.toList());
        if (!propValueList.contains(uccSkuSpecPo.getPropValue())) {
            AttrValueBO attrValueBO = new AttrValueBO();
            attrValueBO.setPropValue(uccSkuSpecPo.getPropValue());
            skuPropDefIdBoMap.get(uccSkuSpecPo.getCommodityPropDefId()).getAttrValues().add(attrValueBO);
        }
    }

    private void populateCommoditySheet(UccAgrImportUpdateTemplateExportAbilityReqBo reqBo, UccTemplateExportBaseBO uccTemplateExportBaseBO) {
        UccQryPropRspBo uccQryPropRspBo = this.getProp(reqBo, COMMODITY_PROP_GRP);
        List commodityProperty = uccQryPropRspBo.getProperty();
        UccTemplateExportSheetBaseBO commoditySheet = (UccTemplateExportSheetBaseBO)uccTemplateExportBaseBO.getSheetInfos().get(0);
        List addColumnInfos = commoditySheet.getAddColumnInfos();
        for (PropertyBo propertyBo : commodityProperty) {
            List commodityPropDefIds = propertyBo.getCommodityPropDefIds();
            for (CommodityPropDefIdBo commodityPropDefId : commodityPropDefIds) {
                UccTemplateExportSheetActiveColumnBaseBO addColumnInfo = new UccTemplateExportSheetActiveColumnBaseBO();
                addColumnInfo.setHeaderName(commodityPropDefId.getPropName());
                addColumnInfo.setFieldName(Convert.toStr((Object)commodityPropDefId.getCommodityPropDefId()));
                addColumnInfos.add(addColumnInfo);
            }
        }
        this.createTableData(reqBo, commoditySheet);
    }

    private void createTableData(UccAgrImportUpdateTemplateExportAbilityReqBo reqBo, UccTemplateExportSheetBaseBO commoditySheet) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityIds(reqBo.getCommodityIds());
        uccCommodityPo.setCommodityTypeId(reqBo.getCommodityTypeId());
        uccCommodityPo.setCommodityStatusList(this.defaultCommodityStatus);
        List uccCommodityPos = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
        if (CollectionUtils.isEmpty((Collection)uccCommodityPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
        }
        List<Long> commodityIds = uccCommodityPos.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
        Map<Long, List<UccSpuSpecPo>> spuSpecMap = this.getSpuSpecMap(commodityIds, reqBo);
        List uccCommodityPackagePos = this.uccCommodityPackageMapper.queryCommdPackageByCommdityIds(commodityIds);
        Map packageMap = uccCommodityPackagePos.stream().collect(Collectors.toMap(UccCommodityPackagePo::getCommodityId, Function.identity()));
        JSONArray tableData = commoditySheet.getTableData();
        for (int i = 0; i < uccCommodityPos.size(); ++i) {
            UccCommodityPo uccCommodity = (UccCommodityPo)uccCommodityPos.get(i);
            JSONObject rowData = JSON.parseObject((String)JSON.toJSONString((Object)uccCommodity));
            rowData.put("rowCommoditySerial", (Object)(i + 1));
            if (!CollectionUtils.isEmpty((Collection)spuSpecMap.get(uccCommodity.getCommodityId()))) {
                for (UccSpuSpecPo uccSpuSpecPo : spuSpecMap.get(uccCommodity.getCommodityId())) {
                    rowData.put(Convert.toStr((Object)uccSpuSpecPo.getCommodityPropDefId()), (Object)uccSpuSpecPo.getPropValue());
                }
            }
            if (null != packageMap.get(uccCommodity.getCommodityId())) {
                rowData.put("rowPackage", (Object)((UccCommodityPackagePo)packageMap.get(uccCommodity.getCommodityId())).getPackParam());
                rowData.put("rowService", (Object)((UccCommodityPackagePo)packageMap.get(uccCommodity.getCommodityId())).getAfterService());
            }
            tableData.add((Object)rowData);
        }
    }

    private Map<Long, List<UccSpuSpecPo>> getSpuSpecMap(List<Long> commodityIds, UccAgrImportUpdateTemplateExportAbilityReqBo reqBo) {
        if (QRY_PROP_YES.equals(reqBo.getIsQryProp())) {
            List spuSpecPos = this.uccSpuSpecMapper.getSpuSpecList(commodityIds);
            return spuSpecPos.stream().collect(Collectors.groupingBy(UccSpuSpecPo::getCommodityId));
        }
        return new HashMap<Long, List<UccSpuSpecPo>>();
    }

    private UccQryPropRspBo getProp(UccAgrImportUpdateTemplateExportAbilityReqBo reqBo, Integer commodityPropGrp) {
        if (QRY_PROP_YES.equals(reqBo.getIsQryProp())) {
            UccQryPropReqBo uccQryPropReqBo = new UccQryPropReqBo();
            uccQryPropReqBo.setCommodityTypeId(reqBo.getCommodityTypeId());
            uccQryPropReqBo.setCommodityPropGrpType(commodityPropGrp);
            uccQryPropReqBo.setUserId(reqBo.getUserId());
            UccQryPropRspBo uccQryPropRspBo = this.uccQueryPropertyBusiService.queryProp(uccQryPropReqBo);
            if (!"0000".equals(uccQryPropRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5c5e\u6027\u5f02\u5e38");
            }
            return uccQryPropRspBo;
        }
        UccQryPropRspBo uccQryPropRspBo = new UccQryPropRspBo();
        uccQryPropRspBo.setProperty((List)Lists.newArrayList());
        return uccQryPropRspBo;
    }

    private UccAgrImportUpdateTemplateExportAbilityRspBo prepareTemplateData() {
        UccAgrImportUpdateTemplateExportAbilityRspBo uccTemplateExportBaseBO = new UccAgrImportUpdateTemplateExportAbilityRspBo();
        uccTemplateExportBaseBO.setTableName(this.defaultName);
        ArrayList<UccTemplateExportSheetBaseBO> sheetInfos = new ArrayList<UccTemplateExportSheetBaseBO>();
        UccTemplateExportSheetBaseBO commoditySheet = new UccTemplateExportSheetBaseBO();
        commoditySheet.setSheetName("\u5546\u54c1\u4fe1\u606f");
        commoditySheet.setHeadRowNo(Integer.valueOf(1));
        commoditySheet.setTableData(new JSONArray());
        commoditySheet.setRuleFlag("0");
        commoditySheet.setAddColumnInfos((List)Lists.newArrayList());
        sheetInfos.add(commoditySheet);
        UccTemplateExportSheetBaseBO skuSheet = new UccTemplateExportSheetBaseBO();
        skuSheet.setSheetName("\u5355\u54c1\u4fe1\u606f");
        skuSheet.setHeadRowNo(Integer.valueOf(1));
        skuSheet.setTableData(new JSONArray());
        skuSheet.setRuleFlag("0");
        skuSheet.setAddColumnInfos((List)Lists.newArrayList());
        sheetInfos.add(skuSheet);
        UccTemplateExportSheetBaseBO dataSheet = new UccTemplateExportSheetBaseBO();
        dataSheet.setSheetName("\u6570\u636e\uff08\u52ff\u5220\uff09");
        dataSheet.setHeadRowNo(Integer.valueOf(0));
        dataSheet.setTableData(new JSONArray());
        dataSheet.setRuleFlag("1");
        dataSheet.setAddColumnInfos((List)Lists.newArrayList());
        dataSheet.setRuleInfos((List)Lists.newArrayList());
        sheetInfos.add(dataSheet);
        uccTemplateExportBaseBO.setSheetInfos(sheetInfos);
        uccTemplateExportBaseBO.setRespCode("0000");
        uccTemplateExportBaseBO.setRespDesc("\u6210\u529f");
        return uccTemplateExportBaseBO;
    }

    private void var(UccAgrImportUpdateTemplateExportAbilityReqBo reqBo) {
        if (null == reqBo.getCommodityTypeId()) {
            throw new BusinessException("0002", "\u5546\u54c1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCommodityTypeName())) {
            throw new BusinessException("0002", "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityIds())) {
            throw new BusinessException("0002", "\u5546\u54c1id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

