/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SkuInfoPriceBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccAgrSkuChangePriceAbilityService;
import com.tydic.commodity.common.ability.bo.UccAgrSkuChangePriceAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAgrSkuChangePriceAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccAgrSkuChangePriceBusiService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAgrSkuChangePriceAbilityService"})
public class UccAgrSkuChangePriceAbilityServiceImpl
implements UccAgrSkuChangePriceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSkuChangePriceAbilityServiceImpl.class);
    @Autowired
    private UccAgrSkuChangePriceBusiService uccAgrSkuChangePriceBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;

    @PostMapping(value={"agrSkuChangePrice"})
    public UccAgrSkuChangePriceAbilityRspBO agrSkuChangePrice(@RequestBody UccAgrSkuChangePriceAbilityReqBO reqBO) {
        for (SkuInfoPriceBo each : reqBO.getSkuPriceInfoList()) {
            if (ObjectUtils.isEmpty((Object)each.getSkuId())) {
                throw new BusinessException("8888", "\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)each.getSupplierShopId())) {
                throw new BusinessException("8888", "\u3010supplierShopId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)each.getMarkupRate())) {
                throw new BusinessException("8888", "\u3010\u52a0\u4ef7\u6bd4\u4f8b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)each.getSalePrice())) {
                throw new BusinessException("8888", "\u3010\u9500\u552e\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)each.getAgreementPrice())) {
                throw new BusinessException("8888", "\u3010\u91c7\u8d2d\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getSalePrice().compareTo(each.getAgreementPrice()) >= 0) continue;
            throw new BusinessException("8888", "\u9500\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u91c7\u8d2d\u4ef7");
        }
        UccAgrSkuChangePriceAbilityRspBO rspBO = this.uccAgrSkuChangePriceBusiService.agrSkuChangePrice(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            Map<Long, List<SkuInfoPriceBo>> uccSkuMap = reqBO.getSkuPriceInfoList().stream().collect(Collectors.groupingBy(SkuInfoPriceBo::getSupplierShopId));
            for (Map.Entry<Long, List<SkuInfoPriceBo>> longListEntry : uccSkuMap.entrySet()) {
                List<SkuInfoPriceBo> entryValues = longListEntry.getValue();
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(entryValues.stream().map(SkuInfoPriceBo::getSkuId).collect(Collectors.toList()));
                syncSceneCommodityToEsReqBO.setSupplierId(longListEntry.getKey());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

