/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCatalogRelChannelAbilityService;
import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogRelChannelAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogRelChannelAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.common.busi.api.UccCatalogRelChannelBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCatalogRelChannelAbilityService"})
public class UccCatalogRelChannelAbilityServiceImpl
implements UccCatalogRelChannelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogRelChannelAbilityServiceImpl.class);
    @Autowired
    private UccCatalogRelChannelBusiService uccCatalogRelChannelBusiService;
    @Autowired
    private UccCatalogDealMapper cccCatalogDealMapper;
    @Autowired
    private UccReadRedisCatalogAbilityService uccReadRedisCatalogAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String uccSyncTag;

    @PostMapping(value={"relChannel"})
    public UccCatalogRelChannelAbilityRspBO relChannel(@RequestBody UccCatalogRelChannelAbilityReqBO reqBO) {
        UccCatalogRelChannelAbilityRspBO rspBO = new UccCatalogRelChannelAbilityRspBO();
        if (reqBO.getChannelId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return rspBO;
        }
        rspBO = this.uccCatalogRelChannelBusiService.relChannel(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BaseBusinessException("8888", rspBO.getRespDesc());
        }
        UccReadRdisCategoryQryReqBO uccReadRdisCategoryQryReqBO = new UccReadRdisCategoryQryReqBO();
        uccReadRdisCategoryQryReqBO.setRedisKey(reqBO.getChannelId().toString());
        this.uccReadRedisCatalogAbilityService.clearCatagoryRedis(uccReadRdisCategoryQryReqBO);
        this.uccReadRedisCatalogAbilityService.readRedisCatalog(uccReadRdisCategoryQryReqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getNeedSynCatalogIds())) {
            UccCatalogRelChannelAbilityRspBO finalRspBO = rspBO;
            CompletableFuture.supplyAsync(() -> {
                this.synEs(finalRspBO);
                return null;
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> dealData(UccCatalogRelChannelAbilityReqBO reqBO) {
        List catalogIds = reqBO.getCatalogIds();
        ArrayList<Long> dataIds = new ArrayList<Long>();
        List upperCatalogList = this.cccCatalogDealMapper.queryUpperCatalog(reqBO.getChannelId());
        if (!CollectionUtils.isEmpty((Collection)upperCatalogList)) {
            List upperCatalogIds = upperCatalogList.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(upperCatalogIds)) {
                for (Long catalogId : catalogIds) {
                    if (upperCatalogIds.contains(catalogId)) continue;
                    dataIds.add(catalogId);
                }
            }
            return dataIds;
        }
        return catalogIds;
    }

    private void synEs(UccCatalogRelChannelAbilityRspBO rspBO) {
        for (Long guiCategoryId : rspBO.getNeedSynCatalogIds()) {
            try {
                Thread.sleep(5L);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID);
                syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBo.setGuiCategoryIds(Collections.singletonList(guiCategoryId));
                syncSceneCommodityToEsReqBo.setSysSearchFlag(Boolean.valueOf(true));
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.uccSyncTopic, this.uccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            }
            catch (Exception e) {
                log.error("\u9891\u9053\u5173\u8054\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25\u5806\u6808\uff1a", (Throwable)e);
                throw new BusinessException("8888", "\u9891\u9053\u5173\u8054\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25" + e.getMessage());
            }
        }
    }
}

