/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccChannelUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccChannelUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccChannelUpdateRspBO;
import com.tydic.commodity.common.busi.api.UccChannelUpdateBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccChannelUpdateAbilityService"})
public class UccChannelUpdateAbilityServiceImpl
implements UccChannelUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccChannelUpdateAbilityServiceImpl.class);
    @Autowired
    private UccChannelUpdateBusiService UccChannelUpdateBusiService;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String uccSyncTag;

    @PostMapping(value={"updateChannel"})
    public UccChannelUpdateRspBO updateChannel(@RequestBody UccChannelUpdateReqBO reqBO) {
        UccChannelUpdateRspBO rspBO = new UccChannelUpdateRspBO();
        try {
            rspBO = this.UccChannelUpdateBusiService.updateChannel(reqBO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getPoolIds())) {
            UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
            uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(4));
            uccDealPoolSyncESAtomReqBo.setPoolIds(rspBO.getPoolIds());
            uccDealPoolSyncESAtomReqBo.setReqPoolIds(rspBO.getPoolIds());
            this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getNeedSynCatalogIds())) {
            UccChannelUpdateRspBO finalRspBO = rspBO;
            CompletableFuture.supplyAsync(() -> {
                this.synEs(finalRspBO);
                return null;
            });
        }
        return rspBO;
    }

    private void synEs(UccChannelUpdateRspBO rspBO) {
        for (Long guiCategoryId : rspBO.getNeedSynCatalogIds()) {
            try {
                Thread.sleep(5L);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID);
                syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBo.setGuiCategoryIds(Collections.singletonList(guiCategoryId));
                syncSceneCommodityToEsReqBo.setSysSearchFlag(Boolean.valueOf(true));
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.uccSyncTopic, this.uccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            }
            catch (Exception e) {
                log.error("\u9891\u9053\u5173\u8054\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25\u5806\u6808\uff1a", (Throwable)e);
                throw new BusinessException("8888", "\u9891\u9053\u5173\u8054\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25" + e.getMessage());
            }
        }
    }
}

