/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccControlBuyerService;
import com.tydic.commodity.common.ability.bo.UccControlBuyerBO;
import com.tydic.commodity.common.ability.bo.UccControlBuyerCatalogDealListRspBO;
import com.tydic.commodity.common.ability.bo.UccControlBuyerCatalogRelBO;
import com.tydic.commodity.common.ability.bo.UccControlBuyerListRspBO;
import com.tydic.commodity.common.ability.bo.UccControlBuyerReqBO;
import com.tydic.commodity.common.ability.bo.UccControlBuyerRspBO;
import com.tydic.commodity.dao.UccControlBuyerCatalogRelMapper;
import com.tydic.commodity.dao.UccControlBuyerMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccControlBuyerCatalogRelPO;
import com.tydic.commodity.po.UccControlBuyerPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccControlBuyerService"})
public class UccControlBuyerServiceImpl
implements UccControlBuyerService {
    private static final Logger log = LoggerFactory.getLogger(UccControlBuyerServiceImpl.class);
    @Autowired
    UccControlBuyerMapper uccControlBuyerMapper;
    @Autowired
    UccControlBuyerCatalogRelMapper uccControlBuyerCatalogRelMapper;
    @Autowired
    UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @PostMapping(value={"queryUccControlBuyerSingle"})
    public UccControlBuyerRspBO queryUccControlBuyerSingle(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        if (uccControlBuyerReqBO.getControlBuyerId() == null) {
            throw new ZTBusinessException("\u7ba1\u63a7\u5546\u54c1\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        UccControlBuyerPO selectUccControlBuyerPO = new UccControlBuyerPO();
        selectUccControlBuyerPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
        List uccControlBuyerList = this.uccControlBuyerMapper.selectByCondition(selectUccControlBuyerPO);
        if (uccControlBuyerList.size() == 1) {
            UccControlBuyerBO uccControlBuyerBO = (UccControlBuyerBO)JSON.parseObject((String)JSON.toJSONString(uccControlBuyerList.get(0)), UccControlBuyerBO.class);
            UccControlBuyerCatalogRelPO uccControlBuyerCatalogRelPO = new UccControlBuyerCatalogRelPO();
            uccControlBuyerCatalogRelPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
            List uccControlBuyerCatalogRelPOS = this.uccControlBuyerCatalogRelMapper.selectByConditionAll(uccControlBuyerCatalogRelPO);
            if (uccControlBuyerCatalogRelPOS.size() > 0) {
                List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccControlBuyerCatalogRelPOS), UccControlBuyerCatalogRelBO.class);
                uccControlBuyerBO.setUccControlBuyerCatalogRelBOList(list);
            }
            rspBO.setData(uccControlBuyerBO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"queryUccControlBuyerCataLogList"})
    public UccControlBuyerCatalogDealListRspBO queryUccControlBuyerCataLogList(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        return null;
    }

    @PostMapping(value={"queryUccControlBuyerListPage"})
    public UccControlBuyerListRspBO queryUccControlBuyerListPage(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        if (uccControlBuyerReqBO.getPageNo() < 1) {
            uccControlBuyerReqBO.setPageNo(1);
        }
        if (uccControlBuyerReqBO.getPageSize() < 1) {
            uccControlBuyerReqBO.setPageSize(10);
        }
        UccControlBuyerPO selectUccControlBuyerPO = (UccControlBuyerPO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerReqBO), UccControlBuyerPO.class);
        Page page = new Page(uccControlBuyerReqBO.getPageNo(), uccControlBuyerReqBO.getPageSize());
        List uccControlBuyerPOS = this.uccControlBuyerMapper.selectByConditionAll(page, selectUccControlBuyerPO);
        ArrayList<UccControlBuyerBO> uccControlBuyerBOList = new ArrayList<UccControlBuyerBO>();
        for (UccControlBuyerPO uccControlBuyerPO : uccControlBuyerPOS) {
            UccControlBuyerBO uccControlBuyerBO = (UccControlBuyerBO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerPO), UccControlBuyerBO.class);
            uccControlBuyerBOList.add(uccControlBuyerBO);
        }
        UccControlBuyerListRspBO rspPage = new UccControlBuyerListRspBO();
        rspPage.setPageNo(page.getPageNo());
        rspPage.setRows(uccControlBuyerBOList);
        rspPage.setTotal(page.getTotalPages());
        rspPage.setRecordsTotal(page.getTotalCount());
        rspPage.setRespDesc("\u6210\u529f");
        rspPage.setRespCode("0000");
        return rspPage;
    }

    @Transactional
    @PostMapping(value={"addUccControlBuyer"})
    public UccControlBuyerRspBO addUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        UccControlBuyerPO insertUccControlBuyerPO = new UccControlBuyerPO();
        BeanUtils.copyProperties((Object)uccControlBuyerReqBO, (Object)insertUccControlBuyerPO);
        long id = Sequence.getInstance().nextId();
        insertUccControlBuyerPO.setControlBuyerId(Long.valueOf(id));
        int num = this.uccControlBuyerMapper.insert(insertUccControlBuyerPO);
        if (num == 1) {
            UccControlBuyerBO UccControlBuyerBO2 = new UccControlBuyerBO();
            BeanUtils.copyProperties((Object)insertUccControlBuyerPO, (Object)UccControlBuyerBO2);
            rspBO.setData(UccControlBuyerBO2);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"addListUccControlBuyer"})
    public UccControlBuyerListRspBO addListUccControlBuyer(@RequestBody List<UccControlBuyerReqBO> uccControlBuyerReqBO) {
        UccControlBuyerListRspBO rspBO = new UccControlBuyerListRspBO();
        for (int i = 0; i < uccControlBuyerReqBO.size(); ++i) {
            long id = Sequence.getInstance().nextId();
            uccControlBuyerReqBO.get(i).setControlBuyerId(Long.valueOf(id));
        }
        List insertUccControlBuyerPO = JSONObject.parseArray((String)JSONObject.toJSONString(uccControlBuyerReqBO), UccControlBuyerPO.class);
        int num = this.uccControlBuyerMapper.allInsert(insertUccControlBuyerPO);
        if (num == uccControlBuyerReqBO.size()) {
            List lUccControlBuyerBO = JSONObject.parseArray((String)JSONObject.toJSONString((Object)insertUccControlBuyerPO), UccControlBuyerBO.class);
            rspBO.setRows(lUccControlBuyerBO);
            rspBO.setMessage("\u6210\u529f");
            rspBO.setCode("0");
        }
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"updateUccControlBuyer"})
    public UccControlBuyerRspBO updateUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        UccControlBuyerPO selectUccControlBuyerPO = new UccControlBuyerPO();
        selectUccControlBuyerPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
        List uccControlBuyerList = this.uccControlBuyerMapper.selectByCondition(selectUccControlBuyerPO);
        if (uccControlBuyerList.size() == 1) {
            UccControlBuyerPO updateUccControlBuyerPO = new UccControlBuyerPO();
            BeanUtils.copyProperties((Object)uccControlBuyerReqBO, (Object)updateUccControlBuyerPO);
            int num = this.uccControlBuyerMapper.update(updateUccControlBuyerPO);
            if (num == 1) {
                UccControlBuyerBO uccControlBuyerBO = new UccControlBuyerBO();
                BeanUtils.copyProperties((Object)updateUccControlBuyerPO, (Object)uccControlBuyerBO);
                rspBO.setData(uccControlBuyerBO);
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRespCode("0000");
            }
        }
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"saveUccControlBuyer"})
    public UccControlBuyerRspBO saveUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        UccControlBuyerPO uccControlBuyerPO;
        Date now = new Date();
        if (uccControlBuyerReqBO.getControlBuyerId() == null) {
            uccControlBuyerPO = (UccControlBuyerPO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerReqBO), UccControlBuyerPO.class);
            long id = Sequence.getInstance().nextId();
            uccControlBuyerPO.setControlBuyerId(Long.valueOf(id));
            uccControlBuyerPO.setCreateTime(now);
            uccControlBuyerPO.setUpdateTime(now);
            if (uccControlBuyerReqBO.getOperationType() == 0) {
                uccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(0));
            } else if (uccControlBuyerReqBO.getOperationType() == 1) {
                uccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(1));
            }
            uccControlBuyerPO.setDelFlag(Integer.valueOf(0));
            this.uccControlBuyerMapper.insert(uccControlBuyerPO);
            if (uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList().size() > 0) {
                ArrayList<UccControlBuyerCatalogRelPO> record = new ArrayList<UccControlBuyerCatalogRelPO>();
                UccControlBuyerPO po = new UccControlBuyerPO();
                po.setCatalogIds(uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList().stream().map(UccControlBuyerCatalogRelBO::getCatalogId).collect(Collectors.toList()));
                po.setBuyCompanyId(uccControlBuyerReqBO.getBuyCompanyId());
                List byBuyCatalogCount = this.uccControlBuyerMapper.getByBuyCatalogCount(po);
                if (!CollectionUtils.isEmpty((Collection)byBuyCatalogCount)) {
                    StringBuilder stringBuilder = new StringBuilder("");
                    byBuyCatalogCount.forEach(e -> {
                        stringBuilder.append(e.getCatalogName());
                        stringBuilder.append(",");
                    });
                    throw new ZTBusinessException(stringBuilder + "\u7c7b\u76ee\u5df2\u88ab\u8be5\u516c\u53f8\u5176\u4ed6\u90e8\u95e8\u7ba1\u63a7");
                }
                for (UccControlBuyerCatalogRelBO uccControlBuyerCatalogRelBO : uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList()) {
                    UccControlBuyerCatalogRelPO uccControlBuyerCatalogRelPO = (UccControlBuyerCatalogRelPO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerCatalogRelBO), UccControlBuyerCatalogRelPO.class);
                    record.add(uccControlBuyerCatalogRelPO);
                }
                this.dealParentCatalog(record);
                for (UccControlBuyerCatalogRelPO each : record) {
                    each.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    each.setControlBuyerId(Long.valueOf(id));
                }
                this.uccControlBuyerCatalogRelMapper.allInsert(record);
            }
        } else {
            uccControlBuyerPO = (UccControlBuyerPO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerReqBO), UccControlBuyerPO.class);
            long id = uccControlBuyerReqBO.getControlBuyerId();
            uccControlBuyerPO.setControlBuyerId(Long.valueOf(id));
            uccControlBuyerPO.setUpdateTime(now);
            if (uccControlBuyerReqBO.getOperationType() == 0) {
                uccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(0));
            } else if (uccControlBuyerReqBO.getOperationType() == 1) {
                uccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(1));
            }
            this.uccControlBuyerMapper.update(uccControlBuyerPO);
            if (uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList().size() > 0) {
                UccControlBuyerCatalogRelPO po = new UccControlBuyerCatalogRelPO();
                po.setControlBuyerId(Long.valueOf(id));
                this.uccControlBuyerCatalogRelMapper.deleteByControlBuyerId(po);
                ArrayList<UccControlBuyerCatalogRelPO> record = new ArrayList<UccControlBuyerCatalogRelPO>();
                UccControlBuyerPO po1 = new UccControlBuyerPO();
                po1.setCatalogIds(uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList().stream().map(UccControlBuyerCatalogRelBO::getCatalogId).collect(Collectors.toList()));
                po1.setBuyCompanyId(uccControlBuyerReqBO.getBuyCompanyId());
                List byBuyCatalogCount = this.uccControlBuyerMapper.getByBuyCatalogCount(po1);
                if (!CollectionUtils.isEmpty((Collection)byBuyCatalogCount)) {
                    StringBuilder stringBuilder = new StringBuilder("");
                    byBuyCatalogCount.forEach(e -> {
                        stringBuilder.append(e.getCatalogName());
                        stringBuilder.append(",");
                    });
                    throw new ZTBusinessException(stringBuilder + "\u7c7b\u76ee\u5df2\u88ab\u8be5\u516c\u53f8\u5176\u4ed6\u90e8\u95e8\u7ba1\u63a7");
                }
                for (UccControlBuyerCatalogRelBO uccControlBuyerCatalogRelBO : uccControlBuyerReqBO.getUccControlBuyerCatalogRelBOList()) {
                    UccControlBuyerCatalogRelPO uccControlBuyerCatalogRelPO = (UccControlBuyerCatalogRelPO)JSON.parseObject((String)JSON.toJSONString((Object)uccControlBuyerCatalogRelBO), UccControlBuyerCatalogRelPO.class);
                    record.add(uccControlBuyerCatalogRelPO);
                }
                this.dealParentCatalog(record);
                for (UccControlBuyerCatalogRelPO each : record) {
                    each.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    each.setControlBuyerId(Long.valueOf(id));
                }
                this.uccControlBuyerCatalogRelMapper.allInsert(record);
            }
        }
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"deleteUccControlBuyer"})
    public UccControlBuyerRspBO deleteUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        if (uccControlBuyerReqBO.getControlBuyerId() == null) {
            throw new ZTBusinessException("\u7ba1\u63a7\u5546\u54c1\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        UccControlBuyerPO selectUccControlBuyerPO = new UccControlBuyerPO();
        selectUccControlBuyerPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
        this.uccControlBuyerMapper.delete(selectUccControlBuyerPO);
        UccControlBuyerCatalogRelPO uccControlBuyerCatalogRelPO = new UccControlBuyerCatalogRelPO();
        uccControlBuyerCatalogRelPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
        this.uccControlBuyerCatalogRelMapper.delete(uccControlBuyerCatalogRelPO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"enableUccControlBuyer"})
    public UccControlBuyerRspBO enableUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        if (uccControlBuyerReqBO.getControlBuyerId() == null) {
            throw new ZTBusinessException("\u7ba1\u63a7\u5546\u54c1\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (uccControlBuyerReqBO.getEnableType() == null) {
            throw new ZTBusinessException("\u542f\u505c\u7528\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        UccControlBuyerPO selectUccControlBuyerPO = new UccControlBuyerPO();
        selectUccControlBuyerPO.setControlBuyerId(uccControlBuyerReqBO.getControlBuyerId());
        if (uccControlBuyerReqBO.getEnableType() == 0) {
            selectUccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(1));
        } else if (uccControlBuyerReqBO.getEnableType() == 1) {
            selectUccControlBuyerPO.setControlBuyerStatus(Integer.valueOf(2));
        }
        this.uccControlBuyerMapper.update(selectUccControlBuyerPO);
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"judgeUccControlBuyer"})
    public UccControlBuyerRspBO judgeUccControlBuyer(@RequestBody UccControlBuyerReqBO uccControlBuyerReqBO) {
        if (uccControlBuyerReqBO.getSkuIdList().size() < 1) {
            throw new ZTBusinessException("\u5546\u54c1id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uccControlBuyerReqBO.getBuyOrgId() == null) {
            throw new ZTBusinessException("\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uccControlBuyerReqBO.getBuyCompanyId() == null) {
            throw new ZTBusinessException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        for (Long aLong : uccControlBuyerReqBO.getSkuIdList()) {
            map.put(aLong, false);
        }
        UccControlBuyerRspBO rspBO = new UccControlBuyerRspBO();
        UccControlBuyerBO uccControlBuyerBO = new UccControlBuyerBO();
        UccControlBuyerPO uccControlBuyerPO = new UccControlBuyerPO();
        uccControlBuyerPO.setSkuIdList(uccControlBuyerReqBO.getSkuIdList());
        uccControlBuyerPO.setBuyOrgId(uccControlBuyerReqBO.getBuyOrgId());
        uccControlBuyerPO.setBuyCompanyId(uccControlBuyerReqBO.getBuyCompanyId());
        List longs = this.uccControlBuyerMapper.selectByJudgeSkuIdList(uccControlBuyerPO);
        if (longs.size() > 0) {
            for (Long aLong : longs) {
                if (!map.containsKey(aLong)) continue;
                map.put(aLong, true);
            }
        }
        uccControlBuyerBO.setIsJudgeMap(map);
        rspBO.setData(uccControlBuyerBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void dealParentCatalog(List<UccControlBuyerCatalogRelPO> record) {
        List catalogThreeList;
        UccEMdmCatalogPO qryPo3 = new UccEMdmCatalogPO();
        qryPo3.setCatalogLevel(Integer.valueOf(3));
        qryPo3.setCatalogIds(record.stream().map(UccControlBuyerCatalogRelPO::getParentCatalogId).distinct().collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)qryPo3.getCatalogIds()) && !CollectionUtils.isEmpty((Collection)(catalogThreeList = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(qryPo3)))) {
            List catalogTwoList;
            record.addAll(JUtil.jsl((List)catalogThreeList, UccControlBuyerCatalogRelPO.class));
            UccEMdmCatalogPO qryPo2 = new UccEMdmCatalogPO();
            qryPo2.setCatalogLevel(Integer.valueOf(2));
            qryPo2.setCatalogIds(catalogThreeList.stream().map(UccEMdmCatalogPO::getParentCatalogId).distinct().collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)qryPo2.getCatalogIds()) && !CollectionUtils.isEmpty((Collection)(catalogTwoList = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(qryPo2)))) {
                List catalogOneList;
                record.addAll(JUtil.jsl((List)catalogTwoList, UccControlBuyerCatalogRelPO.class));
                UccEMdmCatalogPO qryPo1 = new UccEMdmCatalogPO();
                qryPo1.setCatalogLevel(Integer.valueOf(2));
                qryPo1.setCatalogIds(catalogThreeList.stream().map(UccEMdmCatalogPO::getParentCatalogId).distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty((Collection)qryPo1.getCatalogIds()) && !CollectionUtils.isEmpty((Collection)(catalogOneList = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(qryPo1)))) {
                    record.addAll(JUtil.jsl((List)catalogOneList, UccControlBuyerCatalogRelPO.class));
                }
            }
        }
    }
}

