/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.busibase.atom.api.UccNewResetApprovalStatusAtomService;
import com.tydic.commodity.busibase.atom.bo.UccNewResetApprovalStatusAtomBO;
import com.tydic.commodity.busibase.atom.bo.UccNewResetApprovalStatusAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccNewResetApprovalStatusAtomRspBO;
import com.tydic.commodity.busibase.comb.api.UccSkuListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccLabelBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombRspBO;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommonLabelBo;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQrySkuBatchDealRecordByPageBusiService;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccRelCommodityLabelPoolPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService"})
public class UccSkuListQryAbilityServiceImpl
implements UccSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuListQryAbilityServiceImpl.class);
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuListQryCombService uccSkuListQryCombService;
    @Autowired
    private UccQrySkuBatchDealRecordByPageBusiService uccQrySkuBatchDealRecordByPageBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper uccRelCommodityLaberPoolMapper;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccNewResetApprovalStatusAtomService uccNewResetApprovalStatusAtomService;

    @PostMapping(value={"getSkuListQry"})
    public UccSkuListQryAbilityRspBO getSkuListQry(@RequestBody UccSkuListQryAbilityReqBO reqBO) {
        UccSkuListQryCombReqBO combReqBO = (UccSkuListQryCombReqBO)JUtil.js((Object)reqBO, UccSkuListQryCombReqBO.class);
        if ("2".equals(reqBO.getIsprofess())) {
            combReqBO.setAgreementPriceStar(combReqBO.getSalePriceStar());
            combReqBO.setAgreementPriceEnd(combReqBO.getSalePriceEnd());
            combReqBO.setSalePriceStar(null);
            combReqBO.setSalePriceEnd(null);
        }
        UccSkuListQryCombRspBO searchCommodityManageCombRspBo = this.uccSkuListQryCombService.getSkuListQry(combReqBO);
        if (UccConstants.IsBatchDealQry.YES.equals(reqBO.getIsBatchDealQry())) {
            UccSkuListQryAbilityRspBO rspBO = new UccSkuListQryAbilityRspBO();
            rspBO.setRespCode(searchCommodityManageCombRspBo.getRespCode());
            rspBO.setRespDesc(searchCommodityManageCombRspBo.getRespDesc());
            rspBO.setTotal(searchCommodityManageCombRspBo.getTotal());
            rspBO.setPageNo(searchCommodityManageCombRspBo.getPageNo());
            rspBO.setRecordsTotal(searchCommodityManageCombRspBo.getRecordsTotal());
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)searchCommodityManageCombRspBo.getRows()), UccSkuListQryBO.class));
            return rspBO;
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBO.getIsQryNoPicSku()) || UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBO.getIsQryNoPicSku())) {
            UccSkuListQryAbilityRspBO rspBO = new UccSkuListQryAbilityRspBO();
            rspBO.setRespCode(searchCommodityManageCombRspBo.getRespCode());
            rspBO.setRespDesc(searchCommodityManageCombRspBo.getRespDesc());
            rspBO.setTotal(searchCommodityManageCombRspBo.getTotal());
            rspBO.setPageNo(searchCommodityManageCombRspBo.getPageNo());
            rspBO.setRecordsTotal(searchCommodityManageCombRspBo.getRecordsTotal());
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)searchCommodityManageCombRspBo.getRows()), UccSkuListQryBO.class));
            return rspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)searchCommodityManageCombRspBo.getRows())) {
            Map<String, String> skuStateNewMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_STATE_NEW.toString());
            Map<String, String> commodityClassMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_CLASS.toString());
            Map<Object, Object> skuPriceMap = new HashMap();
            if (reqBO.getAuditFlag() != null && reqBO.getAuditFlag() == 1) {
                UccSkuPricePo qryPO = new UccSkuPricePo();
                List skuIds = searchCommodityManageCombRspBo.getRows().stream().map(UccSkuListCombQryBO::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuIds)) {
                    qryPO.setSkuIds(skuIds);
                    List uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(skuIds, null);
                    skuPriceMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity()));
                }
            }
            for (UccSkuListCombQryBO skuManagementListQryBO : searchCommodityManageCombRspBo.getRows()) {
                if ("2".equals(reqBO.getIsprofess())) {
                    skuManagementListQryBO.setSalePrice(skuManagementListQryBO.getAgreementPrice());
                }
                if (reqBO.getAuditFlag() != null && reqBO.getAuditFlag() == 1 && skuPriceMap.containsKey(skuManagementListQryBO.getSkuId())) {
                    skuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan((Long)((UccSkuPricePo)skuPriceMap.get(skuManagementListQryBO.getSkuId())).getMemberPrice1()));
                    skuManagementListQryBO.setMarkupRate(((UccSkuPricePo)skuPriceMap.get(skuManagementListQryBO.getSkuId())).getMarkupRateTemp());
                }
                skuManagementListQryBO.setSkuStatusDesc(skuStateNewMap.get(Convert.toStr((Object)skuManagementListQryBO.getSkuStatus())));
                skuManagementListQryBO.setCommodityClassStr(commodityClassMap.get(Convert.toStr((Object)skuManagementListQryBO.getCommodityClass())));
            }
            this.newResetStatus(searchCommodityManageCombRspBo.getRows());
        }
        String json1 = JSON.toJSONString((Object)searchCommodityManageCombRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccSkuListQryAbilityRspBO uccSkuListQryAbilityRspBO = (UccSkuListQryAbilityRspBO)JSON.parseObject((String)json1, UccSkuListQryAbilityRspBO.class);
        return uccSkuListQryAbilityRspBO;
    }

    private void qryLabel(List<UccSkuListQryBO> batchShopQryMsgBos) {
        if (CollectionUtils.isEmpty(batchShopQryMsgBos)) {
            return;
        }
        List skuIds = batchShopQryMsgBos.stream().map(UccSkuListQryBO::getSkuId).distinct().collect(Collectors.toList());
        List uccSkuPos = this.uccSkuMapper.batchQrySkuForPool(null, skuIds);
        ArrayList agrIds = new ArrayList();
        ArrayList vendorIds = new ArrayList();
        ArrayList typeIds = new ArrayList();
        ArrayList spuIds = new ArrayList();
        uccSkuPos.forEach(each -> {
            if (!agrIds.contains(each.getAgreementId()) && each.getAgreementId() != null) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId()) && each.getVendorId() != null) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId()) && each.getCommodityTypeId() != null) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId()) && each.getCommodityId() != null) {
                spuIds.add(each.getCommodityId());
            }
        });
        List UccRelPoolCommodityPosBySku = new ArrayList();
        if (!CollectionUtils.isEmpty(skuIds)) {
            UccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPools(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        List UccRelPoolCommodityPosByType = new ArrayList();
        if (!CollectionUtils.isEmpty(typeIds)) {
            UccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPools(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        List UccRelPoolCommodityPosByVendor = new ArrayList();
        if (!CollectionUtils.isEmpty(vendorIds)) {
            UccRelPoolCommodityPosByVendor = this.uccRelPoolCommodityMapper.queryPools(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        List UccRelPoolCommodityPosByAgr = new ArrayList();
        if (!CollectionUtils.isEmpty(agrIds)) {
            UccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPools(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        List UccRelPoolCommodityPosBySpu = new ArrayList();
        if (!CollectionUtils.isEmpty(spuIds)) {
            UccRelPoolCommodityPosBySpu = this.uccRelPoolCommodityMapper.queryPools(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        for (UccSkuListQryBO esStorageSpuInfoBO : batchShopQryMsgBos) {
            if (!CollectionUtils.isEmpty(UccRelPoolCommodityPosBySku)) {
                for (UccRelPoolCommodityPo UccRelPoolCommodityPo2 : UccRelPoolCommodityPosBySku) {
                    if (!UccRelPoolCommodityPo2.getSource().equals(esStorageSpuInfoBO.getSkuId())) continue;
                    if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{UccRelPoolCommodityPo2.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(UccRelPoolCommodityPo2.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(UccRelPoolCommodityPosByType)) {
                for (UccRelPoolCommodityPo UccRelPoolCommodityPo2 : UccRelPoolCommodityPosByType) {
                    if (!UccRelPoolCommodityPo2.getSource().equals(esStorageSpuInfoBO.getCommodityTypeId())) continue;
                    if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{UccRelPoolCommodityPo2.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(UccRelPoolCommodityPo2.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(UccRelPoolCommodityPosByVendor)) {
                for (UccRelPoolCommodityPo UccRelPoolCommodityPo2 : UccRelPoolCommodityPosByVendor) {
                    if (!UccRelPoolCommodityPo2.getSource().equals(Convert.toLong((Object)esStorageSpuInfoBO.getSupplierId()))) continue;
                    if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{UccRelPoolCommodityPo2.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(UccRelPoolCommodityPo2.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(UccRelPoolCommodityPosByAgr)) {
                for (UccRelPoolCommodityPo UccRelPoolCommodityPo2 : UccRelPoolCommodityPosByAgr) {
                    if (!UccRelPoolCommodityPo2.getSource().equals(esStorageSpuInfoBO.getAgreementId())) continue;
                    if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{UccRelPoolCommodityPo2.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(UccRelPoolCommodityPo2.getPoolId());
                }
            }
            if (CollectionUtils.isEmpty(UccRelPoolCommodityPosBySpu)) continue;
            for (UccRelPoolCommodityPo UccRelPoolCommodityPo2 : UccRelPoolCommodityPosBySpu) {
                if (!UccRelPoolCommodityPo2.getSource().equals(esStorageSpuInfoBO.getCommodityId())) continue;
                if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getSkuPoolIds())) {
                    esStorageSpuInfoBO.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{UccRelPoolCommodityPo2.getPoolId()}));
                    continue;
                }
                esStorageSpuInfoBO.getSkuPoolIds().add(UccRelPoolCommodityPo2.getPoolId());
            }
        }
        List skuPoos = batchShopQryMsgBos.stream().map(UccSkuListQryBO::getSkuPoolIds).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuPoos)) {
            return;
        }
        List cnncRelCommodityLabelPoolPos = this.uccRelCommodityLaberPoolMapper.queryAllInfoByPoolList(skuPoos);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cnncRelCommodityLabelPoolPos)) {
            return;
        }
        List labelPos = this.cnncCommodityLabelMapper.selectLabel(null, new ArrayList(skuPoos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)labelPos)) {
            return;
        }
        Map<Long, UccCommodityLabelPo> labelMap = labelPos.stream().collect(Collectors.toMap(UccCommodityLabelPo::getLabelId, CnncCommodityLabelPo -> CnncCommodityLabelPo, (a, b) -> a));
        Map<Long, List<UccRelCommodityLabelPoolPo>> groupByPools = cnncRelCommodityLabelPoolPos.stream().collect(Collectors.groupingBy(UccRelCommodityLabelPoolPo::getPoolId));
        HashMap poolLabels = new HashMap();
        for (Map.Entry<Long, List<UccRelCommodityLabelPoolPo>> entry : groupByPools.entrySet()) {
            ArrayList<UccLabelBo> uccLabelBOs = new ArrayList<UccLabelBo>();
            for (UccRelCommodityLabelPoolPo uccRelCommodityLabelPoolPo : entry.getValue()) {
                UccCommodityLabelPo uccCommodityLabelPo = labelMap.get(uccRelCommodityLabelPoolPo.getLabelId());
                if (null == uccCommodityLabelPo) continue;
                UccLabelBo uccLabelBO = new UccLabelBo();
                uccLabelBO.setLabelId(uccCommodityLabelPo.getLabelId());
                uccLabelBO.setLabelName(uccCommodityLabelPo.getLabelName());
                uccLabelBO.setLabelColor(uccCommodityLabelPo.getLabelColor());
                uccLabelBO.setIsShow(uccCommodityLabelPo.getIsShow());
                uccLabelBO.setLabelShortName(uccCommodityLabelPo.getLabelShortName());
                uccLabelBO.setPoolId(uccCommodityLabelPo.getPoolId());
                uccLabelBOs.add(uccLabelBO);
            }
            poolLabels.put(entry.getKey(), uccLabelBOs);
        }
        for (UccSkuListQryBO batchShopQryMsgBo : batchShopQryMsgBos) {
            HashMap<Long, UccLabelBo> skuLabelMap = new HashMap<Long, UccLabelBo>();
            List skuPoolIds = batchShopQryMsgBo.getSkuPoolIds();
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skuPoolIds)) continue;
            for (Long skuPoolId : skuPoolIds) {
                List uccLabelBOS = (List)poolLabels.get(skuPoolId);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccLabelBOS)) continue;
                for (UccLabelBo uccLabelBO : uccLabelBOS) {
                    skuLabelMap.put(uccLabelBO.getLabelId(), uccLabelBO);
                }
            }
            List list = skuLabelMap.values().stream().sorted(Comparator.comparing(UccLabelBo::getPoolId).thenComparing(UccLabelBo::getLabelId)).collect(Collectors.toList());
            batchShopQryMsgBo.setLabels(JUtil.jsl(list, UccCommonLabelBo.class));
        }
    }

    private void newResetStatus(List<UccSkuListCombQryBO> rows) {
        if (!CollectionUtils.isEmpty(rows)) {
            List uccNewResetApprovalStatusAtomBOS = rows.stream().map(uccSkuListCombQryBO -> {
                UccNewResetApprovalStatusAtomBO uccNewResetApprovalStatusAtomBO = new UccNewResetApprovalStatusAtomBO();
                uccNewResetApprovalStatusAtomBO.setObjStatus(uccSkuListCombQryBO.getSkuStatus());
                uccNewResetApprovalStatusAtomBO.setObjStatusDesc(uccSkuListCombQryBO.getSkuStatusDesc());
                uccNewResetApprovalStatusAtomBO.setObjId(uccSkuListCombQryBO.getSkuId());
                uccNewResetApprovalStatusAtomBO.setApprovalStatus(uccSkuListCombQryBO.getApprovalStatus());
                uccNewResetApprovalStatusAtomBO.setApprovalStatusDesc(uccSkuListCombQryBO.getApprovalStatusDesc());
                return uccNewResetApprovalStatusAtomBO;
            }).collect(Collectors.toList());
            UccNewResetApprovalStatusAtomReqBO reqBO = new UccNewResetApprovalStatusAtomReqBO();
            reqBO.setObjList(uccNewResetApprovalStatusAtomBOS);
            reqBO.setObjType(UccConstants.BatchObjType.SKU);
            UccNewResetApprovalStatusAtomRspBO rspBO = this.uccNewResetApprovalStatusAtomService.resetApprovalStatus(reqBO);
            if (rspBO.getObjMap() != null) {
                for (UccSkuListCombQryBO each : rows) {
                    if (!rspBO.getObjMap().containsKey(each.getSkuId())) continue;
                    each.setApprovalStatus(((UccNewResetApprovalStatusAtomBO)rspBO.getObjMap().get(each.getSkuId())).getApprovalStatus());
                    each.setApprovalStatusDesc(((UccNewResetApprovalStatusAtomBO)rspBO.getObjMap().get(each.getSkuId())).getApprovalStatusDesc());
                    each.setSkuStatus(((UccNewResetApprovalStatusAtomBO)rspBO.getObjMap().get(each.getSkuId())).getObjStatus());
                    each.setSkuStatusDesc(((UccNewResetApprovalStatusAtomBO)rspBO.getObjMap().get(each.getSkuId())).getObjStatusDesc());
                }
            }
        }
    }
}

