/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.enumType.AssignCodeEnum;
import com.tydic.commodity.base.enumType.PricessingStepsEnum;
import com.tydic.commodity.base.enumType.ProcessingStepsEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccStandardSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.StandardSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccStandardSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccAssignCodeMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccAssignCodeApplyPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccStandardSkuManagementListQryAbilityService"})
public class UccStandardSkuManagementListQryAbilityServiceImpl
implements UccStandardSkuManagementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuManagementListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccAssignCodeMapper uccAssignCodeMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"getStandardSkuManagementListQry"})
    public UccStandardSkuManagementListQryAbilityRspBO getStandardSkuManagementListQry(@RequestBody UccStandardSkuManagementListQryAbilityReqBO reqBO) {
        String result;
        String queryString;
        BoolQueryBuilder extBoolQueryBuilder;
        UccStandardSkuManagementListQryAbilityRspBO rspBO = new UccStandardSkuManagementListQryAbilityRspBO();
        if (reqBO.getStdSkuStatus().equals(1)) {
            reqBO.setStdSkuStatus(Integer.valueOf(22));
            extBoolQueryBuilder = this.buildEsSql(reqBO);
            queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            result = this.searchInfo(queryString);
            if (StringUtils.isEmpty((Object)result)) {
                rspBO.setTotal(0);
                rspBO.setRespCode("0000");
                rspBO.setRecordsTotal(0);
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            rspBO = this.dealSearchData(result, reqBO);
            for (StandardSkuManagementListQryBO standardSkuManagementListQryBO : rspBO.getRows()) {
                UccSkuManagementListQryAbilityReqBO queryOneParams = this.setQueryOneParams(reqBO);
                queryOneParams.setStdSkuId(standardSkuManagementListQryBO.getStdSkuId());
                UccSkuManagementListQryAbilityRspBO qryOneResult = this.uccSkuManagementListQryAbilityService.getSkuManagementListQry(queryOneParams);
                if (!"0000".equals(qryOneResult.getRespCode())) continue;
                String s = qryOneResult.getRows().toString();
                List resultList = JSONObject.parseArray((String)s, UccSkuManagementListQryBO.class);
                int size = resultList.size();
                standardSkuManagementListQryBO.setExSkuNum(Integer.valueOf(size));
                if (!ObjectUtil.isNotEmpty((Object)resultList)) continue;
                for (UccSkuManagementListQryBO each : resultList) {
                    each.setApplyNo(standardSkuManagementListQryBO.getApplyNo());
                    each.setApplyId(standardSkuManagementListQryBO.getApplyId());
                    each.setMatStatus(standardSkuManagementListQryBO.getMatStatus());
                    each.setMatStatusDesc(standardSkuManagementListQryBO.getMatStatusDesc());
                    each.setMaterialId(standardSkuManagementListQryBO.getMaterialId());
                    each.setMaterialCode(standardSkuManagementListQryBO.getMaterialCode());
                    each.setMaterialName(standardSkuManagementListQryBO.getMaterialName());
                }
                standardSkuManagementListQryBO.setUccSkuManagementListQryBOS(resultList);
            }
        }
        if (reqBO.getStdSkuStatus().equals(0)) {
            reqBO.setStdSkuStatus(Integer.valueOf(1));
            extBoolQueryBuilder = this.buildEsSql(reqBO);
            queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            result = this.searchInfo(queryString);
            if (StringUtils.isEmpty((Object)result)) {
                rspBO.setTotal(0);
                rspBO.setRespCode("0000");
                rspBO.setRecordsTotal(0);
                rspBO.setRows(new ArrayList());
                return rspBO;
            }
            rspBO = this.dealSearchData(result, reqBO);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCommodityCode()) || ObjectUtil.isNotEmpty((Object)reqBO.getExtSpuId()) || ObjectUtil.isNotEmpty((Object)reqBO.getSkuCode()) || ObjectUtil.isNotEmpty((Object)reqBO.getExtSkuId()) || ObjectUtil.isNotEmpty((Object)reqBO.getSkuName()) || ObjectUtil.isNotEmpty((Object)reqBO.getVendorId()) || ObjectUtil.isNotEmpty((Object)reqBO.getSkuStatus()) || ObjectUtil.isNotEmpty((Object)reqBO.getBindStatus()) || ObjectUtil.isNotEmpty((Object)reqBO.getCommodityExpand1())) {
            rspBO.getRows().removeIf(e -> ObjectUtil.isEmpty((Object)e.getUccSkuManagementListQryBOS()));
        }
        return rspBO;
    }

    private UccSkuManagementListQryAbilityReqBO setQueryOneParams(UccStandardSkuManagementListQryAbilityReqBO reqBO) {
        log.info("\u67e5\u8be2\u65e5\u5fd7\u5165\u53c2-------", (Object)reqBO);
        UccSkuManagementListQryAbilityReqBO queryReqBO = new UccSkuManagementListQryAbilityReqBO();
        ArrayList<Integer> skuStatus = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)reqBO.getSkuStatus())) {
            skuStatus.add(reqBO.getSkuStatus());
        }
        queryReqBO.setCommodityCode(reqBO.getCommodityCode());
        queryReqBO.setExtSpuId(reqBO.getExtSpuId());
        queryReqBO.setSkuCode(reqBO.getSkuCode());
        queryReqBO.setExtSkuId(reqBO.getExtSkuId());
        queryReqBO.setSkuName(reqBO.getSkuName());
        queryReqBO.setVendorId(reqBO.getVendorId());
        queryReqBO.setSkuStatus(skuStatus);
        queryReqBO.setBindStatus(reqBO.getBindStatus());
        queryReqBO.setCommodityExpand1(reqBO.getCommodityExpand1());
        queryReqBO.setSkuType(Integer.valueOf(0));
        return queryReqBO;
    }

    private BoolQueryBuilder buildEsSql(UccStandardSkuManagementListQryAbilityReqBO reqBo) {
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isEmpty((Object)reqBo.getSkuType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (int)1));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (Object)reqBo.getSkuType()));
        }
        if (reqBo.getStdSkuStatus() == 0 && !StringUtils.isEmpty((Object)reqBo.getOoocClean())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"oooc_clean", (Object)reqBo.getOoocClean()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)reqBo.getStdSkuStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getL4mgCategoryId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_type", (Object)reqBo.getCreateType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRelStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"rel_status", (Object)reqBo.getRelStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getStdSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getStdSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getStdSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLongDesc())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"long_desc.keyword", (String)("*" + reqBo.getLongDesc() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeSta())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeSta().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeSta())) {
            RangeQueryBuilder updateTimeQb = QueryBuilders.rangeQuery((String)"update_time").gte((Object)reqBo.getUpdateTimeSta().getTime());
            boolQueryBuilder.must((QueryBuilder)updateTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeEnd())) {
            RangeQueryBuilder updataTimeQb = QueryBuilders.rangeQuery((String)"update_time").lte((Object)reqBo.getUpdateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)updataTimeQb);
        }
        log.debug("\u67e5\u8be2\u6761\u4ef6" + boolQueryBuilder.toString());
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccStandardSkuManagementListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        JSONObject sortJson = new JSONObject();
        sortJson.put("update_time", (Object)"DESC");
        sortJson.put("create_time", (Object)"DESC");
        queryJson.put("sort", (Object)sortJson);
        return queryJson.toString();
    }

    private UccStandardSkuManagementListQryAbilityRspBO dealSearchData(String result, UccStandardSkuManagementListQryAbilityReqBO reqBo) {
        UccStandardSkuManagementListQryAbilityRspBO rspBO = new UccStandardSkuManagementListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBO = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBO;
    }

    private UccStandardSkuManagementListQryAbilityRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccStandardSkuManagementListQryAbilityRspBO rspBo = new UccStandardSkuManagementListQryAbilityRspBO();
        ArrayList<StandardSkuManagementListQryBO> standardSkuManagementListQryBOS = new ArrayList<StandardSkuManagementListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    StandardSkuManagementListQryBO standardSkuManagementListQryBO = this.copyBean(cnncEsCommodityBo);
                    standardSkuManagementListQryBOS.add(standardSkuManagementListQryBO);
                }
            }
            rspBo.setRows(standardSkuManagementListQryBOS);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private StandardSkuManagementListQryBO copyBean(UccCombEsCommodityBo cnncEsCommodityBo) {
        UccAssignCodeApplyPO uccAssignCodeApplyPO;
        DicDictionaryPo dicDictionaryPo;
        StandardSkuManagementListQryBO standardSkuManagementListQryBO = new StandardSkuManagementListQryBO();
        standardSkuManagementListQryBO.setCommodityId(Long.valueOf(cnncEsCommodityBo.getCommodity_id()));
        standardSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
        standardSkuManagementListQryBO.setProcessingSteps(cnncEsCommodityBo.getProcessing_steps());
        standardSkuManagementListQryBO.setSkuType(Integer.valueOf(cnncEsCommodityBo.getSku_type()));
        standardSkuManagementListQryBO.setPricePassFlag(cnncEsCommodityBo.getPrice_pass_flag());
        standardSkuManagementListQryBO.setApplyId(cnncEsCommodityBo.getApply_id());
        standardSkuManagementListQryBO.setApplyNo(cnncEsCommodityBo.getApply_no());
        standardSkuManagementListQryBO.setStdSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
        standardSkuManagementListQryBO.setStdSkuCode(cnncEsCommodityBo.getSku_code());
        standardSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
        standardSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
        standardSkuManagementListQryBO.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
        standardSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
        standardSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
        standardSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
        standardSkuManagementListQryBO.setSkuStatus(Integer.valueOf(cnncEsCommodityBo.getSku_status()));
        standardSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
        standardSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
        standardSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
        standardSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
        standardSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
        standardSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
        standardSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
        standardSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
        standardSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
        standardSkuManagementListQryBO.setBrandId(Long.valueOf(cnncEsCommodityBo.getBrand_id()));
        standardSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
        standardSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
        standardSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
        standardSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
        standardSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
        standardSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
        standardSkuManagementListQryBO.setMaterialId(cnncEsCommodityBo.getMaterial_id());
        standardSkuManagementListQryBO.setLongDesc(cnncEsCommodityBo.getLong_desc());
        standardSkuManagementListQryBO.setRelStatus(cnncEsCommodityBo.getRel_status());
        standardSkuManagementListQryBO.setStdSkuName(cnncEsCommodityBo.getSku_name());
        standardSkuManagementListQryBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc((Integer)cnncEsCommodityBo.getSku_status()).getStatusDesc());
        standardSkuManagementListQryBO.setPricePassFlagDesc(PricessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getPrice_pass_flag()));
        standardSkuManagementListQryBO.setProcessingStepsDesc(ProcessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getProcessing_steps()));
        if (cnncEsCommodityBo.getSku_approval_status() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_approval_status()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
            standardSkuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getApply_no()) && (uccAssignCodeApplyPO = this.uccAssignCodeMapper.qryassignCodeByApplyNo(cnncEsCommodityBo.getApply_no())) != null) {
            standardSkuManagementListQryBO.setMatStatus(uccAssignCodeApplyPO.getApplyStatus());
            standardSkuManagementListQryBO.setMatStatusDesc(AssignCodeEnum.getTypeDesc((Integer)uccAssignCodeApplyPO.getApplyStatus()));
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getCreate_type()) && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getCreate_type()), SkuEnum.CreationMode.toString())) != null) {
            standardSkuManagementListQryBO.setCreateType(cnncEsCommodityBo.getCreate_type());
            standardSkuManagementListQryBO.setCreateTypeDesc(dicDictionaryPo.getTitle());
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getOooc_clean())) {
            standardSkuManagementListQryBO.setOoocClean(cnncEsCommodityBo.getOooc_clean());
            standardSkuManagementListQryBO.setOoocCleanDesc(YesNoEnum.getTypeDesc((Integer)cnncEsCommodityBo.getOooc_clean()));
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getRel_status())) {
            standardSkuManagementListQryBO.setRelStatus(cnncEsCommodityBo.getRel_status());
            DicDictionaryPo associationStatusDic = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getRel_status()), SkuEnum.AssociationStatus.toString());
            standardSkuManagementListQryBO.setRelStatusDesc(associationStatusDic.getTitle());
        }
        if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_status()), SkuEnum.SKU_STATUS.toString())) != null) {
            standardSkuManagementListQryBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
            if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                standardSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
                standardSkuManagementListQryBO.setDownTypeDesc(dicDictionaryPo.getTitle());
                try {
                    UccSkuExpandPo eacRuTaskPO = new UccSkuExpandPo();
                    eacRuTaskPO.setSkuId(standardSkuManagementListQryBO.getSkuId());
                    List uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(eacRuTaskPO);
                    if (!CollectionUtils.isEmpty((Collection)uccSkuExpandPos)) {
                        standardSkuManagementListQryBO.setDownReason(((UccSkuExpandPo)uccSkuExpandPos.get(0)).getExpand16());
                    }
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u4e0b\u67b6\u539f\u56e0\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getCreate_time())) {
            standardSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getUpdate_time())) {
            standardSkuManagementListQryBO.setUpdateTime(new Date(cnncEsCommodityBo.getUpdate_time()));
        }
        if (cnncEsCommodityBo.getDown_time() != null) {
            standardSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
        }
        if (cnncEsCommodityBo.getUp_time() != null) {
            standardSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
        }
        if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
            standardSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
        }
        return standardSkuManagementListQryBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

