/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.common.ability.api.UccSupplierDiscountService;
import com.tydic.commodity.common.ability.bo.UccSupplierDiscountBO;
import com.tydic.commodity.common.ability.bo.UccSupplierDiscountListReqBO;
import com.tydic.commodity.common.ability.bo.UccSupplierDiscountListRspBO;
import com.tydic.commodity.common.ability.bo.UccSupplierDiscountReqBO;
import com.tydic.commodity.common.ability.bo.UccSupplierDiscountRspBO;
import com.tydic.commodity.dao.UccSupplierDiscountMapper;
import com.tydic.commodity.dao.UccSupplierServiceChargeMapper;
import com.tydic.commodity.po.UccSupplierDiscountPO;
import com.tydic.commodity.po.UccSupplierServiceChargePO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSupplierDiscountService"})
public class UccSupplierDiscountServiceImpl
implements UccSupplierDiscountService {
    private static final Logger log = LoggerFactory.getLogger(UccSupplierDiscountServiceImpl.class);
    @Autowired
    UccSupplierDiscountMapper supplierDiscountMapper;
    @Autowired
    UccSupplierServiceChargeMapper uccSupplierServiceChargeMapper;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;

    @PostMapping(value={"querySupplierDiscountSingle"})
    public UccSupplierDiscountRspBO querySupplierDiscountSingle(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        UccSupplierDiscountPO selectUccSupplierDiscountPO = new UccSupplierDiscountPO();
        BeanUtils.copyProperties((Object)supplierDiscountReqBO, (Object)selectUccSupplierDiscountPO);
        List supplierDiscountList = this.supplierDiscountMapper.selectByCondition(selectUccSupplierDiscountPO);
        if (supplierDiscountList.size() == 1) {
            UccSupplierDiscountBO supplierDiscountBO = new UccSupplierDiscountBO();
            BeanUtils.copyProperties(supplierDiscountList.get(0), (Object)supplierDiscountBO);
            rspBO.setData(supplierDiscountBO);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }

    @PostMapping(value={"querySupplierDiscountList"})
    public UccSupplierDiscountListRspBO querySupplierDiscountList(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        if (supplierDiscountReqBO.getChargeId() == null) {
            throw new ZTBusinessException("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UccSupplierDiscountListRspBO rspBO = new UccSupplierDiscountListRspBO();
        UccSupplierDiscountPO selectUccSupplierDiscountPO = new UccSupplierDiscountPO();
        selectUccSupplierDiscountPO.setChargeId(supplierDiscountReqBO.getChargeId());
        List supplierDiscountPOList = this.supplierDiscountMapper.selectByConditionFromCatalog(selectUccSupplierDiscountPO);
        List supplierDiscountBOList = JSON.parseArray((String)JSON.toJSONString((Object)supplierDiscountPOList), UccSupplierDiscountBO.class);
        rspBO.setData(supplierDiscountBOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"querySupplierDiscountListPage"})
    public RspPage<UccSupplierDiscountBO> querySupplierDiscountListPage(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        if (supplierDiscountReqBO.getPageNo() < 1) {
            supplierDiscountReqBO.setPageNo(1);
        }
        if (supplierDiscountReqBO.getPageSize() < 1) {
            supplierDiscountReqBO.setPageSize(10);
        }
        UccSupplierDiscountPO selectUccSupplierDiscountPO = new UccSupplierDiscountPO();
        BeanUtils.copyProperties((Object)supplierDiscountReqBO, (Object)selectUccSupplierDiscountPO);
        Page page = new Page(supplierDiscountReqBO.getPageNo(), supplierDiscountReqBO.getPageSize());
        List uccSupplierDiscountPOS = this.supplierDiscountMapper.selectByConditionByPage(page, selectUccSupplierDiscountPO);
        ArrayList<UccSupplierDiscountBO> supplierDiscountBOList = new ArrayList<UccSupplierDiscountBO>();
        for (UccSupplierDiscountPO supplierDiscountPO : uccSupplierDiscountPOS) {
            UccSupplierDiscountBO supplierDiscountBO = new UccSupplierDiscountBO();
            BeanUtils.copyProperties((Object)supplierDiscountPO, (Object)supplierDiscountBO);
            supplierDiscountBOList.add(supplierDiscountBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setRows(supplierDiscountBOList);
        rspPage.setPageNo(page.getPageNo());
        rspPage.setTotal(page.getTotalPages());
        rspPage.setRecordsTotal(page.getTotalCount());
        return rspPage;
    }

    @Transactional
    @PostMapping(value={"addSupplierDiscount"})
    public UccSupplierDiscountRspBO addSupplierDiscount(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        UccSupplierDiscountPO insertUccSupplierDiscountPO = new UccSupplierDiscountPO();
        BeanUtils.copyProperties((Object)supplierDiscountReqBO, (Object)insertUccSupplierDiscountPO);
        long id = Sequence.getInstance().nextId();
        insertUccSupplierDiscountPO.setId(Long.valueOf(id));
        int num = this.supplierDiscountMapper.insert(insertUccSupplierDiscountPO);
        if (num == 1) {
            UccSupplierDiscountBO UccSupplierDiscountBO2 = new UccSupplierDiscountBO();
            BeanUtils.copyProperties((Object)insertUccSupplierDiscountPO, (Object)UccSupplierDiscountBO2);
            rspBO.setData(UccSupplierDiscountBO2);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"addListSupplierDiscount"})
    public UccSupplierDiscountListRspBO addListSupplierDiscount(@RequestBody UccSupplierDiscountListReqBO supplierDiscountReqBO) {
        UccSupplierDiscountListRspBO rspBO = new UccSupplierDiscountListRspBO();
        if (supplierDiscountReqBO.getUccSupplierDiscountList().size() > 0) {
            ArrayList<UccSupplierDiscountPO> insertUccSupplierDiscountPO = new ArrayList<UccSupplierDiscountPO>();
            UccSupplierDiscountPO po = new UccSupplierDiscountPO();
            po.setChargeId(supplierDiscountReqBO.getChargeId());
            this.supplierDiscountMapper.deleteByChangeId(po);
            for (int i = 0; i < supplierDiscountReqBO.getUccSupplierDiscountList().size(); ++i) {
                UccSupplierDiscountPO uccSupplierDiscountPO = new UccSupplierDiscountPO();
                long id = Sequence.getInstance().nextId();
                uccSupplierDiscountPO.setId(Long.valueOf(id));
                uccSupplierDiscountPO.setChargeId(supplierDiscountReqBO.getChargeId());
                uccSupplierDiscountPO.setAgrDiscount(((UccSupplierDiscountReqBO)supplierDiscountReqBO.getUccSupplierDiscountList().get(i)).getAgrDiscount());
                uccSupplierDiscountPO.setCatalogCode(((UccSupplierDiscountReqBO)supplierDiscountReqBO.getUccSupplierDiscountList().get(i)).getCatalogCode());
                uccSupplierDiscountPO.setCatalogName(((UccSupplierDiscountReqBO)supplierDiscountReqBO.getUccSupplierDiscountList().get(i)).getCatalogName());
                uccSupplierDiscountPO.setBanSale(Integer.valueOf(0));
                insertUccSupplierDiscountPO.add(uccSupplierDiscountPO);
            }
            this.supplierDiscountMapper.allInsert(insertUccSupplierDiscountPO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"updateSupplierDiscount"})
    public UccSupplierDiscountRspBO updateSupplierDiscount(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        UccSupplierDiscountPO selectUccSupplierDiscountPO = new UccSupplierDiscountPO();
        selectUccSupplierDiscountPO.setId(supplierDiscountReqBO.getId());
        List supplierDiscountList = this.supplierDiscountMapper.selectByCondition(selectUccSupplierDiscountPO);
        if (supplierDiscountList.size() == 1) {
            UccSupplierDiscountPO updateUccSupplierDiscountPO = new UccSupplierDiscountPO();
            BeanUtils.copyProperties((Object)supplierDiscountReqBO, (Object)updateUccSupplierDiscountPO);
            int num = this.supplierDiscountMapper.update(updateUccSupplierDiscountPO);
            if (num == 1) {
                UccSupplierDiscountBO supplierDiscountBO = new UccSupplierDiscountBO();
                BeanUtils.copyProperties((Object)updateUccSupplierDiscountPO, (Object)supplierDiscountBO);
                rspBO.setData(supplierDiscountBO);
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRespCode("0000");
            }
        }
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"saveSupplierDiscount"})
    public UccSupplierDiscountRspBO saveSupplierDiscount(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        if (supplierDiscountReqBO.getId() == null) {
            return this.addSupplierDiscount(supplierDiscountReqBO);
        }
        return this.updateSupplierDiscount(supplierDiscountReqBO);
    }

    @PostMapping(value={"banSaleSupplierDiscount"})
    public UccSupplierDiscountRspBO banSaleSupplierDiscount(@RequestBody UccSupplierDiscountListReqBO supplierDiscountReqBO) {
        if (supplierDiscountReqBO.getUccSupplierDiscountList().size() < 1) {
            throw new ZTBusinessException("\u7c7b\u76ee\u96c6\u5408\u4e3a\u7a7a");
        }
        if (supplierDiscountReqBO.getBanSale() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UccSupplierDiscountPO> addSupplierDiscountPO = new ArrayList<UccSupplierDiscountPO>();
        ArrayList<UccSupplierDiscountPO> updateSupplierDiscountPO = new ArrayList<UccSupplierDiscountPO>();
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        for (UccSupplierDiscountReqBO uccSupplierDiscountReqBO : supplierDiscountReqBO.getUccSupplierDiscountList()) {
            UccSupplierDiscountPO uccSupplierDiscountPO;
            if (uccSupplierDiscountReqBO.getCatalogLevel().equals("4")) {
                catalogIds.add(uccSupplierDiscountReqBO.getCatalogId());
            }
            if (uccSupplierDiscountReqBO.getId() == null) {
                uccSupplierDiscountPO = new UccSupplierDiscountPO();
                uccSupplierDiscountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSupplierDiscountPO.setCatalogId(uccSupplierDiscountReqBO.getCatalogId());
                uccSupplierDiscountPO.setCatalogName(uccSupplierDiscountReqBO.getCatalogName());
                uccSupplierDiscountPO.setCatalogCode(uccSupplierDiscountReqBO.getCatalogCode());
                uccSupplierDiscountPO.setCatalogLevel(uccSupplierDiscountPO.getCatalogLevel());
                uccSupplierDiscountPO.setChargeId(supplierDiscountReqBO.getChargeId());
                uccSupplierDiscountPO.setBanSale(supplierDiscountReqBO.getBanSale());
                addSupplierDiscountPO.add(uccSupplierDiscountPO);
                continue;
            }
            uccSupplierDiscountPO = new UccSupplierDiscountPO();
            uccSupplierDiscountPO.setId(uccSupplierDiscountReqBO.getId());
            uccSupplierDiscountPO.setBanSale(supplierDiscountReqBO.getBanSale());
            updateSupplierDiscountPO.add(uccSupplierDiscountPO);
        }
        if (addSupplierDiscountPO.size() > 0) {
            this.supplierDiscountMapper.allInsert(addSupplierDiscountPO);
        }
        if (updateSupplierDiscountPO.size() > 0) {
            this.supplierDiscountMapper.allUpdate(updateSupplierDiscountPO, supplierDiscountReqBO.getBanSale());
        }
        if (catalogIds.size() > 0) {
            try {
                UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
                uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(7));
                uccDealPoolSyncESAtomReqBo.setVendorIds((List)Lists.newArrayList((Object[])new Long[]{supplierDiscountReqBO.getSupplierId()}));
                uccDealPoolSyncESAtomReqBo.setCatalogIds(catalogIds);
                log.info("\u6298\u6263\u7387\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo));
                this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    @PostMapping(value={"checkSupplierDiscount"})
    public UccSupplierDiscountRspBO checkSupplierDiscount(@RequestBody UccSupplierDiscountListReqBO supplierDiscountReqBO) {
        try {
            UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
            uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(7));
            uccDealPoolSyncESAtomReqBo.setVendorIds((List)Lists.newArrayList((Object[])new Long[]{supplierDiscountReqBO.getSupplierId()}));
            log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo));
            this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"timingSupplierDiscount"})
    public UccSupplierDiscountRspBO timingSupplierDiscount(@RequestBody UccSupplierDiscountReqBO supplierDiscountReqBO) {
        UccSupplierServiceChargePO uccSupplierServiceChargePO = new UccSupplierServiceChargePO();
        List uccSupplierServiceChargePOList = this.uccSupplierServiceChargeMapper.selectByConditionByAgrExpTime(uccSupplierServiceChargePO);
        if (uccSupplierServiceChargePOList.size() < 1) {
            return new UccSupplierDiscountRspBO();
        }
        this.uccSupplierServiceChargeMapper.allUpdateByChangeId(uccSupplierServiceChargePOList);
        this.supplierDiscountMapper.allUpdateByChangeId(uccSupplierServiceChargePOList);
        try {
            List collect = uccSupplierServiceChargePOList.stream().map(UccSupplierServiceChargePO::getSupplierId).collect(Collectors.toList());
            UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
            uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(7));
            uccDealPoolSyncESAtomReqBo.setVendorIds(collect);
            log.info("\u6298\u6263\u7387\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo));
            this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        UccSupplierDiscountRspBO rspBO = new UccSupplierDiscountRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

