/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.CommodityPropGrpEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.bo.UccAddPropGrpReqBO;
import com.tydic.commodity.common.ability.bo.UccAddPropGrpRspBO;
import com.tydic.commodity.common.busi.api.UccAddPropGroupBusiService;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAddPropGroupBusiServiceImpl
implements UccAddPropGroupBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    private Sequence uccBrandSequence = Sequence.getInstance();
    public static final Integer GROUP_SOURCE_ECOM = 1;

    @Override
    public UccAddPropGrpRspBO addGroup(UccAddPropGrpReqBO reqBO) {
        List commodityPropGrpTypes;
        List uccCommodityPropGrpPos;
        UccAddPropGrpRspBO rspBO = new UccAddPropGrpRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        if (reqBO.getCommodityPropGrpType() == 2 && !CollectionUtils.isEmpty((Collection)(uccCommodityPropGrpPos = this.uccCommodityPropGrpMapper.queryGroupByCommodityTypeId(reqBO.getCommodityTypeId()))) && (commodityPropGrpTypes = uccCommodityPropGrpPos.stream().filter(uccCommodityPropGrpPo -> !GROUP_SOURCE_ECOM.equals(uccCommodityPropGrpPo.getGrpSource())).map(UccCommodityPropGrpPo::getCommodityPropGrpType).collect(Collectors.toList())).contains(2)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u5df2\u7ecf\u5173\u8054\u9500\u552e\u5c5e\u6027");
            return rspBO;
        }
        Page grpPage = new Page();
        UccCommodityPropGrpPo uccCommodityPropGrpPo2 = new UccCommodityPropGrpPo();
        uccCommodityPropGrpPo2.setCommodityPropGrpCode(reqBO.getCommodityPropGrpCode());
        List listPo = this.uccCommodityPropGrpMapper.queryGroup(grpPage, uccCommodityPropGrpPo2);
        if (listPo != null && listPo.size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u7f16\u7801:" + reqBO.getCommodityPropGrpCode() + "\u5df2\u5b58\u5728");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578bID:" + reqBO.getCommodityTypeId());
            return rspBO;
        }
        UccCommodityPropGrpPo po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setCreateOperId(reqBO.getName());
        int count = 0;
        try {
            po.setCommodityPropGrpId(Long.valueOf(this.uccBrandSequence.nextId()));
            count = this.uccCommodityPropGrpMapper.addGroup(po);
        }
        catch (Exception e) {
            LOGGER.error("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        if (count < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u6210\u529f");
        rspBO.setCommodityPropGrpId(po.getCommodityPropGrpId());
        return rspBO;
    }

    private String verify(UccAddPropGrpReqBO reqBO) {
        String errMsg = "";
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpCode())) {
            errMsg = "\u5c5e\u6027\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpName())) {
            errMsg = "\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCommodityTypeId() == null || reqBO.getCommodityTypeId() == 0L) {
            errMsg = "\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("".equals(errMsg)) {
            errMsg = this.enumVerify(reqBO);
        }
        return errMsg;
    }

    private String enumVerify(UccAddPropGrpReqBO reqBO) {
        String errMsg = "";
        Map map = null;
        if (reqBO.getCommodityPropGrpType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString())).containsKey(reqBO.getCommodityPropGrpType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 commodityPropGrpType";
        }
        if (reqBO.getPropGrpStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())).containsKey(reqBO.getPropGrpStatus().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        return errMsg;
    }
}

