/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccCatalogConnectCommdTypeBusiService;
import com.tydic.commodity.common.busi.bo.UccCatalogRelCommdTypeBusiAddReqBO;
import com.tydic.commodity.common.busi.bo.UccCatalogRelCommdTypeBusiAddRspBO;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccCatalogRelCommdTypeBusiServiceImpl
implements UccCatalogConnectCommdTypeBusiService {
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    UccCatRCommdTypeMapper mapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogRelCommdTypeBusiServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @Override
    public UccCatalogRelCommdTypeBusiAddRspBO addCatalogConnectCommdType(UccCatalogRelCommdTypeBusiAddReqBO reqBO) {
        UccCatalogRelCommdTypeBusiAddRspBO rspBO = new UccCatalogRelCommdTypeBusiAddRspBO();
        String s = this.judge(reqBO, rspBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityTypeIds()) && CollectionUtils.isEmpty(rspBO.getUpdateEsTypeIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        UccCatalogConnectCommdTypeDealPO PO = new UccCatalogConnectCommdTypeDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)PO);
        int result = 0;
        try {
            this.mapper.batchMoveRelByGuideId(reqBO.getGuideCatalogId());
            if (!CollectionUtils.isEmpty(reqBO.getCommodityTypeIds())) {
                ArrayList<UccCatalogConnectCommdTypeDealPO> uccCatalogConnectCommdTypeDealPOS = new ArrayList<UccCatalogConnectCommdTypeDealPO>();
                for (Long commodityTypeId : reqBO.getCommodityTypeIds()) {
                    UccCatalogConnectCommdTypeDealPO uccCatalogConnectCommdTypeDealPO = new UccCatalogConnectCommdTypeDealPO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)uccCatalogConnectCommdTypeDealPO);
                    uccCatalogConnectCommdTypeDealPO.setCommodityTypeId(commodityTypeId);
                    uccCatalogConnectCommdTypeDealPO.setRelId(Long.valueOf(this.uccBrandSequence.nextId()));
                    uccCatalogConnectCommdTypeDealPOS.add(uccCatalogConnectCommdTypeDealPO);
                }
                result = this.mapper.addConnect(uccCatalogConnectCommdTypeDealPOS);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6570\u636e\u63d2\u5165\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63d2\u5165\u5173\u7cfb\u6210\u529f");
        return rspBO;
    }

    public String judge(UccCatalogRelCommdTypeBusiAddReqBO reqBO, UccCatalogRelCommdTypeBusiAddRspBO rspBO) {
        String s = "";
        if (reqBO.getGuideCatalogId() == null) {
            s = "\u5bfc\u8d2d\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
        UccCatalogDealPO catalogDealPO = this.uccCatalogDealMapper.selectCatalogById(uccCatalogDealPO);
        if (null == catalogDealPO) {
            s = "\u3010" + uccCatalogDealPO.getGuideCatalogId() + "\u3011\u5bfc\u8d2d\u7c7b\u76eeID\u4e0d\u5b58\u5728";
            return s;
        }
        try {
            List typeIds = this.mapper.qryCommodityTypeIds(reqBO.getGuideCatalogId());
            if (!CollectionUtils.isEmpty((Collection)typeIds)) {
                rspBO.setUpdateEsTypeIds(typeIds);
            }
            if (null != reqBO.getCommodityTypeIds()) {
                if (CollectionUtils.isEmpty(rspBO.getUpdateEsTypeIds())) {
                    rspBO.setUpdateEsTypeIds(reqBO.getCommodityTypeIds());
                } else {
                    rspBO.getUpdateEsTypeIds().addAll(reqBO.getCommodityTypeIds());
                    rspBO.setUpdateEsTypeIds(rspBO.getUpdateEsTypeIds().stream().distinct().collect(Collectors.toList()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5df2\u6709\u5173\u7cfb\u6570\u636e\u5e93\u5f02\u5e38");
        }
        return s;
    }
}

