/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.common.busi.api.UccMsearchEsService;
import com.tydic.commodity.common.busi.bo.UccMsearchEsBO;
import com.tydic.commodity.common.busi.bo.UccMsearchEsReqBO;
import com.tydic.commodity.common.busi.bo.UccMsearchEsRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMsearchEsServiceImpl
implements UccMsearchEsService {
    private static final Logger log = LoggerFactory.getLogger(UccMsearchEsServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @Override
    public UccMsearchEsRspBO mSearch(UccMsearchEsReqBO reqBO) {
        UccMsearchEsRspBO rspBO = new UccMsearchEsRspBO();
        String endPoint = "/" + this.esConfig.getIndexName() + "/_msearch";
        String queryString = this.getQueryString(reqBO);
        if (log.isDebugEnabled()) {
            log.debug("source---->" + queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            rspBO = this.dealCatalogResult(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccMsearchEsRspBO dealCatalogResult(String result) {
        UccMsearchEsRspBO rspBO = new UccMsearchEsRspBO();
        JSONObject resultObj = JSON.parseObject((String)result);
        ArrayList<UccMsearchEsBO> matchResultBos = new ArrayList<UccMsearchEsBO>();
        JSONArray matchArray = resultObj.getJSONArray("responses");
        int index = 1;
        for (int i = 0; i < matchArray.size(); ++i) {
            Integer total;
            UccMsearchEsBO uccMsearchEsBO = new UccMsearchEsBO();
            uccMsearchEsBO.setIndex(index);
            JSONObject singleObject = (JSONObject)matchArray.get(i);
            JSONObject hitsObj = (JSONObject)singleObject.get((Object)"hits");
            JSONObject aggregations = (JSONObject)singleObject.get((Object)"aggregations");
            if (aggregations != null) {
                total = aggregations.getJSONObject("cardinality_count").getInteger("value");
                uccMsearchEsBO.setTotal(total);
            } else {
                total = singleObject.getInteger("total");
                uccMsearchEsBO.setTotal(total);
            }
            if (uccMsearchEsBO.getTotal() != null && uccMsearchEsBO.getTotal() > 0) {
                JSONArray listObject = hitsObj.getJSONArray("hits");
                ArrayList<CommodityRspBo> rspBos = new ArrayList<CommodityRspBo>();
                listObject.stream().forEach(a -> {
                    CommodityRspBo each = (CommodityRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONObject)a).get((Object)"_source")), CommodityRspBo.class);
                    rspBos.add(each);
                });
                uccMsearchEsBO.setRows(rspBos);
            }
            matchResultBos.add(uccMsearchEsBO);
            ++index;
        }
        rspBO.setRows(matchResultBos);
        return rspBO;
    }

    private String getQueryString(UccMsearchEsReqBO reqBO) {
        StringBuffer querySb = new StringBuffer();
        JSONObject header = new JSONObject();
        for (String qry : reqBO.getQuery()) {
            JSONObject queryJson = JSONObject.parseObject((String)qry);
            String body = queryJson.toJSONString();
            querySb.append(header);
            querySb.append("\n");
            querySb.append(body);
            querySb.append("\n");
        }
        return querySb.toString();
    }
}

