/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.CommodityPropGrpEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.bo.UccQueryPropGrpReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryPropGrpRspBO;
import com.tydic.commodity.common.busi.api.UccQueryPropGroupBusiService;
import com.tydic.commodity.common.busi.bo.PropGrpBo;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccQueryPropGroupBusiServiceImpl
implements UccQueryPropGroupBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQueryPropGroupBusiServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQueryPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @Override
    public UccQueryPropGrpRspBO queryGroup(UccQueryPropGrpReqBO reqBO) {
        UccCommodityTypePo uccCommodityTypePo;
        UccQueryPropGrpRspBO rspBO = new UccQueryPropGrpRspBO();
        if (reqBO.getCommodityTypeId() != null && reqBO.getCommodityTypeId() != 0L && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId())) == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578bID:" + reqBO.getCommodityTypeId());
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCommodityPropGrpPo po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setGrpSource(Integer.valueOf(0));
        List listPo = this.uccCommodityPropGrpMapper.queryGroup(page, po);
        if (listPo == null || listPo.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            return rspBO;
        }
        UccEMdmCatalogPO catalogPO = this.uccEMdmCatalogMapper.qryCateLogAllNameByPropGroupId(((UccCommodityPropGrpPo)listPo.get(0)).getCommodityPropGrpId());
        if (catalogPO == null) {
            throw new BusinessException("8888", "\u5c5e\u6027\u7ec4\u5185\u7f6e\u5173\u7cfb\u4e0d\u5bf9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List<Object> propGrpBoList = new ArrayList();
        PropGrpBo propGrpBo = null;
        for (UccCommodityPropGrpPo each : listPo) {
            propGrpBo = new PropGrpBo();
            BeanUtils.copyProperties((Object)each, (Object)propGrpBo);
            propGrpBo.setMgCategoryAllName(catalogPO.getMgCategoryAllName());
            if (each.getCreateTime() != null) {
                propGrpBo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                propGrpBo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            DicDictionaryPo dicDictionaryPo = null;
            if (each.getPropGrpStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPropGrpStatus().toString(), CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())) != null) {
                propGrpBo.setPropGrpStatusTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getGrpSource() != null) {
                propGrpBo.setBusinessPropGrp(each.getGrpSource());
                String flag = each.getGrpSource() == 1 ? "\u662f" : "\u5426";
                propGrpBo.setBusinessPropGrpDesc(flag);
            }
            if (each.getCommodityPropGrpType() == null) continue;
            dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityPropGrpType().toString(), CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString());
            if (dicDictionaryPo != null) {
                propGrpBo.setPropGrpTypeTranslation(dicDictionaryPo.getTitle());
            }
            Integer count = this.uccRelPropGrpPropMapper.queryCountByDefs(each.getCommodityPropGrpId());
            propGrpBo.setCount(count);
            propGrpBoList.add(propGrpBo);
        }
        propGrpBoList = propGrpBoList.stream().distinct().collect(Collectors.toList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(propGrpBoList);
        return rspBO;
    }
}

