/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.bo.ComBatchDealObjBO;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.UccSkuInvalidByCatalogAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuInvalidByCatalogAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSkuInvalidByCatalogBusiService;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuInvalidByCatalogBusiServiceImpl
implements UccSkuInvalidByCatalogBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuInvalidByCatalogBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;

    @Override
    public UccSkuInvalidByCatalogAbilityRspBO updateSkuInvalidByCatalog(UccSkuInvalidByCatalogAbilityReqBO reqBo) {
        UccSkuInvalidByCatalogAbilityRspBO rspBO = new UccSkuInvalidByCatalogAbilityRspBO();
        ArrayList<ComBatchDealObjBO> BatchDealObjList = new ArrayList<ComBatchDealObjBO>();
        this.uccSkuMapper.batchUpdateSkuStatusByCatalogIds(Arrays.asList(reqBo.getCatalogId()), SkuStatusConstants.SKU_STATUS_INVALID);
        this.uccCommodityMapper.batchUpdateCommodityStatusByCatalogIds(Arrays.asList(reqBo.getCatalogId()), SkuStatusConstants.SKU_STATUS_INVALID);
        List<ComBatchDealObjPO> comBatchDealObjPOList = this.getOrderIds(reqBo.getCatalogId());
        this.stopProcInst(comBatchDealObjPOList, BatchDealObjList);
        rspBO.setBatchDealObjList(BatchDealObjList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void stopProcInst(List<ComBatchDealObjPO> comBatchDealObjPOList, List<ComBatchDealObjBO> BatchDealObjList) {
        if (!CollectionUtils.isEmpty(comBatchDealObjPOList)) {
            List orderIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getOrderId).distinct().collect(Collectors.toList());
            List orderIdsString = comBatchDealObjPOList.stream().map(e -> e.getOrderId().toString()).distinct().collect(Collectors.toList());
            this.eacRuTaskMapper.revokeAuditTask(orderIdsString);
            ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
            comBatchDealOrderPO.setOrderIds(orderIds);
            List comBatchDealOrderPOList = this.comBatchDealOrderMapper.getList(comBatchDealOrderPO);
            if (!CollectionUtils.isEmpty((Collection)comBatchDealOrderPOList)) {
                BatchDealObjList.addAll(JUtil.jsl((List)comBatchDealOrderPOList, ComBatchDealObjBO.class));
                List batchNoList = comBatchDealOrderPOList.stream().map(ComBatchDealOrderPO::getBatchNo).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(batchNoList)) {
                    this.comBatchDealRrecordMapper.deleteByBatchNos(batchNoList);
                }
            }
            ComBatchDealOrderPO set = new ComBatchDealOrderPO();
            set.setOrderStatus(UccConstants.BatchDealOrderObjStatus.AUDIT_REVOKE);
            set.setCurrentStatus(Integer.valueOf(-1));
            this.comBatchDealOrderMapper.updateBy(set, comBatchDealOrderPO);
        }
    }

    @NotNull
    private List<ComBatchDealObjPO> getOrderIds(Long catalogId) {
        ArrayList<ComBatchDealObjPO> comBatchDealObjPOList = new ArrayList<ComBatchDealObjPO>();
        List skuObjPos = this.uccSkuMapper.qrySkuAuditOrderList(Arrays.asList(catalogId));
        if (!CollectionUtils.isEmpty((Collection)skuObjPos)) {
            comBatchDealObjPOList.addAll(skuObjPos);
        }
        return comBatchDealObjPOList;
    }
}

