/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccSkuEditDetailInfoBo;
import com.tydic.commodity.common.atom.api.UccGoodssubjectEditAtomService;
import com.tydic.commodity.common.atom.api.UccItemEditAtomService;
import com.tydic.commodity.common.atom.bo.UccGoodssubjectEditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGoodssubjectEditAtomRspBO;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomRspBO;
import com.tydic.commodity.common.busi.api.UccSpuManagingeditorBusiService;
import com.tydic.commodity.common.busi.bo.UccSpuManagingeditorBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSpuManagingeditorBusiRspBO;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccSkuPricePo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSpuManagingeditorBusiServiceImpl
implements UccSpuManagingeditorBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuManagingeditorBusiServiceImpl.class);
    @Autowired
    private UccGoodssubjectEditAtomService uccGoodssubjectEditAtomService;
    @Autowired
    private UccItemEditAtomService uccItemEditAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @Override
    public UccSpuManagingeditorBusiRspBO dealSpuManagingeditor(UccSpuManagingeditorBusiReqBO reqBO) {
        UccSpuManagingeditorBusiRspBO rspBO = new UccSpuManagingeditorBusiRspBO();
        if (null == reqBO.getObjType() || UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType())) {
            this.editSpu(reqBO);
            this.editSku(reqBO);
        }
        if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
            this.editSku(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void editSpu(UccSpuManagingeditorBusiReqBO reqBO) {
        UccGoodssubjectEditAtomReqBO spuBusiReqBO = new UccGoodssubjectEditAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO.getEditSpuInfo(), (Object)((Object)spuBusiReqBO));
        spuBusiReqBO.setOrgId(reqBO.getOrgId());
        spuBusiReqBO.setOrgName(reqBO.getOrgName());
        spuBusiReqBO.setUserId(reqBO.getUserId());
        spuBusiReqBO.setUsername(reqBO.getUsername());
        spuBusiReqBO.setName(reqBO.getName());
        spuBusiReqBO.setOperType(reqBO.getOperType());
        spuBusiReqBO.setBatchId(reqBO.getEditBtachId());
        UccGoodssubjectEditAtomRspBO uccGoodssubjectEditAtomRspBO = null;
        try {
            uccGoodssubjectEditAtomRspBO = this.uccGoodssubjectEditAtomService.dealUccGoodssubjectEdit(spuBusiReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", e.getMessage());
        }
        if (!uccGoodssubjectEditAtomRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("8888", uccGoodssubjectEditAtomRspBO.getRespDesc());
        }
    }

    private void editSku(UccSpuManagingeditorBusiReqBO reqBO) {
        if (reqBO.getEditSpuInfo().getSkuEditInfo() != null && !reqBO.getEditSpuInfo().getSkuEditInfo().isEmpty()) {
            for (UccSkuEditDetailInfoBo each : reqBO.getEditSpuInfo().getSkuEditInfo()) {
                each.setCommodityId(reqBO.getEditSpuInfo().getCommodityId());
            }
        }
        UccItemEditAtomReqBO skuBusiReqBO = new UccItemEditAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)skuBusiReqBO));
        skuBusiReqBO.setSkuEditInfo(reqBO.getEditSpuInfo().getSkuEditInfo());
        skuBusiReqBO.setUserId(reqBO.getUserId());
        skuBusiReqBO.setUsername(reqBO.getUsername());
        skuBusiReqBO.setName(reqBO.getName());
        skuBusiReqBO.setCommodityId(reqBO.getEditSpuInfo().getCommodityId());
        skuBusiReqBO.setSupplierShopId(reqBO.getEditSpuInfo().getSupplierShopId());
        skuBusiReqBO.setBatchId(reqBO.getEditBtachId());
        skuBusiReqBO.setObjType(reqBO.getObjType());
        UccItemEditAtomRspBO uccItemEditAtomRspBO = null;
        for (UccSkuEditDetailInfoBo each : skuBusiReqBO.getSkuEditInfo()) {
            each.getSkuInfoPrice().setMarkupRate(null);
            if (!"2".equals(reqBO.getIsprofess())) continue;
            each.getSkuInfoPrice().setAgreementPrice(each.getSkuInfoPrice().getSalePrice());
            if (!UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) continue;
            List uccSkuPricePos = this.uccSkuPriceMapper.qryPriceBySkuIds(Arrays.asList(each.getSkuId()));
            each.getSkuInfoPrice().setSalePrice(((UccSkuPricePo)uccSkuPricePos.get(0)).getMarkupRate().divide(new BigDecimal(100)).add(new BigDecimal(1)).multiply(each.getSkuInfoPrice().getAgreementPrice()).setScale(2, 4));
        }
        try {
            uccItemEditAtomRspBO = this.uccItemEditAtomService.dealUccItemEdit(skuBusiReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", e.getMessage());
        }
        if (!uccItemEditAtomRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("8888", uccItemEditAtomRspBO.getRespDesc());
        }
    }
}

