/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.common.busi.api.UccXExtSkuChangeDeleteBusiService;
import com.tydic.commodity.common.busi.bo.UccXExtSkuChangeDeleteBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccXExtSkuChangeDeleteBusiRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.XStdSkuMessagePoolMapper;
import com.tydic.commodity.po.StdSkuMessagePoolPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccXExtSkuChangeDeleteBusiServiceImpl
implements UccXExtSkuChangeDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccXExtSkuChangeDeleteBusiServiceImpl.class);
    @Autowired
    private XStdSkuMessagePoolMapper xStdSkuMessagePoolMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public UccXExtSkuChangeDeleteBusiRspBO delete(UccXExtSkuChangeDeleteBusiReqBO reqBO) {
        UccXExtSkuChangeDeleteBusiRspBO rspBO = new UccXExtSkuChangeDeleteBusiRspBO();
        List<String> ids = reqBO.getId();
        if (!CollectionUtils.isEmpty(ids)) {
            ids.forEach(id -> {
                StdSkuMessagePoolPO stdSkuMessagePoolPO = new StdSkuMessagePoolPO();
                stdSkuMessagePoolPO.setMsgGetId(id);
                stdSkuMessagePoolPO.setHandleState(Integer.valueOf(1));
                int i = this.xStdSkuMessagePoolMapper.deleteRecords(stdSkuMessagePoolPO);
            });
        }
        List<StdSkuMessagePoolPO> stdSkuMessagePoolPOS = this.updateSkuStates(reqBO);
        rspBO.setResultCode("0000");
        rspBO.setSuccess(true);
        rspBO.setResultMessage("\u6210\u529f");
        rspBO.setStdSkuMessagePoolPOS(stdSkuMessagePoolPOS);
        return rspBO;
    }

    private List<StdSkuMessagePoolPO> updateSkuStates(UccXExtSkuChangeDeleteBusiReqBO reqBO) {
        log.debug("------------\u8fdb\u5165\u4fee\u6539sku\u6cbb\u7406\u73af\u8282\u65b9\u6cd5");
        List<String> ids = reqBO.getId();
        if (!CollectionUtils.isEmpty(ids)) {
            ArrayList<StdSkuMessagePoolPO> stdSkuMessagePoolPOS = new ArrayList<StdSkuMessagePoolPO>();
            for (String id : ids) {
                StdSkuMessagePoolPO stdSkuMessagePoolPO2 = this.xStdSkuMessagePoolMapper.querMsgByMsgGetId(id);
                if (!ObjectUtil.isNotEmpty((Object)stdSkuMessagePoolPO2) || !ObjectUtil.isNotEmpty((Object)stdSkuMessagePoolPO2.getSupplierShopId())) continue;
                stdSkuMessagePoolPOS.add(stdSkuMessagePoolPO2);
            }
            if (CollectionUtils.isEmpty(stdSkuMessagePoolPOS)) {
                throw new BaseBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d88\u606f\u6c60\u4fe1\u606f,[stdSkuMessagePoolPOS]\u4e3anull");
            }
            List<StdSkuMessagePoolPO> needDealSkuList = stdSkuMessagePoolPOS.stream().filter(stdSkuMessagePoolPO -> !stdSkuMessagePoolPO.getMsgGetType().equals(2) && !stdSkuMessagePoolPO.getMsgGetType().equals(3)).collect(Collectors.toList());
            for (StdSkuMessagePoolPO stdSkuMessagePoolPO2 : needDealSkuList) {
                Long skuId = stdSkuMessagePoolPO2.getSkuId();
                UccSkuPo condition = new UccSkuPo();
                condition.setSkuId(skuId);
                List uccSkuPoList = this.uccSkuMapper.qerySku(condition);
                UccSkuPo uccSkuPo = (UccSkuPo)uccSkuPoList.get(0);
                Long supplierShopId = uccSkuPo.getSupplierShopId();
                stdSkuMessagePoolPO2.setSupplierShopId(supplierShopId);
                stdSkuMessagePoolPO2.setCommodityId(uccSkuPo.getCommodityId());
                UccSkuPo updateUccSKuPo = new UccSkuPo();
                updateUccSKuPo.setSkuId(skuId);
                updateUccSKuPo.setSupplierShopId(supplierShopId);
                updateUccSKuPo.setProcessingSteps(Integer.valueOf(2));
                this.uccSkuMapper.updateSku(updateUccSKuPo);
            }
            return needDealSkuList;
        }
        throw new BaseBusinessException("8888", "\u53d8\u66f4sku\u5904\u7406\u73af\u8282\u5931\u8d25,\u5165\u53c2id\u96c6\u5408\u4e3a\u7a7a!");
    }
}

