/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceShufflingPicQryReqBO;
import com.tydic.commodity.mall.atom.api.InterfaceShufflingPicQryRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceShufflingPicQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdShufflingPicBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdCommdPicBO;
import com.tydic.commodity.mall.atom.bo.InterfaceNotJdCommdPicBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import com.tydic.dyc.resource.parse.api.ReStaticResourceParseService;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseRspBO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccShufflingPicQryService")
public class InterfaceShufflingPicQryServiceImpl
implements InterfaceShufflingPicQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceShufflingPicQryServiceImpl.class);
    @Value(value="${jd_imgPath}")
    private String jd_imgPath;
    @Autowired
    private ReStaticResourceParseService reStaticResourceParseService;
    @Value(value="${ucc.sku.replace.url.enable:true}")
    private boolean replaceUrlEnable;

    @Override
    public InterfaceShufflingPicQryRspBO qryShufflingPic(InterfaceShufflingPicQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_IMG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_IMG_URL") + "]");
                InterfaceShufflingPicQryRspBO resolveRsp = new InterfaceShufflingPicQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.HTTP_OUT_FAIL.code());
                resolveRsp.setResultMessage(UccMallConstantsEnums.HTTP_OUT_FAIL.code() + httpRetBean.getStatus());
                return resolveRsp;
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                InterfaceShufflingPicQryRspBO resolveRsp = new InterfaceShufflingPicQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_NULL_FAILED.code());
                resolveRsp.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return resolveRsp;
            }
            InterfaceShufflingPicQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            if (!CollectionUtils.isEmpty(resolveRsp.getResult())) {
                this.statisUrlReplace(reqBO, resolveRsp);
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private void statisUrlReplace(InterfaceShufflingPicQryReqBO reqBO, InterfaceShufflingPicQryRspBO resolveRsp) {
        if (!this.replaceUrlEnable) {
            return;
        }
        ArrayList<String> staticResourceUrlList = new ArrayList<String>();
        ReStaticResourceParseReqBO reStaticResourceParseReqBO = new ReStaticResourceParseReqBO();
        for (InterfaceCommdShufflingPicBO interfaceCommdShufflingPicBO : resolveRsp.getResult()) {
            if (("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) && !CollectionUtils.isEmpty(interfaceCommdShufflingPicBO.getJdCommdPicInfos())) {
                for (InterfaceJdCommdPicBO jdCommdPicInfo : interfaceCommdShufflingPicBO.getJdCommdPicInfos()) {
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jdCommdPicInfo.getPath())) continue;
                    staticResourceUrlList.add(jdCommdPicInfo.getPath());
                }
            }
            if ("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode()) || CollectionUtils.isEmpty(interfaceCommdShufflingPicBO.getNotJdCommdPicInfo())) continue;
            for (InterfaceNotJdCommdPicBO interfaceNotJdCommdPicBO : interfaceCommdShufflingPicBO.getNotJdCommdPicInfo()) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)interfaceNotJdCommdPicBO.getImgpath())) continue;
                staticResourceUrlList.add(interfaceNotJdCommdPicBO.getImgpath());
            }
        }
        if (!CollectionUtils.isEmpty(staticResourceUrlList)) {
            reStaticResourceParseReqBO.setStaticResourceUrlList(staticResourceUrlList);
            ReStaticResourceParseRspBO reStaticResourceParseRspBO = this.reStaticResourceParseService.parseStaticResource(reStaticResourceParseReqBO);
            if (!CollectionUtils.isEmpty((Collection)reStaticResourceParseRspBO.getNewStaticResourceUrlList())) {
                int i = 0;
                int size = reStaticResourceParseRspBO.getNewStaticResourceUrlList().size();
                for (InterfaceCommdShufflingPicBO interfaceCommdShufflingPicBO : resolveRsp.getResult()) {
                    if (("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) && !CollectionUtils.isEmpty(interfaceCommdShufflingPicBO.getJdCommdPicInfos())) {
                        for (InterfaceJdCommdPicBO jdCommdPicInfo : interfaceCommdShufflingPicBO.getJdCommdPicInfos()) {
                            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jdCommdPicInfo.getPath())) continue;
                            jdCommdPicInfo.setPath((String)reStaticResourceParseRspBO.getNewStaticResourceUrlList().get(i));
                            ++i;
                        }
                    }
                    if (!("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode()) || CollectionUtils.isEmpty(interfaceCommdShufflingPicBO.getNotJdCommdPicInfo()))) {
                        for (InterfaceNotJdCommdPicBO interfaceNotJdCommdPicBO : interfaceCommdShufflingPicBO.getNotJdCommdPicInfo()) {
                            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)interfaceNotJdCommdPicBO.getImgpath())) continue;
                            interfaceNotJdCommdPicBO.setImgpath((String)reStaticResourceParseRspBO.getNewStaticResourceUrlList().get(i));
                            ++i;
                        }
                    }
                    if (size - 1 != i) continue;
                    break;
                }
            }
        }
    }

    private String initReqStr(InterfaceShufflingPicQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", reqBO.getSkuIds());
        jsonObject.put("spu", (Object)reqBO.getSpuId());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private InterfaceShufflingPicQryRspBO resolveRsp(String returnString, InterfaceShufflingPicQryReqBO reqBO) {
        InterfaceShufflingPicQryRspBO rspBO = new InterfaceShufflingPicQryRspBO();
        ArrayList<InterfaceCommdShufflingPicBO> list = new ArrayList<InterfaceCommdShufflingPicBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                    rspBO.setResultCode(UccMallConstantsEnums.TOKEN_EXPIRE_FAIL.code());
                    return rspBO;
                }
                return rspBO;
            }
            if (!"jd".equals(reqBO.getSupplierCode()) && !"jdvop".equals(reqBO.getSupplierCode())) {
                JSONArray object = rspJsonObject.getJSONArray("result");
                if (null != object) {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject obj = (JSONObject)object.get(i);
                        String jsonStr = JSONObject.toJSONString((Object)obj);
                        if (StringUtils.isEmpty((Object)jsonStr)) continue;
                        InterfaceCommdShufflingPicBO commdShufflingPicBO1 = (InterfaceCommdShufflingPicBO)JSONObject.parseObject((String)jsonStr, InterfaceCommdShufflingPicBO.class);
                        if (obj.get((Object)"skuPic") != null) {
                            String skuPics = JSONObject.toJSONString((Object)obj.get((Object)"skuPic"));
                            List notJdCommdPicBOList = JSONObject.parseArray((String)skuPics, InterfaceNotJdCommdPicBO.class);
                            ArrayList<InterfaceNotJdCommdPicBO> newNotJdPicBO = new ArrayList<InterfaceNotJdCommdPicBO>();
                            if (notJdCommdPicBOList != null && notJdCommdPicBOList.size() > 0) {
                                for (InterfaceNotJdCommdPicBO notJdCommdPicBO : notJdCommdPicBOList) {
                                    String[] path;
                                    InterfaceNotJdCommdPicBO notJdCommdPicBO1 = new InterfaceNotJdCommdPicBO();
                                    BeanUtils.copyProperties((Object)notJdCommdPicBO, (Object)notJdCommdPicBO1);
                                    if ("ehsy".equals(reqBO.getSupplierCode()) && (path = notJdCommdPicBO.getImgpath().split(",")).length > 1) {
                                        InterfaceNotJdCommdPicBO ehsyPic = null;
                                        for (String each : path) {
                                            ehsyPic = new InterfaceNotJdCommdPicBO();
                                            BeanUtils.copyProperties((Object)notJdCommdPicBO, (Object)ehsyPic);
                                            ehsyPic.setImgpath(each);
                                            newNotJdPicBO.add(ehsyPic);
                                        }
                                        continue;
                                    }
                                    newNotJdPicBO.add(notJdCommdPicBO1);
                                }
                            }
                            commdShufflingPicBO1.setNotJdCommdPicInfo(newNotJdPicBO);
                        }
                        list.add(commdShufflingPicBO1);
                    }
                    rspBO.setResult(list);
                }
            } else {
                Map skuImage = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result")), Map.class);
                Set set = skuImage.keySet();
                if (set != null && set.size() > 0) {
                    for (String key : set) {
                        InterfaceCommdShufflingPicBO commdShufflingPicBO = new InterfaceCommdShufflingPicBO();
                        commdShufflingPicBO.setSku(key);
                        if (skuImage.get(key) != null) {
                            String skuImgs = JSONObject.toJSONString(skuImage.get(key));
                            List skuImgs1 = JSONObject.parseArray((String)skuImgs, InterfaceJdCommdPicBO.class);
                            ArrayList<InterfaceJdCommdPicBO> jdCommdPicBOS = new ArrayList<InterfaceJdCommdPicBO>();
                            if (skuImgs1 != null && skuImgs1.size() > 0) {
                                for (InterfaceJdCommdPicBO jdCommdPicBO : skuImgs1) {
                                    InterfaceJdCommdPicBO jdCommdPicBO1 = new InterfaceJdCommdPicBO();
                                    BeanUtils.copyProperties((Object)jdCommdPicBO, (Object)jdCommdPicBO1);
                                    jdCommdPicBO1.setPath(this.jd_imgPath + jdCommdPicBO.getPath());
                                    jdCommdPicBOS.add(jdCommdPicBO1);
                                }
                            }
                            commdShufflingPicBO.setJdCommdPicInfos(jdCommdPicBOS);
                        }
                        list.add(commdShufflingPicBO);
                    }
                }
                log.info("\u56fe\u7247" + JSONObject.toJSONString(list));
                rspBO.setResult(list);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            rspBO.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
            rspBO.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_RESOLVE_FAILED.code());
            return rspBO;
        }
    }
}

