/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.busi.api.UccMallCommdDetailsQryBusiService;
import com.tydic.commodity.mall.busi.api.UccMallOrderQrySkuDetailListBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisRspBO;
import com.tydic.commodity.mall.constants.SkuStatusConstants;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccCommodityPicPo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallSkuDetailInfoPO;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallOrderQrySkuDetailListBusiServiceImpl
implements UccMallOrderQrySkuDetailListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallOrderQrySkuDetailListBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCommdDetailsQryBusiService uccMallCommdDetailsQryBusiService;
    @Autowired
    private UccMallCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${qry.ecom.detail.compare.enable:false}")
    private Boolean compareEnable;

    /*
     * WARNING - void declaration
     */
    @Override
    public UccMallOrderQrySkuDetailLisRspBO qryOrderSkuInfo(UccMallOrderQrySkuDetailLisReqBO reqBO) {
        ArrayList<UccMallSkuDetailInfoBO> orderSkuList;
        List<Long> skus;
        List<UccMallSkuDetailInfoPO> skuInfoDetailPOS;
        UccMallOrderQrySkuDetailLisRspBO rspBO = new UccMallOrderQrySkuDetailLisRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<UccCommodityMeasurePo> measurePos = this.uccCommodityMeasureMapper.queryAll();
        Map<Long, UccCommodityMeasurePo> measureMap = null;
        if (!CollectionUtils.isEmpty(measurePos)) {
            measureMap = measurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
        }
        if (!CollectionUtils.isEmpty(skuInfoDetailPOS = this.uccMallSkuMapper.qryOrderSkusInfoList(skus = reqBO.getSkuList().stream().map(UccMallOrderQrySkuDetailLisBO::getSkuId).collect(Collectors.toList())))) {
            List<UccCommodityPicPo> commodityPicPoList;
            Map<Long, BigDecimal> skuReqStock = reqBO.getSkuList().stream().collect(Collectors.toMap(UccMallOrderQrySkuDetailLisBO::getSkuId, UccMallOrderQrySkuDetailLisBO::getNum));
            orderSkuList = new ArrayList<UccMallSkuDetailInfoBO>();
            if (skuInfoDetailPOS.size() != skus.size()) {
                throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
            }
            ArrayList<Long> notPicSpu = new ArrayList<Long>();
            for (UccMallSkuDetailInfoPO uccSkuInfoDetailPO : skuInfoDetailPOS) {
                UccMallSkuDetailInfoBO uccSkuInfoDetailBO = new UccMallSkuDetailInfoBO();
                BeanUtils.copyProperties((Object)uccSkuInfoDetailPO, (Object)uccSkuInfoDetailBO);
                for (UccMallOrderQrySkuDetailLisBO uccMallOrderQrySkuDetailLisBO : reqBO.getSkuList()) {
                    if (!uccMallOrderQrySkuDetailLisBO.getSkuId().equals(uccSkuInfoDetailBO.getSkuId())) continue;
                    uccSkuInfoDetailBO.setNum(uccMallOrderQrySkuDetailLisBO.getNum());
                    if (ObjectUtil.isNotEmpty((Object)uccMallOrderQrySkuDetailLisBO.getNumStr())) {
                        uccSkuInfoDetailBO.setKey(uccMallOrderQrySkuDetailLisBO.getSkuId() + "_" + uccMallOrderQrySkuDetailLisBO.getNumStr());
                        log.info("\u4f7f\u7528numStr\u5b57\u6bb5\u8fd4\u56de");
                        continue;
                    }
                    uccSkuInfoDetailBO.setKey(uccMallOrderQrySkuDetailLisBO.getSkuId() + "_" + uccMallOrderQrySkuDetailLisBO.getNum());
                    log.info("\u4f7f\u7528num\u5b57\u6bb5\u8fd4\u56de");
                }
                if (!uccSkuInfoDetailPO.getSkuStatus().equals(SkuStatusConstants.SKU_STATUS_ON_SHELF)) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_SELFE.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_NOT_ON_SELFE.message());
                }
                if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getMaterialName())) {
                    uccSkuInfoDetailBO.setMaterialName(uccSkuInfoDetailPO.getOrgMaterialName());
                }
                if (uccSkuInfoDetailBO.getMeasureId() != null && !measureMap.isEmpty()) {
                    if (measureMap.containsKey(uccSkuInfoDetailPO.getMeasureId())) {
                        uccSkuInfoDetailBO.setDecimalLimit(measureMap.get(uccSkuInfoDetailBO.getMeasureId()).getDecimalLimit());
                    } else {
                        log.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}", (Object)uccSkuInfoDetailBO.getMeasureId());
                    }
                }
                if (uccSkuInfoDetailPO.getMoq().compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) > 0) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_MOQ_UNMET.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_MOQ_UNMET.message());
                }
                if (uccSkuInfoDetailPO.getSwitchOn() == 1 && !CollectionUtils.isEmpty(uccSkuInfoDetailPO.getLadderPricePOList())) {
                    List uccMallLadderPriceBos = uccSkuInfoDetailPO.getLadderPricePOList().stream().map(uccLadderPricePO -> {
                        UccMallLadderPriceBo uccMallLadderPriceBo = new UccMallLadderPriceBo();
                        uccMallLadderPriceBo.setDiscount(null != uccLadderPricePO.getDiscount() ? MoneyUtils.haoToYuan(uccLadderPricePO.getDiscount()) : null);
                        uccMallLadderPriceBo.setPrice(null != uccLadderPricePO.getPrice() ? MoneyUtils.haoToYuan(uccLadderPricePO.getPrice()) : null);
                        uccMallLadderPriceBo.setStartPrice(null != uccLadderPricePO.getStart() ? MoneyUtils.haoToYuan(uccLadderPricePO.getStart()) : null);
                        uccMallLadderPriceBo.setStopPrice(null != uccLadderPricePO.getStop() ? MoneyUtils.haoToYuan(uccLadderPricePO.getStop()) : null);
                        return uccMallLadderPriceBo;
                    }).collect(Collectors.toList());
                    uccSkuInfoDetailBO.setUccMallLadderPriceBos(uccMallLadderPriceBos);
                    for (UccLadderPricePO ladderprice : uccSkuInfoDetailPO.getLadderPricePOList()) {
                        if (MoneyUtils.haoToYuan(ladderprice.getStart()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) >= 0 || ladderprice.getStop() != null && MoneyUtils.haoToYuan(ladderprice.getStop()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) < 0) continue;
                        uccSkuInfoDetailBO.setSalePrice(ladderprice.getPrice());
                    }
                }
                orderSkuList.add(uccSkuInfoDetailBO);
                if (this.compareEnable.booleanValue() && uccSkuInfoDetailBO.getSkuSource() == 2) {
                    void var14_19;
                    UccMallCommdDetailsQryBusiReqBO uccCommdDetailsQryReqBO = new UccMallCommdDetailsQryBusiReqBO();
                    uccCommdDetailsQryReqBO.setSkuId(uccSkuInfoDetailBO.getSkuId());
                    uccCommdDetailsQryReqBO.setSupplierShopId(uccSkuInfoDetailBO.getSupplierShopId());
                    Object var14_17 = null;
                    try {
                        UccMallCommdDetailsQryBusiRspBo uccMallCommdDetailsQryBusiRspBo = this.uccMallCommdDetailsQryBusiService.qryCommdDetails(uccCommdDetailsQryReqBO);
                    }
                    catch (Exception e) {
                        log.error("\u8ba2\u5355\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u8be6\u60c5\u5f02\u5e38\uff1a " + e.getMessage());
                    }
                    if (var14_19 == null) continue;
                    if (var14_19.getCommdInfo() != null) {
                        if (var14_19.getCommdInfo().getNotJdCommdDetails() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(var14_19.getCommdInfo().getNotJdCommdDetails().getName())) {
                                uccSkuInfoDetailBO.setSkuName(var14_19.getCommdInfo().getNotJdCommdDetails().getName());
                            }
                            if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                if (!uccSkuInfoDetailBO.getSkuMainPic().equals(var14_19.getCommdInfo().getNotJdCommdDetails().getImagePath())) {
                                    uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getNotJdCommdDetails().getImagePath());
                                }
                            } else {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getNotJdCommdDetails().getImagePath());
                            }
                        } else if (var14_19.getCommdInfo().getJdVedioInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(var14_19.getCommdInfo().getJdVedioInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(var14_19.getCommdInfo().getJdVedioInfo().getName());
                            }
                            if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdVedioInfo().getImage());
                            } else {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdVedioInfo().getImage());
                            }
                        } else if (var14_19.getCommdInfo().getJdBookInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(var14_19.getCommdInfo().getJdBookInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(var14_19.getCommdInfo().getJdBookInfo().getName());
                            }
                            if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdBookInfo().getImage());
                            } else {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdBookInfo().getImage());
                            }
                        } else if (var14_19.getCommdInfo().getJdCommdInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(var14_19.getCommdInfo().getJdCommdInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(var14_19.getCommdInfo().getJdCommdInfo().getName());
                            }
                            if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdCommdInfo().getImagePath());
                            } else {
                                uccSkuInfoDetailBO.setSkuMainPic(var14_19.getCommdInfo().getJdCommdInfo().getImagePath());
                            }
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) continue;
                notPicSpu.add(uccSkuInfoDetailBO.getCommodityId());
            }
            if (!CollectionUtils.isEmpty(notPicSpu) && !CollectionUtils.isEmpty(commodityPicPoList = this.uccMallCommodityPicMapper.queryBatchLesCloum(notPicSpu, null, 1))) {
                Map<Long, String> spuPicMap = commodityPicPoList.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
                for (UccMallSkuDetailInfoBO uccMallSkuDetailInfoBO : orderSkuList) {
                    if (!spuPicMap.containsKey(uccMallSkuDetailInfoBO.getCommodityId())) continue;
                    uccMallSkuDetailInfoBO.setSkuMainPic(spuPicMap.get(uccMallSkuDetailInfoBO.getCommodityId()));
                }
            }
        } else {
            throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
        }
        rspBO.setOrderSkuList(orderSkuList);
        return rspBO;
    }
}

