/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallOrderColumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSourceTypeBo;
import com.tydic.commodity.mall.busi.api.UccMallSearchProportionEsService;
import com.tydic.commodity.mall.busi.bo.UccMallCloumnIndxBo;
import com.tydic.commodity.mall.busi.bo.UccMallQueryParamBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchInfoBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchProportionReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallSearchProportionEsServiceImpl
implements UccMallSearchProportionEsService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchProportionEsServiceImpl.class);

    @Override
    public UccMallSearchEsSQLRspBO buildSQL(UccMallSearchProportionReqBO searchEsSQLReqBO) {
        UccMallSearchEsSQLRspBO searchBarEsSQLRspBO = new UccMallSearchEsSQLRspBO();
        BoolQueryBuilder extBoolQueryBuilder = null;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(searchEsSQLReqBO.getSearchInfo())) {
            long[] skus;
            extBoolQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder inBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccMallSearchInfoBo each : searchEsSQLReqBO.getSearchInfo()) {
                if (each.getSearchCloumn().size() == 1 || each.getSearchType() == 5) {
                    if (each.getSearchType() == 1) {
                        if (each.getQryString().contains(",")) {
                            String[] split = each.getQryString().split(",");
                            List<String> strings = Arrays.asList(split);
                            strings.removeIf(Objects::isNull);
                            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)each.getSearchCloumn().get(0).getEsCloumn(), strings));
                            continue;
                        }
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)each.getSearchCloumn().get(0).getEsCloumn(), (String)each.getQryString()));
                        continue;
                    }
                    if (each.getSearchType() == 2) {
                        String[] fileNames = each.getSearchCloumn().stream().map(UccMallCloumnIndxBo::getEsCloumn).collect(Collectors.toList()).toArray(new String[0]);
                        inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)each.getQryString(), (String[])fileNames).minimumShouldMatch("95%").type(MultiMatchQueryBuilder.Type.MOST_FIELDS).analyzer("ik_smart").boost(each.getProportion().floatValue()));
                        continue;
                    }
                    if (each.getSearchType() == 4) {
                        RangeQueryBuilder qb = null;
                        if (each.getSearchCloumn().get(0).getCloumnType() != 1 && each.getSearchCloumn().get(0).getCloumnType() != 2 || each.getMax() == null || each.getMin() == null) continue;
                        if (each.getMax().compareTo(each.getMin()) < 0) {
                            throw new ZTBusinessException("\u8303\u56f4\u68c0\u7d22\uff0c\u6700\u5927\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u5c0f\u503c");
                        }
                        if (each.getMin() != null) {
                            qb = QueryBuilders.rangeQuery((String)each.getSearchCloumn().get(0).getEsCloumn().toString()).gte((Object)each.getMin().toString());
                        }
                        if (each.getMax() != null) {
                            if (qb == null) {
                                qb = QueryBuilders.rangeQuery((String)each.getSearchCloumn().get(0).getEsCloumn().toString()).lte((Object)each.getMax().toString());
                            } else {
                                qb.lte((Object)each.getMax().toString());
                            }
                        }
                        extBoolQueryBuilder.must(qb);
                        continue;
                    }
                    if (each.getSearchType() == 5) {
                        if (each.getSearchCloumn().size() > 1) {
                            BoolQueryBuilder materialExtBoolQueryBuilder = QueryBuilders.boolQuery();
                            for (UccMallCloumnIndxBo item : each.getSearchCloumn()) {
                                BoolQueryBuilder materialInBoolQueryBuilder = QueryBuilders.boolQuery();
                                materialInBoolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)(item.getEsCloumn() + ".keyword"), (String)("*" + each.getQryString() + "*")));
                                materialExtBoolQueryBuilder.should((QueryBuilder)materialInBoolQueryBuilder);
                            }
                            extBoolQueryBuilder.must((QueryBuilder)materialExtBoolQueryBuilder);
                            continue;
                        }
                        extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)(each.getSearchCloumn().get(0).getEsCloumn() + ".keyword"), (String)("*" + each.getQryString() + "*")));
                        continue;
                    }
                    log.error("es\u6784\u5efa\u67e5\u8be2\u8bed\u53e5\uff1b\u672a\u77e5\u7684type" + each.getSearchType());
                    throw new ZTBusinessException("es\u6784\u5efa\u67e5\u8be2\u8bed\u53e5\uff1b\u672a\u77e5\u7684type" + each.getSearchType());
                }
                Map<Integer, List<String>> esSearcheInfo = this.groupByCloumType(each.getSearchCloumn());
                for (Map.Entry<Integer, List<String>> entry : esSearcheInfo.entrySet()) {
                    String[] fileNames = entry.getValue().toArray(new String[0]);
                    if (entry.getKey() == 3) {
                        inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)each.getQryString(), (String[])fileNames).minimumShouldMatch("95%").type(MultiMatchQueryBuilder.Type.MOST_FIELDS).analyzer("ik_smart").boost(each.getProportion().floatValue()));
                        continue;
                    }
                    if (entry.getKey() == 1 || entry.getKey() == 2) {
                        if (!each.getQryString().matches("^[0-9]{1,}$")) continue;
                        inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)each.getQryString(), (String[])fileNames)).boost(each.getProportion().floatValue());
                        continue;
                    }
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)each.getQryString(), (String[])fileNames)).boost(each.getProportion().floatValue());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(searchEsSQLReqBO.getIgnoreList())) {
                skus = new long[searchEsSQLReqBO.getIgnoreList().size()];
                for (int i = 0; i < searchEsSQLReqBO.getIgnoreList().size(); ++i) {
                    skus[i] = searchEsSQLReqBO.getIgnoreList().get(i);
                }
                extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(searchEsSQLReqBO.getSkuList())) {
                skus = new long[searchEsSQLReqBO.getSkuList().size()];
                for (int i = 0; i < searchEsSQLReqBO.getSkuList().size(); ++i) {
                    skus[i] = searchEsSQLReqBO.getSkuList().get(i);
                }
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
            }
            if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getSearchTypeList())) {
                BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
                for (UccMallSourceTypeBo each : searchEsSQLReqBO.getSearchTypeList()) {
                    BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                    if (each.getSkuSource() != null) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)each.getSkuSource()));
                    }
                    if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)each.getType()));
                    }
                    authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
                }
                extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)inBoolQueryBuilder);
            FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder);
            functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.SUM);
            functionScoreQueryBuilder.setMinScore(2.0f);
            searchBarEsSQLRspBO.setFunctionScoreQueryBuilder(functionScoreQueryBuilder);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getUccMallQueryParams() != null) {
            if (extBoolQueryBuilder == null) {
                extBoolQueryBuilder = QueryBuilders.boolQuery();
            }
            for (int i = 0; i < searchEsSQLReqBO.getUccMallQueryParams().size(); ++i) {
                int j;
                UccMallQueryParamBO param = new UccMallQueryParamBO();
                BeanUtils.copyProperties((Object)searchEsSQLReqBO.getUccMallQueryParams().get(i), (Object)param);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("l3_category_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("vendor_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.matchQuery((String)"properties", (Object)param.getFilterValues().get(j))));
                }
            }
            searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(searchEsSQLReqBO.getOrderByColumn())) {
            SortOrder orderType = SortOrder.DESC;
            if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
                orderType = SortOrder.ASC;
            }
            ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
            for (String order : searchEsSQLReqBO.getOrderByColumn()) {
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)order).order(orderType));
            }
            searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(searchEsSQLReqBO.getOrderColum())) {
            List<FieldSortBuilder> fieldSortBuilders = null;
            fieldSortBuilders = !org.apache.commons.collections.CollectionUtils.isEmpty(searchBarEsSQLRspBO.getSortQuery()) ? searchBarEsSQLRspBO.getSortQuery() : new ArrayList<FieldSortBuilder>();
            SortOrder orderType = null;
            for (UccMallOrderColumBo each : searchEsSQLReqBO.getOrderColum()) {
                orderType = SortOrder.DESC;
                if (each.getOrderType() != null && each.getOrderType() == 1) {
                    orderType = SortOrder.ASC;
                }
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)each.getOrderByColumn()).order(orderType));
            }
            searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        }
        searchBarEsSQLRspBO.setBoolQueryBuilder(extBoolQueryBuilder);
        searchBarEsSQLRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchBarEsSQLRspBO;
    }

    public Map<Integer, List<String>> groupByCloumType(List<UccMallCloumnIndxBo> searchCloumn) {
        HashedMap result = new HashedMap();
        for (UccMallCloumnIndxBo each : searchCloumn) {
            if (result.containsKey(each.getCloumnType())) {
                ((List)result.get(each.getCloumnType())).add(each.getEsCloumn());
                continue;
            }
            ArrayList<String> type = new ArrayList<String>();
            type.add(each.getEsCloumn());
            result.put(each.getCloumnType(), type);
        }
        return result;
    }
}

