/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.self.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.self.ability.api.UccDeleteCommodityAbilityService;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityReqBO;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityRspBO;
import com.tydic.commodity.self.busi.api.UccSelfDeleteCommodityBusiService;
import com.tydic.commodity.self.busi.bo.UccSelfDeleteCommodityBusiReqBO;
import com.tydic.commodity.self.busi.bo.UccSelfDeleteCommodityBusiRspBO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.self.ability.api.UccDeleteCommodityAbilityService"})
public class UccDeleteCommodityAbilityServiceImpl
implements UccDeleteCommodityAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDeleteCommodityAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSelfDeleteCommodityBusiService uccSelfDeleteCommodityBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealDeleteCommodity"})
    public UccDeleteCommodityAbilityRspBO dealDeleteCommodity(@RequestBody UccDeleteCommodityAbilityReqBO reqBO) {
        UccDeleteCommodityAbilityRspBO rspBO = new UccDeleteCommodityAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSpuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List reqCmmds = reqBO.getBatchSpuList().stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
        List poList = this.uccCommodityMapper.qeryBatchCommdity(reqCmmds);
        List uccSkuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqCmmds, null);
        if (CollectionUtils.isEmpty((Collection)poList) || poList.size() != reqCmmds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        for (UccCommodityPo each : poList) {
            if (!ModelRuleConstant.COMMD_STATUS_INVALID.equals(each.getCommodityStatus())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(each.getCommodityId() + "\u5546\u54c1\u4e0d\u662f\u5931\u6548\u72b6\u6001");
                return rspBO;
            }
            if (!ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(each.getApprovalStatus())) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(each.getCommodityId() + "\u5546\u54c1\u6b63\u5728\u5ba1\u6279\u4e2d");
            return rspBO;
        }
        UccSelfDeleteCommodityBusiReqBO uccSelfDeleteCommodityBusiReqBO = new UccSelfDeleteCommodityBusiReqBO();
        uccSelfDeleteCommodityBusiReqBO.setUccCommodityPos(poList);
        UccSelfDeleteCommodityBusiRspBO uccSelfDeleteCommodityBusiRspBO = this.uccSelfDeleteCommodityBusiService.batchDeleteCommodity(uccSelfDeleteCommodityBusiReqBO);
        if (!"0000".equals(uccSelfDeleteCommodityBusiRspBO.getRespCode())) {
            BeanUtil.copyProperties((Object)((Object)uccSelfDeleteCommodityBusiRspBO), (Object)rspBO);
            return rspBO;
        }
        this.syncEsBySpu(reqBO, uccSkuPoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEsBySpu(UccDeleteCommodityAbilityReqBO reqBO, List<UccSkuPo> uccSkuPoList) {
        Map<Long, List<UccBatchSpuBO>> group = reqBO.getBatchSpuList().stream().collect(Collectors.groupingBy(UccBatchSpuBO::getSupplierShopId));
        for (Long shopId : group.keySet()) {
            List cmmds = group.get(shopId).stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(cmmds);
            syncSceneCommodityToEsReqBO.setSupplierId(shopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u5546\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            Map<Long, List<UccSkuPo>> skuGroup = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long shopId : skuGroup.keySet()) {
                List skuIds = skuGroup.get(shopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(skuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u6839\u636e\u5355\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }
}

