/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.zone.ability.api.UccAgrMinimalismCreateSkuTemplateExportAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrItemInfoBO;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo;
import com.tydic.commodity.zone.ability.bo.UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo;
import com.tydic.commodity.zone.ability.bo.UccMiniTemplateInfoBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrMinimalismCreateSkuTemplateExportAbilityService"})
public class UccAgrMinimalismCreateSkuTemplateExportAbilityServiceImpl
implements UccAgrMinimalismCreateSkuTemplateExportAbilityService {
    @Autowired
    private AgrGetAgrMainListService agrGetAgrMainListService;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;

    @PostMapping(value={"miniCreateTemplateExport"})
    public UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo miniCreateTemplateExport(@RequestBody UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo reqBo) {
        UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo rspBo = new UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo();
        this.getAgrItem(reqBo, rspBo);
        this.getTemplateData(reqBo, rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void getTemplateData(UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo reqBo, UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo rspBo) {
        ArrayList uccTaxRateValueList = new ArrayList();
        ArrayList uccTaxCodeValueList = new ArrayList();
        ArrayList uccCommodityTypePos = new ArrayList();
        ArrayList uccBrandDealPOS = new ArrayList();
        if (UccConstants.MinimalismCreateType.NO_DETAILS.equals(reqBo.getCreateType())) {
            uccTaxRateValueList.addAll(this.uccBaseDictionaryAtomService.queryBypCodeBackPo("UCC_TAX_RATE_VALUE"));
            UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
            uccCommodityTypePos.addAll(this.uccCommodityTypeMapper.queryAllCommdTypeDetails(uccCommodityTypePo));
            uccTaxCodeValueList.addAll(this.uccBaseDictionaryAtomService.queryBypCodeBackPo("ucc_tax_cat_code_value"));
            Page page = new Page(-1, -1);
            List getMallBrandDetailGroupList = this.uccBrandExtMapper.getMallBrandDetailGroupList(page, null, null, null, null);
            uccBrandDealPOS.addAll(getMallBrandDetailGroupList.stream().map(uccMallBrandDetailInfoGroupListAbilityBo -> {
                UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
                uccBrandDealPO.setBrandId(uccMallBrandDetailInfoGroupListAbilityBo.getMallBrandId());
                uccBrandDealPO.setBrandName(uccMallBrandDetailInfoGroupListAbilityBo.getMallBrandName());
                return uccBrandDealPO;
            }).collect(Collectors.toList()));
        }
        List afterSaleAllowList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("AFTER_SALE_ALLOW");
        List afterTakeTypeList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("AFTER_TAKE_TYPE");
        List skuOnShelveWayList = this.uccBaseDictionaryAtomService.queryBypCodeBackPo("SKU_ON_SHELVE_WAY");
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setStatus(Integer.valueOf(1));
        uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        List<String> yon = Arrays.asList("\u662f", "\u5426");
        List taxValue = uccTaxRateValueList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList());
        rspBo.setTaxRate(taxValue);
        List taxCodeValue = uccTaxCodeValueList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList());
        rspBo.setTaxCode(taxCodeValue);
        List uccCommodityTypes = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCommodityTypeName).distinct().collect(Collectors.toList());
        rspBo.setCommodityType(uccCommodityTypes);
        List uccBrandDeals = uccBrandDealPOS.stream().map(UccBrandDealPO::getBrandName).distinct().collect(Collectors.toList());
        rspBo.setBrand(uccBrandDeals);
        List afterSaleAllows = afterSaleAllowList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList());
        rspBo.setAfterDate(afterSaleAllows);
        List afterTakeTypes = afterTakeTypeList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList());
        rspBo.setAfterReturn(afterTakeTypes);
        List skuOnShelveWays = skuOnShelveWayList.stream().map(DicDictionaryPo::getTitle).distinct().collect(Collectors.toList());
        rspBo.setOnShelveWay(skuOnShelveWays);
        List uccCommodityMeasures = uccCommodityMeasurePos.stream().map(UccCommodityMeasurePo::getMeasureName).distinct().collect(Collectors.toList());
        rspBo.setMeasureName(uccCommodityMeasures);
        rspBo.setRejectAllow(yon);
        rspBo.setExchangeAllow(yon);
        rspBo.setMaintainAllow(yon);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(Convert.toLong((Object)taxValue.size()));
        list.add(Convert.toLong((Object)uccCommodityTypes.size()));
        list.add(Convert.toLong((Object)uccBrandDeals.size()));
        list.add(Convert.toLong((Object)afterSaleAllows.size()));
        list.add(Convert.toLong((Object)afterTakeTypes.size()));
        list.add(Convert.toLong((Object)skuOnShelveWays.size()));
        list.add(Convert.toLong((Object)uccCommodityMeasures.size()));
        list.add(Convert.toLong((Object)taxCodeValue.size()));
        list.add(Convert.toLong((Object)yon.size()));
        list.sort(Comparator.reverseOrder());
        ArrayList<UccMiniTemplateInfoBo> uccMiniTemplateInfoBoList = new ArrayList<UccMiniTemplateInfoBo>();
        int i = 0;
        while ((long)i < (Long)list.get(0)) {
            UccMiniTemplateInfoBo uccMiniTemplateInfoBo = new UccMiniTemplateInfoBo();
            uccMiniTemplateInfoBo.setTaxRate(taxValue.size() >= i + 1 ? (String)taxValue.get(i) : null);
            uccMiniTemplateInfoBo.setAfterDate(afterSaleAllows.size() >= i + 1 ? (String)afterSaleAllows.get(i) : null);
            uccMiniTemplateInfoBo.setAfterReturn(afterTakeTypes.size() >= i + 1 ? (String)afterTakeTypes.get(i) : null);
            uccMiniTemplateInfoBo.setBrand(uccBrandDeals.size() >= i + 1 ? (String)uccBrandDeals.get(i) : null);
            uccMiniTemplateInfoBo.setCommodityType(uccCommodityTypes.size() >= i + 1 ? (String)uccCommodityTypes.get(i) : null);
            uccMiniTemplateInfoBo.setExchangeAllow(yon.size() >= i + 1 ? yon.get(i) : null);
            uccMiniTemplateInfoBo.setRejectAllow(yon.size() >= i + 1 ? yon.get(i) : null);
            uccMiniTemplateInfoBo.setMaintainAllow(yon.size() >= i + 1 ? yon.get(i) : null);
            uccMiniTemplateInfoBo.setMeasureName(uccCommodityMeasures.size() >= i + 1 ? (String)uccCommodityMeasures.get(i) : null);
            uccMiniTemplateInfoBo.setOnShelveWay(skuOnShelveWays.size() >= i + 1 ? (String)skuOnShelveWays.get(i) : null);
            uccMiniTemplateInfoBo.setTaxCode(taxCodeValue.size() >= i + 1 ? (String)taxCodeValue.get(i) : null);
            uccMiniTemplateInfoBoList.add(uccMiniTemplateInfoBo);
            ++i;
        }
        rspBo.setUccMiniTemplateInfoBos(uccMiniTemplateInfoBoList);
    }

    private void getAgrItem(UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo reqBo, UccAgrMinimalismCreateSkuTemplateExportAbilityRspBo rspBo) {
        Map<String, AgrItemDetailBo> agrDetailMap = this.getAgrDetailMap(reqBo);
        List agrItemList = agrDetailMap.values().stream().map(agrItemDetailBo -> {
            UccAgrItemInfoBO agrItemDetail = new UccAgrItemInfoBO();
            agrItemDetail.setAgreementCode(reqBo.getAgreementCode());
            agrItemDetail.setAgreementPrice(Convert.toStr((Object)agrItemDetailBo.getBuyPrice()));
            agrItemDetail.setSalePrice(Convert.toStr((Object)agrItemDetailBo.getSalePrice()));
            agrItemDetail.setMaterialCode(agrItemDetailBo.getMaterialCode());
            agrItemDetail.setMaterialName(agrItemDetailBo.getMaterialName());
            agrItemDetail.setSettlementUnit(agrItemDetailBo.getMeasureName());
            return agrItemDetail;
        }).collect(Collectors.toList());
        rspBo.setAgrItemList(agrItemList);
    }

    private Map<String, AgrItemDetailBo> getAgrDetailMap(UccAgrMinimalismCreateSkuTemplateExportAbilityReqBo reqBo) {
        if (UccConstants.MinimalismCreateType.HAVE_DETAILS.equals(reqBo.getCreateType())) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setAgrId(reqBo.getAgreementId());
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrSkuStatus(Integer.valueOf(20));
            agrGetAgrItemListReqBO.setAgrItemIds(reqBo.getAgrItemIds());
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u9519\u8bef");
            }
            if (CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                throw new BusinessException("8888", "\u6ca1\u6709\u672a\u521b\u5efa\u5546\u54c1\u7684\u534f\u8bae\u660e\u7ec6\u4fe1\u606f");
            }
            List rows = agrGetAgrItemListRspBO.getRows();
            return rows.stream().collect(Collectors.toMap(AgrItemDetailBo::getMaterialCode, Function.identity()));
        }
        return new HashMap<String, AgrItemDetailBo>();
    }
}

