/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.LadderPriceBO;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.UccCommodityEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicEditMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccLadderPriceEditMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuEditMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicEditMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceEditMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccCommodityEditPO;
import com.tydic.commodity.po.UccCommodityPicEditPO;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccLadderPriceEditPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuEditPO;
import com.tydic.commodity.po.UccSkuPicEditPO;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPriceEditPO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.atom.api.UccAgrSimpleSingleEditSpuAtomService;
import com.tydic.commodity.zone.atom.bo.UccAgrSimpleSingleEditSpuAtomReqBO;
import com.tydic.commodity.zone.atom.bo.UccAgrSimpleSingleEditSpuAtomRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrSimpleSingleEditSpuAtomServiceImpl
implements UccAgrSimpleSingleEditSpuAtomService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuEditMapper uccSkuEditMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPicEditMapper uccSkuPicEditMapper;
    @Autowired
    private UccCommodityEditMapper uccCommodityEditMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPicEditMapper uccCommodityPicEditMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceEditMapper uccSkuPriceEditMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccLadderPriceEditMapper uccLadderPriceEditMapper;

    @Override
    public UccAgrSimpleSingleEditSpuAtomRspBO editSpuSimple(UccAgrSimpleSingleEditSpuAtomReqBO reqBO) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo = this.uccSkuMapper.getModelBy(uccSkuPo);
        if (null == uccSkuPo) {
            throw new BaseBusinessException("8888", "\u5355\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (null == uccCommodityPo) {
            throw new BaseBusinessException("8888", "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Date now = new Date();
        UccAgrSimpleSingleEditSpuAtomRspBO rspBO = new UccAgrSimpleSingleEditSpuAtomRspBO();
        if (SkuStatusConstants.SKU_STATUS_DRAFT.equals(uccSkuPo.getSkuStatus())) {
            this.dealMainInfo(reqBO, uccSkuPo, now, uccCommodityPo);
        } else {
            Long batchId = this.dealEditInfo(reqBO, uccSkuPo, now, uccCommodityPo);
            rspBO.setEditBatchId(batchId);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSkuStatus(uccSkuPo.getSkuStatus());
        return rspBO;
    }

    private void dealMainInfo(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Date now, UccCommodityPo uccCommodityPo) {
        this.updateSku(reqBO, uccSkuPo, now);
        this.updateCommodity(reqBO, uccCommodityPo);
        this.updatePic(reqBO, uccSkuPo, now, uccCommodityPo);
        this.updatePrice(reqBO, uccSkuPo);
    }

    private void updatePrice(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getAgreementPrice())));
        uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePrice())));
        uccSkuPricePo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPrice())));
        uccSkuPricePo.setSwitchOn(reqBO.getSwitchOn());
        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
        if (UccConstants.LadderSwitchOn.YES.equals(reqBO.getSwitchOn())) {
            UccSkuPricePo qryPriceIdPo = new UccSkuPricePo();
            qryPriceIdPo.setSkuId(uccSkuPo.getSkuId());
            qryPriceIdPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            qryPriceIdPo = this.uccSkuPriceMapper.querySkuPrice(qryPriceIdPo);
            if (null == qryPriceIdPo) {
                throw new BaseBusinessException("8888", "\u4ef7\u683c\u67e5\u8be2\u4e3a\u7a7a");
            }
            ArrayList<UccLadderPricePO> uccCommodityPicPos = new ArrayList<UccLadderPricePO>();
            for (LadderPriceBO ladderPriceBO : reqBO.getLadderPriceBOList()) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getPrice())));
                uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getStartPrice())));
                uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getStopPrice())));
                uccLadderPricePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccLadderPricePO.setSkuId(uccSkuPo.getSkuId());
                uccLadderPricePO.setSupplierShopId(uccSkuPo.getSupplierShopId());
                uccLadderPricePO.setDiscount(ladderPriceBO.getDiscount());
                uccLadderPricePO.setSkuPriceId(qryPriceIdPo.getSkuPriceId());
                uccCommodityPicPos.add(uccLadderPricePO);
            }
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            uccLadderPricePO.setSkuId(uccSkuPo.getSkuId());
            uccLadderPricePO.setSupplierShopId(uccSkuPo.getSupplierShopId());
            this.uccLadderPriceMapper.deleteByExample(uccLadderPricePO);
            this.uccLadderPriceMapper.batchInsert(uccCommodityPicPos);
        }
    }

    private void updatePic(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Date now, UccCommodityPo uccCommodityPo) {
        if (CollectionUtils.isEmpty(reqBO.getPicUrlList())) {
            ArrayList<UccSkuPicPo> uccSkuPicPos = new ArrayList<UccSkuPicPo>();
            ArrayList<UccCommodityPicPo> uccCommodityPicPos = new ArrayList<UccCommodityPicPo>();
            List<String> picUrlList = reqBO.getPicUrlList();
            for (int i = 0; i < picUrlList.size(); ++i) {
                String picUrl = picUrlList.get(i);
                UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
                uccSkuPicPo.setSupplierShopId(uccSkuPicPo.getSupplierShopId());
                uccSkuPicPo.setSkuId(uccSkuPicPo.getSkuId());
                uccSkuPicPo.setSkuPicId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuPicPo.setPicOrder(Integer.valueOf(i));
                uccSkuPicPo.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                uccSkuPicPo.setCreateTime(now);
                uccSkuPicPo.setCreateOperId(reqBO.getUserId().toString());
                uccSkuPicPo.setSkuPicUrl(picUrl);
                uccSkuPicPos.add(uccSkuPicPo);
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setSupplierShopId(uccCommodityPicPo.getSupplierShopId());
                uccCommodityPicPo.setCommodityId(uccCommodityPicPo.getCommodityId());
                uccCommodityPicPo.setCommodityPicId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityPicPo.setPicOrder(Integer.valueOf(i));
                uccCommodityPicPo.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                uccCommodityPicPo.setCreateTime(now);
                uccCommodityPicPo.setCreateOperId(reqBO.getUserId().toString());
                uccCommodityPicPo.setCommodityPicUrl(picUrl);
                uccCommodityPicPos.add(uccCommodityPicPo);
            }
            ((UccSkuPicPo)uccSkuPicPos.get(0)).setCommodityPicType(UccConstants.CommodityPicType.MAIN);
            this.uccSkuPicMapper.batchDelete(Collections.singletonList(uccSkuPo.getSkuId()), null);
            this.uccSkuPicMapper.batchInsert(uccSkuPicPos);
            this.uccCommodityPicMapper.batchDelete(Collections.singletonList(uccCommodityPo.getCommodityId()), null);
            this.uccCommodityPicMapper.batchInsert(uccCommodityPicPos);
        }
    }

    private void updateCommodity(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccCommodityPo uccCommodityPo) {
        uccCommodityPo.setCommodityName(reqBO.getSpuName());
        uccCommodityPo.setTaxCatCode(reqBO.getTaxCatCode());
        uccCommodityPo.setBrandId(reqBO.getBrandId());
        uccCommodityPo.setBrandName(reqBO.getBrandName());
        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
    }

    private void updateSku(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Date now) {
        uccSkuPo.setSkuName(reqBO.getSpuName());
        uccSkuPo.setMoq(reqBO.getMoq());
        uccSkuPo.setSalesUnitName(reqBO.getSalesUnitName());
        uccSkuPo.setSalesUnitId(reqBO.getSalesUnitId());
        uccSkuPo.setSalesUnitRate(reqBO.getSaleUnitRate());
        uccSkuPo.setOnShelveWay(reqBO.getOnShelveWay());
        uccSkuPo.setOnShelveTime(reqBO.getOnShelveTime());
        uccSkuPo.setUpdateOperId(reqBO.getUserId().toString());
        uccSkuPo.setUpdateOperName(reqBO.getName());
        uccSkuPo.setUpdateTime(now);
        uccSkuPo.setSpec(reqBO.getSpec());
        uccSkuPo.setModel(reqBO.getModel());
        uccSkuPo.setMeasureId(reqBO.getMeasureId());
        uccSkuPo.setMeasureName(reqBO.getMeasureName());
        uccSkuPo.setSettlementUnit(reqBO.getMeasureName());
        uccSkuPo.setCommodityTypeId(reqBO.getCommodityTypeId());
        uccSkuPo.setBrandId(reqBO.getBrandId());
        uccSkuPo.setBrandName(reqBO.getBrandName());
        this.uccSkuMapper.updateSku(uccSkuPo);
    }

    private Long dealEditInfo(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Date now, UccCommodityPo uccCommodityPo) {
        Long batchId = Sequence.getInstance().nextId();
        this.updateSkuEdit(reqBO, uccSkuPo, now, batchId);
        this.updatePicEdit(reqBO, now, batchId);
        this.updateCommodityEdit(reqBO, now, batchId, uccCommodityPo);
        this.updatePriceEdit(reqBO, uccSkuPo, batchId);
        return batchId;
    }

    private void updatePriceEdit(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Long batchId) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (null == uccSkuPricePo) {
            throw new BaseBusinessException("8888", "\u5355\u54c1\u4ef7\u683c\u4e0d\u5b58\u5728");
        }
        UccSkuPriceEditPO uccSkuPriceEditPO = (UccSkuPriceEditPO)JSON.parseObject((String)JSON.toJSONString((Object)uccSkuPricePo), UccSkuPriceEditPO.class);
        uccSkuPriceEditPO.setBatchId(batchId);
        uccSkuPriceEditPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getAgreementPrice())));
        uccSkuPriceEditPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePrice())));
        uccSkuPriceEditPO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPrice())));
        uccSkuPriceEditPO.setSwitchOn(reqBO.getSwitchOn());
        this.uccSkuPriceEditMapper.insert(uccSkuPriceEditPO);
        if (UccConstants.LadderSwitchOn.YES.equals(reqBO.getSwitchOn())) {
            ArrayList<UccLadderPriceEditPO> uccLadderPriceEditPOS = new ArrayList<UccLadderPriceEditPO>();
            for (LadderPriceBO ladderPriceBO : reqBO.getLadderPriceBOList()) {
                UccLadderPriceEditPO uccLadderPriceEditPO = new UccLadderPriceEditPO();
                uccLadderPriceEditPO.setBatchId(batchId);
                uccLadderPriceEditPO.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getPrice())));
                uccLadderPriceEditPO.setStart(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getStartPrice())));
                uccLadderPriceEditPO.setStop(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladderPriceBO.getStopPrice())));
                uccLadderPriceEditPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccLadderPriceEditPO.setSkuId(uccSkuPo.getSkuId());
                uccLadderPriceEditPO.setSupplierShopId(uccSkuPo.getSupplierShopId());
                uccLadderPriceEditPO.setDiscount(ladderPriceBO.getDiscount());
                uccLadderPriceEditPO.setSkuPriceId(uccSkuPricePo.getSkuPriceId());
                uccLadderPriceEditPOS.add(uccLadderPriceEditPO);
            }
            this.uccLadderPriceEditMapper.insertBatch(uccLadderPriceEditPOS);
        }
    }

    private void updateCommodityEdit(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, Date now, Long batchId, UccCommodityPo uccCommodityPo) {
        UccCommodityEditPO uccCommodityEditPO = (UccCommodityEditPO)JSON.parseObject((String)JSON.toJSONString((Object)uccCommodityPo), UccCommodityEditPO.class);
        uccCommodityEditPO.setBatchId(batchId);
        uccCommodityEditPO.setCommodityName(reqBO.getSpuName());
        uccCommodityEditPO.setTaxCatCode(reqBO.getTaxCatCode());
        uccCommodityEditPO.setBrandId(reqBO.getBrandId());
        uccCommodityEditPO.setBrandName(reqBO.getBrandName());
        uccCommodityEditPO.setUpdateOperId(reqBO.getUserId().toString());
        uccCommodityEditPO.setUpdateOperName(reqBO.getName());
        uccCommodityEditPO.setUpdateTime(now);
        uccCommodityEditPO.setFreeShipping(Integer.valueOf(0));
        this.uccCommodityEditMapper.addCommodityEdit(uccCommodityEditPO);
    }

    private void updatePicEdit(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, Date now, Long batchId) {
        if (CollectionUtils.isEmpty(reqBO.getPicUrlList())) {
            ArrayList<UccCommodityPicEditPO> uccCommodityPicEditPOS = new ArrayList<UccCommodityPicEditPO>();
            ArrayList<UccSkuPicEditPO> uccSkuPicPos = new ArrayList<UccSkuPicEditPO>();
            List<String> picUrlList = reqBO.getPicUrlList();
            for (int i = 0; i < picUrlList.size(); ++i) {
                String picUrl = picUrlList.get(i);
                UccSkuPicEditPO uccSkuPicEditPO = new UccSkuPicEditPO();
                uccSkuPicEditPO.setSupplierShopId(uccSkuPicEditPO.getSupplierShopId());
                uccSkuPicEditPO.setSkuId(uccSkuPicEditPO.getSkuId());
                uccSkuPicEditPO.setSkuPicId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuPicEditPO.setPicOrder(Integer.valueOf(i));
                uccSkuPicEditPO.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                uccSkuPicEditPO.setCreateTime(now);
                uccSkuPicEditPO.setCreateOperId(reqBO.getUserId().toString());
                uccSkuPicEditPO.setSkuPicUrl(picUrl);
                uccSkuPicPos.add(uccSkuPicEditPO);
                UccCommodityPicEditPO uccCommodityPicEditPO = new UccCommodityPicEditPO();
                uccCommodityPicEditPO.setBatchId(batchId);
                uccCommodityPicEditPO.setSupplierShopId(uccCommodityPicEditPO.getSupplierShopId());
                uccCommodityPicEditPO.setCommodityId(uccCommodityPicEditPO.getCommodityId());
                uccCommodityPicEditPO.setCommodityPicId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityPicEditPO.setPicOrder(Integer.valueOf(i));
                uccCommodityPicEditPO.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                uccCommodityPicEditPO.setCreateTime(now);
                uccCommodityPicEditPO.setCreateOperId(reqBO.getUserId().toString());
                uccCommodityPicEditPO.setCommodityPicUrl(picUrl);
                uccCommodityPicEditPOS.add(uccCommodityPicEditPO);
            }
            ((UccSkuPicEditPO)uccSkuPicPos.get(0)).setCommodityPicType(UccConstants.CommodityPicType.MAIN);
            this.uccSkuPicEditMapper.insertBatch(uccSkuPicPos);
            this.uccCommodityPicEditMapper.insertBatch(uccCommodityPicEditPOS);
        }
    }

    private void updateSkuEdit(UccAgrSimpleSingleEditSpuAtomReqBO reqBO, UccSkuPo uccSkuPo, Date now, Long batchId) {
        UccSkuEditPO uccSkuEditPO = (UccSkuEditPO)JSON.parseObject((String)JSON.toJSONString((Object)uccSkuPo), UccSkuEditPO.class);
        uccSkuEditPO.setBatchId(batchId);
        uccSkuEditPO.setSkuName(reqBO.getSpuName());
        uccSkuEditPO.setMoq(reqBO.getMoq());
        uccSkuEditPO.setSalesUnitName(reqBO.getSalesUnitName());
        uccSkuEditPO.setSalesUnitId(reqBO.getSalesUnitId());
        uccSkuEditPO.setSalesUnitRate(reqBO.getSaleUnitRate());
        uccSkuEditPO.setOnShelveWay(reqBO.getOnShelveWay());
        uccSkuEditPO.setOnShelveTime(reqBO.getOnShelveTime());
        uccSkuEditPO.setUpdateOperId(reqBO.getUserId().toString());
        uccSkuEditPO.setUpdateOperName(reqBO.getName());
        uccSkuEditPO.setUpdateTime(now);
        uccSkuPo.setSpec(reqBO.getSpec());
        uccSkuEditPO.setModel(reqBO.getModel());
        uccSkuEditPO.setMeasureId(reqBO.getMeasureId());
        uccSkuEditPO.setMeasureName(reqBO.getMeasureName());
        uccSkuEditPO.setSettlementUnit(reqBO.getMeasureName());
        uccSkuEditPO.setCommodityTypeId(reqBO.getCommodityTypeId());
        uccSkuEditPO.setBrandId(reqBO.getBrandId());
        uccSkuEditPO.setBrandName(reqBO.getBrandName());
        uccSkuEditPO.setOperType(reqBO.getOperType());
        uccSkuEditPO.setMinimalismFlag(uccSkuPo.getMinimalismFlag());
        this.uccSkuEditMapper.addSkuEdit(uccSkuEditPO);
    }
}

