/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.busibase.atom.api.UccSkuStateChangeSyncOoocAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeSyncOoocAtomServiceReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.busi.api.UccAgrExpireDealBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrDealBusiServiceRspBo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAgrExpireDealBusiServiceImpl
implements UccAgrExpireDealBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuStateChangeSyncOoocAtomService uccSkuStateChangeSyncOoocAtomService;
    @Value(value="${ucc.skuState.sync.oooc.type:2}")
    private Integer syncType;

    @Override
    public UccAgrDealBusiServiceRspBo dealAgrExpire(AgrMessageBo reqBo) {
        List uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBo.getAgreementIds(), reqBo.getAgreementSkuIds());
        this.uccSkuMapper.updateSkuStateByAgrId(reqBo.getAgreementIds(), SkuStatusConstants.SKU_STATUS_INVALID);
        this.skuStateChangeSyncOooc(uccSkuPos);
        UccAgrDealBusiServiceRspBo rspBo = new UccAgrDealBusiServiceRspBo();
        rspBo.setUccSkuPos(uccSkuPos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void skuStateChangeSyncOooc(List<UccSkuPo> uccSkuPos) {
        if (CollectionUtils.isNotEmpty(uccSkuPos)) {
            List skuStatuslist = uccSkuPos.stream().map(uccSkuPo -> {
                UccSkuStateChangeBo uccSkuStateChangeBo = new UccSkuStateChangeBo();
                uccSkuStateChangeBo.setChangeTime(DateUtil.now());
                uccSkuStateChangeBo.setSkuId(Convert.toStr((Object)uccSkuPo.getSkuId()));
                uccSkuStateChangeBo.setStatus(Convert.toStr((Object)uccSkuPo.getSkuStatus()));
                return uccSkuStateChangeBo;
            }).collect(Collectors.toList());
            UccSkuStateChangeSyncOoocAtomServiceReqBo uccSkuStateChangeSyncAtomServiceReqBo = new UccSkuStateChangeSyncOoocAtomServiceReqBo();
            uccSkuStateChangeSyncAtomServiceReqBo.setSkuStatuslist(skuStatuslist);
            uccSkuStateChangeSyncAtomServiceReqBo.setSyncType(this.syncType);
            this.uccSkuStateChangeSyncOoocAtomService.stateSyncOooc(uccSkuStateChangeSyncAtomServiceReqBo);
        }
    }
}

