/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStateChangeSyncOoocAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuStateChangeSyncOoocAtomServiceReqBo;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccGoodsPriceChangeLogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccGoodsPriceChangeLogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.AgrMessageRspBo;
import com.tydic.commodity.zone.ability.bo.UccAgrScopeSyncBO;
import com.tydic.commodity.zone.ability.bo.UccUpdateSaleNumBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSalesVolumeBO;
import com.tydic.commodity.zone.atom.api.UccChangeStatusAtomService;
import com.tydic.commodity.zone.busi.api.UccDealAgrMessageBusiService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageBusiServiceImpl
implements UccDealAgrMessageBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccGoodsPriceChangeLogMapper uccGoodsPriceChangeLogMapper;
    @Autowired
    private UccChangeStatusAtomService uccChangeStatusAtomService;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Autowired
    private UccSkuStateChangeSyncOoocAtomService uccSkuStateChangeSyncOoocAtomService;
    @Value(value="${ucc.skuState.sync.oooc.type:2}")
    private Integer syncType;
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;

    @Override
    public AgrMessageRspBo dealMessage(AgrMessageBo reqBO) {
        List uccOrgSkuWhiteRestrictionPos;
        List agrIds;
        AgrMessageRspBo rspBO = new AgrMessageRspBo();
        log.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (UccConstants.AgrStatusChangeType.THAW.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.INVALID.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.PRICE.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.SCOPE.equals(reqBO.getChangeType())) {
            AgrMessageRspBo agrMessageRspBo = this.uccChangeStatusAtomService.changeCommod(reqBO);
            rspBO.setAgrMessageContentBoList(agrMessageRspBo.getAgrMessageContentBoList());
        }
        if (!(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs()) || org.apache.commons.collections.CollectionUtils.isEmpty(agrIds = reqBO.getAgrScopeSyncBOs().stream().map(UccAgrScopeSyncBO::getAgreementId).collect(Collectors.toList())) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrIds, null, Integer.valueOf(1)))))) {
            Set orgPaths = uccOrgSkuWhiteRestrictionPos.stream().map(UccOrgSkuWhiteRestrictionPo::getOrgTreePath).filter(orgTreePath -> !StringUtils.isEmpty((String)orgTreePath)).collect(Collectors.toSet());
            this.uccOrgSkuWhiteRestrictionMapper.deleteListByAgr(agrIds, null);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgPaths)) {
                List uccOrgSkuWhiteRestrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(null, (List)Lists.newArrayList(orgPaths), Integer.valueOf(1));
                HashMap white = new HashMap();
                HashMap<String, Long> orgMap = new HashMap<String, Long>();
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccOrgSkuWhiteRestrictionPoList)) {
                    Map<String, List<UccOrgSkuWhiteRestrictionPo>> orgPos = uccOrgSkuWhiteRestrictionPoList.stream().filter(a -> a.getAgreementId() != null).collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getOrgTreePath));
                    for (Map.Entry<String, List<UccOrgSkuWhiteRestrictionPo>> each : orgPos.entrySet()) {
                        List agrIdList = each.getValue().stream().map(UccOrgSkuWhiteRestrictionPo::getAgreementId).filter(Objects::nonNull).collect(Collectors.toList());
                        white.put(each.getKey(), agrIdList);
                        orgMap.putIfAbsent(each.getKey(), each.getValue().get(0).getOrgId());
                    }
                }
                for (String key : orgPaths) {
                    if (white.containsKey(key)) {
                        this.cacheClient.set("UCC_ORG_AGR_WHITELIST_RESTRICTION" + orgMap.get(key), white.get(key));
                        continue;
                    }
                    this.cacheClient.delete("UCC_ORG_AGR_WHITELIST_RESTRICTION" + (Long)orgMap.get(key));
                }
            }
        }
        if (!StringUtils.isEmpty((String)reqBO.getAgrName()) && !StringUtils.isEmpty((String)reqBO.getEnAgrCode())) {
            UccCommodityPo updatePO = new UccCommodityPo();
            updatePO.setAgreementId(((Long)reqBO.getAgreementIds().get(0)).toString());
            updatePO.setOtherSourceName(reqBO.getAgrName());
            updatePO.setCommodityExpand1(reqBO.getEnAgrCode());
            this.uccCommodityMapper.updateCommodityByAgreementIdZH(updatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        log.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void skuStateChangeSyncOooc(List<Long> agreementIds, List<Long> agreementDetailIds) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(agreementIds) && !org.apache.commons.collections.CollectionUtils.isEmpty(agreementDetailIds)) {
            List uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            List skuStatuslist = uccSkuPos.stream().map(uccSkuPo -> {
                UccSkuStateChangeBo uccSkuStateChangeBo = new UccSkuStateChangeBo();
                uccSkuStateChangeBo.setChangeTime(DateUtil.now());
                uccSkuStateChangeBo.setSkuId(Convert.toStr((Object)uccSkuPo.getSkuId()));
                uccSkuStateChangeBo.setStatus(Convert.toStr((Object)uccSkuPo.getSkuStatus()));
                return uccSkuStateChangeBo;
            }).collect(Collectors.toList());
            UccSkuStateChangeSyncOoocAtomServiceReqBo uccSkuStateChangeSyncAtomServiceReqBo = new UccSkuStateChangeSyncOoocAtomServiceReqBo();
            uccSkuStateChangeSyncAtomServiceReqBo.setSkuStatuslist(skuStatuslist);
            uccSkuStateChangeSyncAtomServiceReqBo.setSyncType(this.syncType);
            this.uccSkuStateChangeSyncOoocAtomService.stateSyncOooc(uccSkuStateChangeSyncAtomServiceReqBo);
        }
    }

    private void updateSkuPrice(List<SkuPriceBo> skuPriceBos) {
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.NORMAL);
        uccSkuPriceModifyAtomServiceReqBo.setSkuPriceBos(skuPriceBos);
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
    }

    private void addAgrPriceChangeLog(UccSkuPo uccSkuPo, SkuChangePriceBO skuChangePriceBO) {
        try {
            UccGoodsPriceChangeLogPO insertChangeLogPO = new UccGoodsPriceChangeLogPO();
            insertChangeLogPO.setPriceChangeLogId(Long.valueOf(Sequence.getInstance().nextId()));
            insertChangeLogPO.setSkuId(uccSkuPo.getSkuId());
            insertChangeLogPO.setCommodityId(uccSkuPo.getCommodityId());
            insertChangeLogPO.setSupplierShopId(uccSkuPo.getSupplierShopId());
            insertChangeLogPO.setChangeTime(new Date());
            insertChangeLogPO.setCurrentPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
            UccSkuPricePo select = new UccSkuPricePo();
            select.setSkuId(uccSkuPo.getSkuId());
            UccSkuPricePo oldSkuPrice = this.uccSkuPriceMapper.querySkuPrice(select);
            if (!ObjectUtil.isEmpty((Object)oldSkuPrice)) {
                insertChangeLogPO.setOldPrice(oldSkuPrice.getSalePrice());
            }
            this.uccGoodsPriceChangeLogMapper.insert(insertChangeLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u534f\u8bae\u4ef7\u683c\u65e5\u5fd7\u53d8\u5316\u8bb0\u5f55\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            BigDecimal discount = uccLadderPrice.getDiscount();
            if (discount == null) continue;
            BigDecimal price = discount.divide(new BigDecimal("100")).multiply(salePrice);
            uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
            uccLadderPricePO.setId(uccLadderPrice.getId());
            this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
        }
    }

    private void dealStock(UccUpdateSalesVolumeBO uccUpdateSaleNumBo) {
        if (uccUpdateSaleNumBo == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccUpdateSaleNumBo.getSaleNumBos())) {
            return;
        }
        Map<Integer, List<UccUpdateSaleNumBo>> map = uccUpdateSaleNumBo.getSaleNumBos().stream().filter(a -> a.getIncOrDec() != null).collect(Collectors.groupingBy(UccUpdateSaleNumBo::getIncOrDec));
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<Integer, List<UccUpdateSaleNumBo>> each : map.entrySet()) {
                List<UccUpdateSaleNumBo> uccUpdateSaleNumBos = each.getValue();
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                for (UccUpdateSaleNumBo uccUpdateSaleNumBo1 : uccUpdateSaleNumBos) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setSkuId(uccUpdateSaleNumBo1.getSkuId().toString());
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(uccUpdateSaleNumBo1.getSoldNumber().longValue()));
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                if (each.getKey() == 1) {
                    smcsdkOperateStockNumReqBO.setOperateType("40");
                } else if (each.getKey() == 0) {
                    smcsdkOperateStockNumReqBO.setOperateType("10");
                }
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                        continue;
                    }
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }
}

