/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.constant.UccNoticeAgrStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.AgrMessageContentBo;
import com.tydic.commodity.zone.ability.bo.AgrMessageRspBo;
import com.tydic.commodity.zone.ability.bo.UccAgrScopeSyncBO;
import com.tydic.commodity.zone.ability.bo.UccAppScopeBo;
import com.tydic.commodity.zone.busi.api.UccDealAgrMessageBusiService;
import com.tydic.commodity.zone.busi.api.UccDealAgrMessageService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageServiceImpl
implements UccDealAgrMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    @Autowired
    private UccDealAgrMessageBusiService uccDealAgrMessageBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    private static final String allRange = "*";
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccDealAgrMessageService uccDealAgrMessageService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        AgrMessageRspBo rspUccBo = this.uccDealAgrMessageBusiService.dealMessage(reqBO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspUccBo.getAgrMessageContentBoList())) {
            AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
            agrGetAgrMainReqBo.setAgrId((Long)reqBO.getAgreementIds().get(0));
            AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
            if (!"0000".equals(agrGetAgrMainRspBo.getRespCode())) {
                log.error("\u534f\u8baeID:{} \u67e5\u8be2\u534f\u8bae\u4e2d\u5fc3\u5931\u8d25:{}", reqBO.getAgreementIds().get(0), (Object)agrGetAgrMainRspBo.getRespDesc());
            }
            for (AgrMessageContentBo each : rspUccBo.getAgrMessageContentBoList()) {
                this.sendNotice(each, reqBO, agrGetAgrMainRspBo.getAgrStatus());
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs())) {
            try {
                this.insertWhiteList(reqBO);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        try {
            this.dealSkuSyncEs(reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rspUccBo;
    }

    private void sendNotice(AgrMessageContentBo agrMessageContentBo, AgrMessageBo reqBO, Integer agrStatus) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orderId", (Object)agrMessageContentBo.getOrderId());
            jsonObject.put("agrCode", (Object)agrMessageContentBo.getOtherSourceCode());
            jsonObject.put("orderCode", (Object)agrMessageContentBo.getOrderCode());
            jsonObject.put("skuStatusDesc", (Object)agrMessageContentBo.getSkuStatusDesc());
            if (null != agrStatus) {
                UccNoticeAgrStatusEnum agrStatusDesc = UccNoticeAgrStatusEnum.getAgrStatusDesc((Integer)agrStatus);
                if (null != agrStatusDesc) {
                    jsonObject.put("agrStatusDesc", (Object)agrStatusDesc.getDesc());
                }
                if (UccConstants.AgrStatusChangeType.SCOPE.equals(reqBO.getChangeType())) {
                    jsonObject.put("agrStatusDesc", (Object)"\u5df2\u51cf\u5c11\u539f\u6709\u534f\u8bae");
                }
                this.uccDealAgrMessageService.dealNotice(jsonObject);
            }
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u53d8\u66f4\u53d1\u9001\u901a\u77e5\u62a5\u9519\uff1a", (Throwable)e);
        }
    }

    @Override
    public JSONObject dealNotice(JSONObject reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("respCode", (Object)"0000");
        return jsonObject;
    }

    private void dealSkuSyncEs(AgrMessageBo reqBO) {
        Map<Object, Object> groupBySupplier = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds())) {
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setAgreementIdLong((Long)reqBO.getAgreementIds().get(0));
            List commodityPos = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)commodityPos)) {
                groupBySupplier = commodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List commodityIds = ((List)entry.getValue()).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList(commodityIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            if ("0000".equals(syncSceneCommodityToEsRspBO.getRespCode())) continue;
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4\u540c\u6b65\u5546\u54c1es\u5931\u8d25\uff1a" + syncSceneCommodityToEsRspBO.getRespDesc());
        }
    }

    private void insertWhiteList(AgrMessageBo reqBO) {
        ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
        ArrayList agrASpu = new ArrayList();
        for (UccAgrScopeSyncBO uccAgrScopeSyncBO : reqBO.getAgrScopeSyncBOs()) {
            if (allRange.equals(uccAgrScopeSyncBO.getScopeCodes()) || ObjectUtil.isEmpty((Object)uccAgrScopeSyncBO.getAgreementId())) continue;
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setAgreementIdLong(uccAgrScopeSyncBO.getAgreementId());
            List commodityPoList = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)commodityPoList)) continue;
            agrASpu.addAll(commodityPoList);
            for (UccAppScopeBo agrAppScopeBo : uccAgrScopeSyncBO.getAgrAppScopeBos()) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId("message sync");
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(agrAppScopeBo.getScopeCode()));
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(agrAppScopeBo.getScopeOrgPath());
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
        }
        if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
            return;
        }
        UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
        uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
        try {
            this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        if (!CollectionUtils.isEmpty(agrASpu)) {
            Map<Long, List<UccCommodityPo>> agrSpu = agrASpu.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
            for (Long shopId : agrSpu.keySet()) {
                SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO;
                List spuIds = agrSpu.get(shopId).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                if (log.isDebugEnabled()) {
                    log.debug("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                }
                if ("0000".equals((syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO)).getRespCode())) continue;
                throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4\u767d\u540d\u5355\u540c\u6b65\u5546\u54c1es\u5931\u8d25\uff1a" + syncSceneCommodityToEsRspBO.getRespDesc());
            }
        }
    }
}

