/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoListRspBo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoUpdateService;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoUpdateReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoUpdateRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoUpdateService"})
public class UmcInvoiceInfoUpdateServiceImpl
implements UmcInvoiceInfoUpdateService {
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;
    private final String updateInfo = "1";
    private final String msgHead = "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2";

    @PostMapping(value={"updateInvoiceInfo"})
    public UmcInvoiceInfoUpdateRspBo updateInvoiceInfo(@RequestBody UmcInvoiceInfoUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u5bf9\u8c61BO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getOperType())) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getInvoiceId() == null) {
            throw new BaseBusinessException("201001", "\u8d26\u5957\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968ID[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validationParams(reqBo);
        UmcInvoiceInfoQryBo infoQryBo = new UmcInvoiceInfoQryBo();
        infoQryBo.setInvoiceId(reqBo.getInvoiceId());
        UmcInvoiceInfoDo invoiceInfo = this.iUmcInvoiceInfoModel.getInvoiceInfo(infoQryBo);
        if (null == invoiceInfo) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UmcInvoiceInfoUpdateRspBo rspBo = UmcRu.success(UmcInvoiceInfoUpdateRspBo.class);
        UmcInvoiceInfoDo invoiceInfoDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceInfoDo.class));
        invoiceInfoDo.setUpdateTime(new Date());
        invoiceInfoDo.setExtinvoiceStatus(reqBo.getExtInvoiceStatus());
        if (reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES)) {
            List<UmcInvoiceInfoDo> invoiceInfoDoList = this.qryInvByCompanyId(invoiceInfo.getExtField2());
            if (!CollectionUtils.isEmpty(invoiceInfoDoList)) {
                this.cancleMainFlagAddr(invoiceInfoDoList);
            }
        } else {
            List<UmcInvoiceInfoDo> invoiceInfoDoList = this.qryInvByCompanyId(invoiceInfo.getExtField2());
            if (UmcCommConstant.EntInvMainFlag.YES.equals(invoiceInfo.getMainFlag())) {
                invoiceInfoDoList.removeIf(o -> reqBo.getInvoiceId().equals(o.getInvoiceId()));
            }
            if (CollectionUtils.isEmpty(invoiceInfoDoList)) {
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
                rspBo.setIsMainFlag(Boolean.TRUE);
            }
        }
        if (reqBo.getOperType().equals("1")) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getAccount())) {
                invoiceInfoDo.setAccount("");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getAddress())) {
                invoiceInfoDo.setAddress("");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getBank())) {
                invoiceInfoDo.setBank("");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getPhone())) {
                invoiceInfoDo.setPhone("");
            }
        }
        this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo);
        return rspBo;
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("0");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }

    private List<UmcInvoiceInfoDo> qryInvByCompanyId(String createCompanyId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setExtField2(createCompanyId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceInfoListRspBo umcInvoiceInfoListRspBo = this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
        return umcInvoiceInfoListRspBo.getRows();
    }

    private void validationParams(UmcInvoiceInfoUpdateReqBo reqBo) {
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

