/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.addrprovince;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.addrprovince.IUmcAddProvinceModel;
import com.tydic.dyc.umc.model.addrprovince.UmcAddressDO;
import com.tydic.dyc.umc.model.addrprovince.UmcAddressInfoDO;
import com.tydic.dyc.umc.service.addrprovince.UmcQueryAddressTreeService;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcAddressInfoBO;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQueryAddressTreeReqBO;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQueryAddressTreeRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.addrprovince.UmcQueryAddressTreeService"})
public class UmcQueryAddressTreeServiceImpl
implements UmcQueryAddressTreeService {
    @Autowired
    private IUmcAddProvinceModel iUmcAddProvinceModel;

    @PostMapping(value={"queryAddressTree"})
    public UmcQueryAddressTreeRspBO queryAddressTree(@RequestBody UmcQueryAddressTreeReqBO reqBO) {
        List<UmcAddressInfoDO> bkUmcAddressInfoDOS;
        this.validQueryAddressTreeData(reqBO);
        UmcQueryAddressTreeRspBO rspBO = UmcRu.success(UmcQueryAddressTreeRspBO.class);
        UmcAddressDO modelReqBO = new UmcAddressDO();
        modelReqBO.setQueryRange(reqBO.getQueryRange());
        if (!"province".equals(reqBO.getQueryRange())) {
            modelReqBO.setParentCode(reqBO.getParentCode());
        }
        if (ObjectUtil.isEmpty(bkUmcAddressInfoDOS = this.iUmcAddProvinceModel.queryAddressTree(modelReqBO))) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        List<UmcAddressInfoBO> rows = UmcRu.jsl(bkUmcAddressInfoDOS, UmcAddressInfoBO.class);
        rspBO.setRows(rows);
        return rspBO;
    }

    private void validQueryAddressTreeData(UmcQueryAddressTreeReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getQueryRange())) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09[QueryRange]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!"province".equals(reqBO.getQueryRange()) && ObjectUtil.isEmpty((Object)reqBO.getParentCode())) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09[ParentCode]\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

