/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDropDownTreeBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcParentOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListRspBO;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownListService"})
public class UmcQryOrgDropDownListServiceImpl
implements UmcQryOrgDropDownListService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    private static final String qryAllChild = "1";
    private static final String qryNowChild = "2";

    @PostMapping(value={"qryOrgDropDownList"})
    public UmcQryOrgDropDownListRspBO qryOrgDropDownList(@RequestBody UmcQryOrgDropDownListReqBO reqBO) {
        UmcQryOrgDropDownListRspBO rspBO = UmcRu.success(UmcQryOrgDropDownListRspBO.class);
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = UmcRu.js(reqBO, UmcEnterpriseOrgQryBo.class);
        enterpriseOrgQryBo.setExtField1(reqBO.getExtOrgType());
        enterpriseOrgQryBo.setExtField2(reqBO.getExtAdOrgLevel());
        enterpriseOrgQryBo.setExtField3(reqBO.getExtBlgGroup());
        StrUtil.noNullStringAttr(enterpriseOrgQryBo);
        if (qryAllChild.equals(reqBO.getQryChild())) {
            enterpriseOrgQryBo.setOrgTreePath(reqBO.getOrgId() + "");
            enterpriseOrgQryBo.setOrgId(null);
        } else if (qryNowChild.equals(reqBO.getQryChild())) {
            enterpriseOrgQryBo.setParentId(reqBO.getOrgId());
            enterpriseOrgQryBo.setOrgId(null);
        }
        if (!CollectionUtil.isEmpty((Collection)reqBO.getExtOrgIds()) && ObjectUtil.isEmpty((Object)reqBO.getOrgTagId())) {
            throw new ZTBusinessException("\u6839\u636e\u5916\u90e8\u673a\u6784ID\u67e5\u8be2\u5fc5\u987b\u533a\u5206\u8eab\u4efd");
        }
        UmcEnterpriseOrgQryRspBo umcEnterpriseOrgQryRspBo = this.iUmcEnterpriseInfoModel.qryOrgDropDownList(enterpriseOrgQryBo);
        rspBO.setPageNo(umcEnterpriseOrgQryRspBo.getPageNo());
        rspBO.setTotal(umcEnterpriseOrgQryRspBo.getTotal());
        rspBO.setRecordsTotal(umcEnterpriseOrgQryRspBo.getRecordsTotal());
        if (CollectionUtils.isEmpty((Collection)umcEnterpriseOrgQryRspBo.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, UmcOrgInfo> orgIdToNameMap = this.packagingOrgIdToNameMap(umcEnterpriseOrgQryRspBo.getRows());
        Map<String, String> extSupplierTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ENTRY_TYPE_DOWN")).getMap();
        List rows = umcEnterpriseOrgQryRspBo.getRows().stream().map(row -> {
            UmcDropDownTreeBO treeBO = UmcRu.js(row, UmcDropDownTreeBO.class);
            if (row.getIsParent() > 0) {
                treeBO.setIsParentOrg(qryAllChild);
            } else {
                treeBO.setIsParentOrg("0");
            }
            this.packagingParentOrgInfoList(treeBO, orgIdToNameMap);
            treeBO.setExtSupplierType(row.getExtSupplierType());
            treeBO.setExtSupplierTypeStr(this.translateEntryType(row.getExtSupplierType(), extSupplierTypeMap));
            return treeBO;
        }).collect(Collectors.toList());
        rspBO.setRows(rows);
        return rspBO;
    }

    private String translateEntryType(String input, Map<String, String> mapping) {
        String[] numbers;
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String number : numbers = input.split(",")) {
            String phrase = mapping.get(number.trim());
            if (phrase == null) continue;
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append(phrase);
        }
        return result.toString();
    }

    public void packagingParentOrgInfoList(UmcDropDownTreeBO treeBO, Map<Long, UmcOrgInfo> orgIdToNameMap) {
        if (!CollectionUtils.isEmpty(orgIdToNameMap)) {
            ArrayList<UmcParentOrgInfoBo> parentOrgInfoBoList = new ArrayList<UmcParentOrgInfoBo>(10);
            String[] arr = treeBO.getOrgTreePath().split("-");
            ArrayList<String> orgIds = new ArrayList<String>(Arrays.asList(arr));
            for (String orgId : orgIds) {
                if (treeBO.getOrgId().equals(orgId)) break;
                if (Long.parseLong(orgId) == 1L || !ObjectUtil.isNotEmpty((Object)((Object)orgIdToNameMap.get(Long.valueOf(orgId))))) continue;
                UmcParentOrgInfoBo umcParentOrgInfoBo = new UmcParentOrgInfoBo();
                umcParentOrgInfoBo.setOrgId(Long.valueOf(orgId));
                umcParentOrgInfoBo.setOrgName(orgIdToNameMap.get(Long.valueOf(orgId)).getOrgName());
                umcParentOrgInfoBo.setOrgType(orgIdToNameMap.get(Long.valueOf(orgId)).getOrgType());
                parentOrgInfoBoList.add(umcParentOrgInfoBo);
            }
            treeBO.setParentOrgInfoBoList(parentOrgInfoBoList);
        }
    }

    public Map<Long, UmcOrgInfo> packagingOrgIdToNameMap(List<UmcEnterpriseInfoDo> umcEnterpriseInfoDoList) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (UmcEnterpriseInfoDo umcEnterpriseInfoDo : umcEnterpriseInfoDoList) {
            String[] arr;
            for (String s : arr = umcEnterpriseInfoDo.getOrgTreePath().split("-")) {
                if (umcEnterpriseInfoDo.getOrgId().equals(Long.valueOf(s)) || orgIds.contains(Long.valueOf(s))) continue;
                orgIds.add(Long.valueOf(s));
            }
        }
        Map<Long, UmcOrgInfo> orgIdToNameMap = new HashMap<Long, UmcOrgInfo>();
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo;
            umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
            umcEnterpriseInfoDo.setOrgIds(orgIds);
            UmcOrgInfoRspBo umcOrgInfoRspBo = this.iUmcEnterpriseInfoModel.batchQueryOrgInfoListByOrgIds(umcEnterpriseInfoDo);
            if (!CollectionUtils.isEmpty((Collection)umcOrgInfoRspBo.getRows())) {
                orgIdToNameMap = umcOrgInfoRspBo.getRows().stream().filter(umcOrgInfo -> ObjectUtil.isNotEmpty((Object)umcOrgInfo.getOrgName())).collect(Collectors.toMap(UmcOrgInfo::getOrgId, key -> key, (key1, key2) -> key2));
            }
        }
        return orgIdToNameMap;
    }
}

