/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.service.enterprise.UmcSyncLimitSupplierService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncLimitSupplierBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncLimitSupplierReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncLimitSupplierRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcSyncLimitSupplierService"})
public class UmcSyncLimitSupplierServiceImpl
implements UmcSyncLimitSupplierService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"syncLimitSupplier"})
    public UmcSyncLimitSupplierRspBO syncLimitSupplier(@RequestBody UmcSyncLimitSupplierReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSyncDataList())) {
            return UmcRu.success(UmcSyncLimitSupplierRspBO.class);
        }
        UmcOrgInfoQryBo infoQryBo = new UmcOrgInfoQryBo();
        infoQryBo.setExtOrgIds(reqBO.getSyncDataList().stream().map(UmcSyncLimitSupplierBO::getExtOrgId).collect(Collectors.toList()));
        List umcOrgInfos = this.iUmcEnterpriseInfoModel.getOrgInfoList(infoQryBo).getRows();
        if (CollectionUtils.isEmpty((Collection)umcOrgInfos)) {
            return UmcRu.success(UmcSyncLimitSupplierRspBO.class);
        }
        UmcEnterpriseInfoQryBo enterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
        enterpriseInfoQryBo.setOrgIds(umcOrgInfos.stream().map(UmcOrgInfo::getOrgId).collect(Collectors.toList()));
        List umcEnterpriseInfoDos = this.iUmcEnterpriseInfoModel.getEnterpriseInfoList(enterpriseInfoQryBo).getRows();
        if (CollectionUtils.isEmpty((Collection)umcOrgInfos)) {
            return UmcRu.success(UmcSyncLimitSupplierRspBO.class);
        }
        Map<String, UmcOrgInfo> orgInfoMap = umcOrgInfos.stream().collect(Collectors.toMap(UmcOrgInfo::getExtOrgId, o -> o, (e1, e2) -> e2));
        Map<Long, UmcEnterpriseInfoDo> enterpriseInfoDoMap = umcEnterpriseInfoDos.stream().collect(Collectors.toMap(UmcEnterpriseInfoDo::getOrgId, o -> o, (e1, e2) -> e2));
        this.iUmcEnterpriseInfoModel.clearLimitSupplier();
        ArrayList<UmcSyncLimitSupplierBO> dealResult = new ArrayList<UmcSyncLimitSupplierBO>();
        for (UmcSyncLimitSupplierBO syncBO : reqBO.getSyncDataList()) {
            UmcOrgInfo umcOrgInfo;
            if (!orgInfoMap.containsKey(syncBO.getExtOrgId()) || !enterpriseInfoDoMap.containsKey((umcOrgInfo = orgInfoMap.get(syncBO.getExtOrgId())).getOrgId())) continue;
            UmcEnterpriseInfoDo umcEnterpriseInfoDo = enterpriseInfoDoMap.get(umcOrgInfo.getOrgId());
            if (!syncBO.getLimitType().equals(umcEnterpriseInfoDo.getExtField2()) || !syncBO.getIsBlack().equals(umcEnterpriseInfoDo.getExtField3())) {
                syncBO.setOrgName(umcOrgInfo.getOrgName());
                syncBO.setLimitTypeStr(UmcEnumConstant.LimitType.getInstance((String)syncBO.getLimitType()));
                dealResult.add(syncBO);
            }
            UmcEnterpriseInfoDo enterpriseInfoDo = new UmcEnterpriseInfoDo();
            enterpriseInfoDo.setOrgId(umcEnterpriseInfoDo.getOrgId());
            enterpriseInfoDo.setExtField2(syncBO.getLimitType());
            enterpriseInfoDo.setExtField3(syncBO.getIsBlack());
            this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(enterpriseInfoDo);
        }
        UmcSyncLimitSupplierRspBO rspBO = UmcRu.success(UmcSyncLimitSupplierRspBO.class);
        rspBO.setDealResult(dealResult);
        return rspBO;
    }
}

