/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.settled.IUmcSupplierSettledModel;
import com.tydic.dyc.umc.service.enterprise.UmcSyncSupplierInfoService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncSupplierInfoBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncSupplierInfoReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcSyncSupplierInfoRspBO;
import com.tydic.dyc.umc.service.settled.bo.UmcAccessoryBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcSyncSupplierInfoService"})
public class UmcSyncSupplierInfoServiceImpl
implements UmcSyncSupplierInfoService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSupplierSettledModel iUmcSupplierSettledModel;
    @Value(value="${syncSupplier.parentId:305775845729763332}")
    private Long parentId;
    @Value(value="${syncSupplier.parentOrgTreePath:1-305775845729763327-305775845729763332-}")
    private String parentOrgTreePath;
    @Value(value="${syncSupplier.tenantId:10000}")
    private Long tenantId;

    @PostMapping(value={"syncSupplierInfo"})
    public UmcSyncSupplierInfoRspBO syncSupplierInfo(@RequestBody UmcSyncSupplierInfoReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSyncData())) {
            throw new ZTBusinessException("\u540c\u6b65\u6570\u636e\u4e3a\u7a7a");
        }
        UmcSyncSupplierInfoRspBO rspBO = UmcRu.success(UmcSyncSupplierInfoRspBO.class);
        List<String> extOrgIds = reqBO.getSyncData().stream().map(UmcSyncSupplierInfoBO::getExtOrgId).collect(Collectors.toList());
        UmcEnterpriseOrgQryBo infoQryBo = new UmcEnterpriseOrgQryBo();
        infoQryBo.setExtOrgIds(extOrgIds);
        infoQryBo.setOrgTagId("2");
        infoQryBo.setPageSize(extOrgIds.size());
        UmcEnterpriseOrgQryRspBo umcOrgInfoRspBo = this.iUmcEnterpriseInfoModel.qryOrgDropDownList(infoQryBo);
        Map<Object, Object> orgInfoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)umcOrgInfoRspBo.getRows())) {
            orgInfoMap = umcOrgInfoRspBo.getRows().stream().collect(Collectors.toMap(UmcEnterpriseInfoDo::getExtOrgId, v -> v));
        }
        ArrayList<UmcOrgInfo> addOrgInfoList = new ArrayList<UmcOrgInfo>();
        ArrayList<UmcOrgTagRel> addOrgRelList = new ArrayList<UmcOrgTagRel>();
        ArrayList<UmcOrgInfo> updateOrgInfoList = new ArrayList<UmcOrgInfo>();
        for (UmcSyncSupplierInfoBO syncSupplierInfoBO : reqBO.getSyncData()) {
            if (!orgInfoMap.containsKey(syncSupplierInfoBO.getExtOrgId())) {
                long orgId = IdUtil.nextId();
                this.setAddOrgInfo(addOrgInfoList, syncSupplierInfoBO, orgId);
                this.setAddOrgTagInfo(addOrgRelList, orgId);
                this.setAddEnterpriseInfo(syncSupplierInfoBO, orgId);
                this.setAddEnterpriseContact(syncSupplierInfoBO, orgId);
                this.setAddSupplierSettled(orgId);
                continue;
            }
            UmcEnterpriseInfoDo orgInfo = (UmcEnterpriseInfoDo)((Object)orgInfoMap.get(syncSupplierInfoBO.getExtOrgId()));
            this.setUpdateOrgInfo(syncSupplierInfoBO, orgInfo.getOrgId(), updateOrgInfoList);
            this.setUpdateEnterpriseInfo(syncSupplierInfoBO, orgInfo.getOrgId());
            this.setUpdateEnterpriseContact(syncSupplierInfoBO, orgInfo.getOrgId());
        }
        rspBO.setAddOrgInfoList(UmcRu.jsl(addOrgInfoList, UmcOrgInfoBo.class));
        rspBO.setAddOrgRelList(UmcRu.jsl(addOrgRelList, UmcOrgTagRelBo.class));
        rspBO.setUpdateOrgInfoList(UmcRu.jsl(updateOrgInfoList, UmcOrgInfoBo.class));
        return rspBO;
    }

    private void setAddSupplierSettled(long orgId) {
        UmcSupplierSettledBo addSupplierSettle = new UmcSupplierSettledBo();
        addSupplierSettle.setOrgId(Long.valueOf(orgId));
        addSupplierSettle.setSettledStatus(UmcStatusConstant.SettledStatus.NOT_SETTLED);
        this.iUmcSupplierSettledModel.createUmcSupplierSettled(addSupplierSettle);
    }

    private void setUpdateEnterpriseContact(UmcSyncSupplierInfoBO syncSupplierInfoBO, Long orgId) {
        UmcEnterpriseContact updateEnterpriseContact = new UmcEnterpriseContact();
        updateEnterpriseContact.setOrgId(orgId);
        updateEnterpriseContact.setContactName(syncSupplierInfoBO.getContactName());
        updateEnterpriseContact.setPhoneNumber(syncSupplierInfoBO.getPhoneNumber());
        updateEnterpriseContact.setCardType(syncSupplierInfoBO.getCardType());
        updateEnterpriseContact.setCardNum(syncSupplierInfoBO.getCardNum());
        updateEnterpriseContact.setExtField1("2");
        updateEnterpriseContact.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterpriseContact.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterpriseContact.setUpdateTime(new Date());
        this.iUmcEnterpriseInfoModel.updateEnterpriseContact(updateEnterpriseContact);
    }

    private void setUpdateEnterpriseInfo(UmcSyncSupplierInfoBO syncSupplierInfoBO, Long orgId) {
        UmcEnterpriseInfoDo updateEnterpriseInfo = new UmcEnterpriseInfoDo();
        updateEnterpriseInfo.setOrgId(orgId);
        updateEnterpriseInfo.setOrgClass(syncSupplierInfoBO.getOrgClass());
        updateEnterpriseInfo.setCreditNo(syncSupplierInfoBO.getCreditNo());
        updateEnterpriseInfo.setOrgNature(syncSupplierInfoBO.getOrgNature());
        updateEnterpriseInfo.setSupplierType(syncSupplierInfoBO.getSupplierType());
        updateEnterpriseInfo.setCapital(syncSupplierInfoBO.getCapital());
        updateEnterpriseInfo.setCurrency(syncSupplierInfoBO.getCurrency());
        updateEnterpriseInfo.setBusinessIicenseStartDate(syncSupplierInfoBO.getBusinessIicenseStartDate());
        updateEnterpriseInfo.setBusinessLicenseEndDate(syncSupplierInfoBO.getBusinessLicenseEndDate());
        updateEnterpriseInfo.setAddress(syncSupplierInfoBO.getAddress());
        updateEnterpriseInfo.setExtField1(syncSupplierInfoBO.getExtField1());
        updateEnterpriseInfo.setExtField4(syncSupplierInfoBO.getExtField4());
        updateEnterpriseInfo.setExtField5(syncSupplierInfoBO.getExtField5());
        updateEnterpriseInfo.setBusinessScope(syncSupplierInfoBO.getBusinessScope());
        updateEnterpriseInfo.setLegalPerson(syncSupplierInfoBO.getLegalPerson());
        updateEnterpriseInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterpriseInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterpriseInfo.setUpdateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)syncSupplierInfoBO.getAccessoryList())) {
            for (UmcAccessoryBo accessoryBo : syncSupplierInfoBO.getAccessoryList()) {
                accessoryBo.setId(Long.valueOf(IdUtil.nextId()));
                accessoryBo.setObjId(orgId);
            }
            updateEnterpriseInfo.setUmcAccessoryBoList(syncSupplierInfoBO.getAccessoryList());
        }
        this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(updateEnterpriseInfo);
    }

    private void setUpdateOrgInfo(UmcSyncSupplierInfoBO syncSupplierInfoBO, Long orgId, List<UmcOrgInfo> updateOrgInfoList) {
        UmcOrgInfo updateOrgInfo = new UmcOrgInfo();
        updateOrgInfo.setOrgId(orgId);
        updateOrgInfo.setOrgName(syncSupplierInfoBO.getOrgName());
        updateOrgInfo.setOrgCode(syncSupplierInfoBO.getOrgCode());
        updateOrgInfo.setExtOrgCode(syncSupplierInfoBO.getExtOrgCode());
        updateOrgInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateOrgInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateOrgInfo.setUpdateTime(new Date());
        this.iUmcEnterpriseInfoModel.updateOrgInfo(updateOrgInfo);
        updateOrgInfoList.add(updateOrgInfo);
    }

    private void setAddEnterpriseContact(UmcSyncSupplierInfoBO syncSupplierInfoBO, long orgId) {
        UmcEnterpriseContact addEnterpriseContact = new UmcEnterpriseContact();
        addEnterpriseContact.setContactId(IdUtil.nextId());
        addEnterpriseContact.setOrgId(orgId);
        addEnterpriseContact.setTenantId(this.tenantId);
        addEnterpriseContact.setContactName(syncSupplierInfoBO.getContactName());
        addEnterpriseContact.setPhoneNumber(syncSupplierInfoBO.getPhoneNumber());
        addEnterpriseContact.setCardType(syncSupplierInfoBO.getCardType());
        addEnterpriseContact.setCardNum(syncSupplierInfoBO.getCardNum());
        addEnterpriseContact.setDelFlag("0");
        addEnterpriseContact.setExtField1("2");
        addEnterpriseContact.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseContact.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseContact.setCreateTime(new Date());
        this.iUmcEnterpriseInfoModel.createEnterpriseContact(addEnterpriseContact);
    }

    private void setAddOrgTagInfo(List<UmcOrgTagRel> addOrgRelList, long orgId) {
        UmcOrgTagRel addOrgTagRel = new UmcOrgTagRel();
        addOrgTagRel.setRelId(IdUtil.nextId());
        addOrgTagRel.setOrgId(orgId);
        addOrgTagRel.setTenantId(this.tenantId);
        addOrgTagRel.setTagId("2");
        addOrgTagRel.setTagStatus("1");
        addOrgTagRel.setDelFlag("0");
        addOrgTagRel.setCreateOperId(UmcCommConstant.System.ID);
        addOrgTagRel.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addOrgTagRel.setCreateTime(new Date());
        this.iUmcEnterpriseInfoModel.createOrgTagIdRel(addOrgTagRel);
        addOrgRelList.add(addOrgTagRel);
    }

    private void setAddEnterpriseInfo(UmcSyncSupplierInfoBO syncSupplierInfoBO, long orgId) {
        UmcEnterpriseInfoDo addEnterpriseInfo = new UmcEnterpriseInfoDo();
        addEnterpriseInfo.setOrgId(orgId);
        addEnterpriseInfo.setTenantId(this.tenantId);
        addEnterpriseInfo.setOrgClass(syncSupplierInfoBO.getOrgClass());
        addEnterpriseInfo.setIsAbroad(syncSupplierInfoBO.getIsAbroad());
        addEnterpriseInfo.setIsMerchant(syncSupplierInfoBO.getIsMerchant());
        addEnterpriseInfo.setIsShopOrg(syncSupplierInfoBO.getIsShopOrg());
        addEnterpriseInfo.setCreditNo(syncSupplierInfoBO.getCreditNo());
        addEnterpriseInfo.setOrgNature(syncSupplierInfoBO.getOrgNature());
        addEnterpriseInfo.setSupplierType(syncSupplierInfoBO.getSupplierType());
        addEnterpriseInfo.setCapital(syncSupplierInfoBO.getCapital());
        addEnterpriseInfo.setCurrency(syncSupplierInfoBO.getCurrency());
        addEnterpriseInfo.setBusinessIicenseStartDate(syncSupplierInfoBO.getBusinessIicenseStartDate());
        addEnterpriseInfo.setBusinessLicenseEndDate(syncSupplierInfoBO.getBusinessLicenseEndDate());
        addEnterpriseInfo.setAddress(syncSupplierInfoBO.getAddress());
        addEnterpriseInfo.setExtField1(syncSupplierInfoBO.getExtField1());
        addEnterpriseInfo.setExtField4(syncSupplierInfoBO.getExtField4());
        addEnterpriseInfo.setExtField5(syncSupplierInfoBO.getExtField5());
        addEnterpriseInfo.setBusinessScope(syncSupplierInfoBO.getBusinessScope());
        addEnterpriseInfo.setLegalPerson(syncSupplierInfoBO.getLegalPerson());
        addEnterpriseInfo.setDelFlag("0");
        addEnterpriseInfo.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseInfo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseInfo.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)syncSupplierInfoBO.getAccessoryList())) {
            for (UmcAccessoryBo accessoryBo : syncSupplierInfoBO.getAccessoryList()) {
                accessoryBo.setId(Long.valueOf(IdUtil.nextId()));
                accessoryBo.setObjId(Long.valueOf(orgId));
            }
            addEnterpriseInfo.setUmcAccessoryBoList(syncSupplierInfoBO.getAccessoryList());
        }
        this.iUmcEnterpriseInfoModel.createEnterpriseInfo(addEnterpriseInfo);
    }

    private void setAddOrgInfo(List<UmcOrgInfo> addOrgInfoList, UmcSyncSupplierInfoBO syncSupplierInfoBO, long orgId) {
        UmcOrgInfo addOrgInfo = new UmcOrgInfo();
        addOrgInfo.setOrgId(orgId);
        addOrgInfo.setOrgName(syncSupplierInfoBO.getOrgName());
        addOrgInfo.setTenantId(this.tenantId);
        addOrgInfo.setParentId(this.parentId);
        addOrgInfo.setOrgTreePath(this.parentOrgTreePath + orgId + "-");
        addOrgInfo.setOrgCode(syncSupplierInfoBO.getExtOrgCode());
        addOrgInfo.setExtOrgId(syncSupplierInfoBO.getExtOrgId());
        addOrgInfo.setExtOrgCode(syncSupplierInfoBO.getExtOrgCode());
        addOrgInfo.setOrgType(2L);
        addOrgInfo.setCompanyId(orgId);
        addOrgInfo.setDeep(addOrgInfo.getOrgTreePath().split("-").length);
        addOrgInfo.setIsVirtual(syncSupplierInfoBO.getIsVirtual());
        addOrgInfo.setDelFlag("0");
        addOrgInfo.setOrgStatus(syncSupplierInfoBO.getOrgStatus());
        addOrgInfo.setCreateOperId(UmcCommConstant.System.ID);
        addOrgInfo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addOrgInfo.setCreateTime(new Date());
        this.iUmcEnterpriseInfoModel.createOrgInfo(addOrgInfo);
        addOrgInfoList.add(addOrgInfo);
    }
}

