/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.settled;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.settled.IUmcSupplierSettledModel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.settled.UmcSupplierSettledAuditQryListService;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledAuditBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledAuditQryListReqBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledAuditQryListRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.settled.UmcSupplierSettledAuditQryListService"})
public class UmcSupplierSettledAuditQryListServiceImpl
implements UmcSupplierSettledAuditQryListService {
    @Autowired
    private IUmcSupplierSettledModel iUmcSupplierSettledModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qrySettledAuditList"})
    public UmcSupplierSettledAuditQryListRspBo qrySettledAuditList(@RequestBody UmcSupplierSettledAuditQryListReqBo reqBo) {
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        UmcSupplierSettledAuditQryListRspBo umcSupplierSettledAuditQryListRspBo = this.iUmcSupplierSettledModel.qrySettledAuditList(reqBo);
        if (!CollectionUtils.isEmpty((Collection)umcSupplierSettledAuditQryListRspBo.getRows())) {
            Map<String, String> enterpriseTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLED_ENTERPRISE_TYPE")).getMap();
            Map<String, String> dealResultMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "AUDIT_DEAL_RESULT")).getMap();
            Map<String, String> finishTagMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "FINISH_TAG_AUDIT")).getMap();
            for (UmcSupplierSettledAuditBo row : umcSupplierSettledAuditQryListRspBo.getRows()) {
                if (!StringUtils.isBlank((CharSequence)row.getEnterpriseType())) {
                    String[] split = row.getEnterpriseType().split(",");
                    StringBuilder epTypeStr = new StringBuilder();
                    for (int i = 0; i < split.length; ++i) {
                        String s = split[i];
                        epTypeStr.append(enterpriseTypeMap.get(s));
                        if (i >= split.length - 1) continue;
                        epTypeStr.append("\u3001");
                    }
                    row.setEnterpriseTypeStr(epTypeStr.toString());
                }
                if (null != row.getDealResult()) {
                    row.setDealResultStr(dealResultMap.get(row.getDealResult().toString()));
                }
                if (null == row.getFinishTag()) continue;
                row.setFinishTagStr(finishTagMap.get(row.getFinishTag().toString()));
            }
        }
        UmcSupplierSettledAuditQryListReqBo umcSupplierSettledAuditQryListReqBo = UmcRu.js(reqBo, UmcSupplierSettledAuditQryListReqBo.class);
        umcSupplierSettledAuditQryListReqBo.setFinishTag(Integer.valueOf(0));
        umcSupplierSettledAuditQryListReqBo.setPageNo(1);
        umcSupplierSettledAuditQryListReqBo.setPageSize(1);
        UmcSupplierSettledAuditQryListRspBo rspBo = this.iUmcSupplierSettledModel.qrySettledAuditList(umcSupplierSettledAuditQryListReqBo);
        umcSupplierSettledAuditQryListRspBo.setToAuditCount(Integer.valueOf(rspBo.getRecordsTotal()));
        return umcSupplierSettledAuditQryListRspBo;
    }
}

