/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.settled;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.audit.IUmcAuditOrderModel;
import com.tydic.dyc.umc.model.audit.UmcAuditOrderDo;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalLog;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalObj;
import com.tydic.dyc.umc.model.settled.IUmcSupplierSettledModel;
import com.tydic.dyc.umc.model.settled.sub.UmcSupplierSettledRecord;
import com.tydic.dyc.umc.service.settled.UmcSupplierSettledChangeSubmitService;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledChangeSubmitReqBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledChangeSubmitRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.settled.UmcSupplierSettledChangeSubmitService"})
public class UmcSupplierSettledChangeSubmitServiceImpl
implements UmcSupplierSettledChangeSubmitService {
    @Autowired
    private IUmcSupplierSettledModel iUmcSupplierSettledModel;
    @Autowired
    private IUmcAuditOrderModel iUmcAuditOrderModel;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;

    @PostMapping(value={"changeSettledInfo"})
    public UmcSupplierSettledChangeSubmitRspBo changeSettledInfo(@RequestBody UmcSupplierSettledChangeSubmitReqBo reqBo) {
        this.val(reqBo);
        reqBo.setOperType(Integer.valueOf(3));
        reqBo.setNow(new Date());
        UmcSupplierSettledRecord umcSupplierSettledRecord = this.iUmcSupplierSettledModel.changeSettledInfo(reqBo);
        UmcSupplierSettledChangeSubmitRspBo rspBo = UmcRu.success(UmcSupplierSettledChangeSubmitRspBo.class);
        Long auditId = IdUtil.nextId();
        this.createAuditOrder(reqBo, auditId, umcSupplierSettledRecord);
        rspBo.setAuditOrderId(auditId);
        rspBo.setChangeId(umcSupplierSettledRecord.getChangeId());
        return rspBo;
    }

    private void createAuditOrder(UmcSupplierSettledChangeSubmitReqBo reqBo, Long auditId, UmcSupplierSettledRecord umcSupplierSettledRecord) {
        UmcAuditOrderDo auditDo = UmcRu.js(reqBo, UmcAuditOrderDo.class);
        CfcEncodedSerialGetServiceReqBO cfcGetUnionCodeAbilityReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcGetUnionCodeAbilityReqBO.setCenter("UMC");
        cfcGetUnionCodeAbilityReqBO.setNum(Integer.valueOf(1));
        cfcGetUnionCodeAbilityReqBO.setEncodedRuleCode("UMC_AUDIT_CODE");
        cfcGetUnionCodeAbilityReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO cfcGetUnionCodeAbilityRspBO = this.cfcEncodedSerialGetService.getEncodedSerial(cfcGetUnionCodeAbilityReqBO);
        auditDo.setBusiCode((String)cfcGetUnionCodeAbilityRspBO.getSerialNoList().get(0));
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrgId());
        auditDo.setAuditOrderStatus("2");
        auditDo.setCreateTime(reqBo.getNow());
        ArrayList<UmcApprovalObj> objList = new ArrayList<UmcApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UmcApprovalObj approvalObj = new UmcApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(umcSupplierSettledRecord.getChangeId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrgId());
        approvalObj.setObjType(12);
        approvalObj.setObjBusiType(12);
        UmcApprovalLog umcApprovalLog = new UmcApprovalLog();
        umcApprovalLog.setAuditOrderId(auditId);
        umcApprovalLog.setId(IdUtil.nextId());
        umcApprovalLog.setOperid(reqBo.getUserId().toString());
        umcApprovalLog.setOperName(reqBo.getName());
        umcApprovalLog.setOperDept(reqBo.getOrgId().toString());
        umcApprovalLog.setCreateTime(reqBo.getNow());
        umcApprovalLog.setObjNum(objList.size());
        umcApprovalLog.setObjType(12);
        umcApprovalLog.setAuditResult(UmcCommConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(umcApprovalLog);
        this.iUmcAuditOrderModel.saveAudit(auditDo);
    }

    private void val(UmcSupplierSettledChangeSubmitReqBo reqBo) {
        if (null == reqBo.getOrgId()) {
            throw new BaseBusinessException("0001", "\u673a\u6784ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgShortName())) {
            throw new BaseBusinessException("0001", "\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a");
        }
        if (!"2".equals(reqBo.getIsProfessionalOrgExt())) {
            throw new BaseBusinessException("8888", "\u8bf7\u5207\u6362\u4f9b\u5e94\u5546\u8eab\u4efd\u53d1\u8d77\u53d8\u66f4\u7533\u8bf7");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcAccessoryBoList())) {
            throw new BaseBusinessException("8888", "\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        }
    }
}

