/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.settled;

import com.tydic.dyc.umc.model.settled.IUmcSupplierSettledModel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.settled.UmcSupplierSettledQryListService;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledQryListReqBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledQryListRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.settled.UmcSupplierSettledQryListService"})
public class UmcSupplierSettledQryListServiceImpl
implements UmcSupplierSettledQryListService {
    @Autowired
    private IUmcSupplierSettledModel iUmcSupplierSettledModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qrySettledList"})
    public UmcSupplierSettledQryListRspBo qrySettledList(@RequestBody UmcSupplierSettledQryListReqBo reqBo) {
        UmcSupplierSettledQryListRspBo rspBo = this.iUmcSupplierSettledModel.qrySettledList(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            Map<String, String> settledStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLED_STATUS")).getMap();
            Map<String, String> enterpriseTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLED_ENTERPRISE_TYPE")).getMap();
            for (UmcSupplierSettledBo row : rspBo.getRows()) {
                if (null != row.getSettledStatus()) {
                    row.setSettledStatusStr(settledStatusMap.get(row.getSettledStatus().toString()));
                }
                if (StringUtils.isBlank((CharSequence)row.getEnterpriseType())) continue;
                String[] split = row.getEnterpriseType().split(",");
                StringBuilder epTypeStr = new StringBuilder();
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    epTypeStr.append(enterpriseTypeMap.get(s));
                    if (i >= split.length - 1) continue;
                    epTypeStr.append("\u3001");
                }
                row.setEnterpriseTypeStr(epTypeStr.toString());
            }
        }
        UmcSupplierSettledQryListReqBo umcSupplierSettledQryListReqBo = UmcRu.js(reqBo, UmcSupplierSettledQryListReqBo.class);
        umcSupplierSettledQryListReqBo.setPageNo(1);
        umcSupplierSettledQryListReqBo.setPageSize(1);
        umcSupplierSettledQryListReqBo.setSettledStatus(Integer.valueOf(1));
        umcSupplierSettledQryListReqBo.setAuthEnterpriseTypeList(reqBo.getAuthEnterpriseTypeList());
        UmcSupplierSettledQryListRspBo umcSupplierSettledQryListRspBo = this.iUmcSupplierSettledModel.qrySettledList(umcSupplierSettledQryListReqBo);
        rspBo.setToAuditCount(Integer.valueOf(umcSupplierSettledQryListRspBo.getRecordsTotal()));
        return rspBo;
    }
}

