/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.settled;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.audit.IUmcAuditOrderModel;
import com.tydic.dyc.umc.model.audit.UmcAuditOrderDo;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalLog;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalObj;
import com.tydic.dyc.umc.model.settled.IUmcSupplierSettledModel;
import com.tydic.dyc.umc.service.settled.UmcSupplierSettledSubmitService;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledSubmitReqBo;
import com.tydic.dyc.umc.service.settled.bo.UmcSupplierSettledSubmitRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.settled.UmcSupplierSettledSubmitService"})
public class UmcSupplierSettledSubmitServiceImpl
implements UmcSupplierSettledSubmitService {
    @Autowired
    private IUmcSupplierSettledModel iUmcSupplierSettledModel;
    @Autowired
    private IUmcAuditOrderModel iUmcAuditOrderModel;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;

    @PostMapping(value={"submitSettledInfo"})
    public UmcSupplierSettledSubmitRspBo submitSettledInfo(@RequestBody UmcSupplierSettledSubmitReqBo reqBo) {
        this.val(reqBo);
        Date now = new Date();
        reqBo.setNow(now);
        this.iUmcSupplierSettledModel.submitSettledInfo(reqBo);
        UmcSupplierSettledSubmitRspBo rspBo = UmcRu.success(UmcSupplierSettledSubmitRspBo.class);
        if (UmcStatusConstant.SettledOperType.SUBMIT.equals(reqBo.getOperType())) {
            Long auditId = IdUtil.nextId();
            this.createAuditOrder(reqBo, auditId);
            rspBo.setAuditOrderId(auditId);
        }
        return rspBo;
    }

    private void val(UmcSupplierSettledSubmitReqBo reqBo) {
        if (null == reqBo.getOperType()) {
            throw new BaseBusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgId()) {
            throw new BaseBusinessException("0001", "\u673a\u6784ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgShortName())) {
            throw new BaseBusinessException("0001", "\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a");
        }
        if (!"2".equals(reqBo.getIsProfessionalOrgExt())) {
            throw new BaseBusinessException("8888", "\u8bf7\u5207\u6362\u4f9b\u5e94\u5546\u8eab\u4efd\u53d1\u8d77\u5165\u9a7b\u7533\u8bf7");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcAccessoryBoList())) {
            throw new BaseBusinessException("8888", "\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private void createAuditOrder(UmcSupplierSettledSubmitReqBo reqBo, Long auditId) {
        UmcAuditOrderDo auditDo = UmcRu.js(reqBo, UmcAuditOrderDo.class);
        CfcEncodedSerialGetServiceReqBO cfcGetUnionCodeAbilityReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcGetUnionCodeAbilityReqBO.setCenter("UMC");
        cfcGetUnionCodeAbilityReqBO.setNum(Integer.valueOf(1));
        cfcGetUnionCodeAbilityReqBO.setEncodedRuleCode("UMC_AUDIT_CODE");
        cfcGetUnionCodeAbilityReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO cfcGetUnionCodeAbilityRspBO = this.cfcEncodedSerialGetService.getEncodedSerial(cfcGetUnionCodeAbilityReqBO);
        auditDo.setBusiCode((String)cfcGetUnionCodeAbilityRspBO.getSerialNoList().get(0));
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrgId());
        auditDo.setAuditOrderStatus("2");
        auditDo.setCreateTime(reqBo.getNow());
        ArrayList<UmcApprovalObj> objList = new ArrayList<UmcApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UmcApprovalObj approvalObj = new UmcApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getOrgId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrgId());
        approvalObj.setObjType(11);
        approvalObj.setObjBusiType(11);
        UmcApprovalLog umcApprovalLog = new UmcApprovalLog();
        umcApprovalLog.setAuditOrderId(auditId);
        umcApprovalLog.setId(IdUtil.nextId());
        umcApprovalLog.setOperid(reqBo.getUserId().toString());
        umcApprovalLog.setOperName(reqBo.getName());
        umcApprovalLog.setOperDept(reqBo.getOrgId().toString());
        umcApprovalLog.setCreateTime(reqBo.getNow());
        umcApprovalLog.setObjNum(objList.size());
        umcApprovalLog.setObjType(11);
        umcApprovalLog.setAuditResult(UmcCommConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(umcApprovalLog);
        this.iUmcAuditOrderModel.saveAudit(auditDo);
    }
}

