/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDoneList;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcRevokeTodoBO;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService"})
public class UmcSendRevokeTodoServiceImpl
implements UmcSendRevokeTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendRevokeTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.todo.sync.syscode:HXDS}")
    private String syscode;
    @Value(value="${umc.todo.sync.revokeUrl:/toDoPDealTips}")
    private String revokeUrl;
    @Autowired
    private UmcUserInfoRepository umcUserInfoRepository;
    @Value(value="${umc.revoke.todo.sync.enable:true}")
    private boolean revokeTodoSyncEnable;

    @PostMapping(value={"revokeTodo"})
    public UmcSendRevokeTodoRspBo revokeTodo(@RequestBody UmcSendRevokeTodoReqBo reqBO) {
        Date now = new Date();
        ArrayList<UmcTodoDone> todoDoneList = new ArrayList<UmcTodoDone>();
        ArrayList<Long> deleteTodoIdList = new ArrayList<Long>();
        for (UmcRevokeTodoBO bo : reqBO.getUmcRevokeTodoBOList()) {
            UmcTodoDo qryDo = new UmcTodoDo();
            BeanUtils.copyProperties((Object)bo, (Object)qryDo);
            List<UmcTodoDo> results = this.iUmcTodoModel.getTodoList(qryDo);
            if (CollectionUtils.isEmpty(results)) {
                throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
            }
            for (UmcTodoDo bo2 : results) {
                UmcTodoDone umcTodoDone = new UmcTodoDone();
                BeanUtils.copyProperties((Object)bo2, (Object)umcTodoDone);
                umcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.REVOKE);
                umcTodoDone.setTodoCreateTime(bo2.getCreateTime());
                umcTodoDone.setCreateTime(now);
                todoDoneList.add(umcTodoDone);
                deleteTodoIdList.add(umcTodoDone.getTodoId());
            }
        }
        UmcTodoDoneList umcTodoDoneList = new UmcTodoDoneList();
        umcTodoDoneList.setUmcTodoDoneList(todoDoneList);
        int isInsert = this.iUmcTodoModel.createDone(umcTodoDoneList);
        UmcTodoDo deleteUmcTodoDo = new UmcTodoDo();
        deleteUmcTodoDo.setTodoIdList(deleteTodoIdList);
        int isDelete = this.iUmcTodoModel.deleteTodo(deleteUmcTodoDo).getCheck();
        if (this.revokeTodoSyncEnable) {
            this.sendMq(todoDoneList);
        }
        return UmcRu.success(UmcSendRevokeTodoRspBo.class);
    }

    private void sendMq(List<UmcTodoDone> umcTodoDoList) {
        ArrayList<UmcToDoPushBo> todoList = new ArrayList<UmcToDoPushBo>();
        for (UmcTodoDone umcTodoDone : umcTodoDoList) {
            if (!UmcCommConstant.PushFlag.YES.equals(umcTodoDone.getPushFlag())) continue;
            UmcToDoPushBo umcToDoPushBo = new UmcToDoPushBo();
            umcToDoPushBo.setSyscode(this.syscode);
            umcToDoPushBo.setMessageguid(umcTodoDone.getTodoId() + "");
            umcToDoPushBo.setMessagetitle(umcTodoDone.getTodoTitle());
            umcToDoPushBo.setWorkflowname(umcTodoDone.getTodoModuleName());
            umcToDoPushBo.setNodename(umcTodoDone.getTodoItemName());
            umcToDoPushBo.setHandurl(this.revokeUrl);
            umcToDoPushBo.setIsremark("2");
            umcToDoPushBo.setViewtype("1");
            umcToDoPushBo.setCreator(umcTodoDone.getCreateUserName());
            umcToDoPushBo.setSendername(umcTodoDone.getCreateName());
            umcToDoPushBo.setCreatedatetime(this.DateConvert(umcTodoDone.getCreateTime()));
            umcToDoPushBo.setReceiver(umcTodoDone.getDealUserName());
            todoList.add(umcToDoPushBo);
        }
        if (!CollectionUtils.isEmpty(todoList)) {
            this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.parseArray((String)JSON.toJSONString(todoList)).toString()));
        }
    }

    private String DateConvert(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(date);
    }
}

