/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import feign.template.UriUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UmcLogisticsCaculateUtil {
    private static final Logger log = LoggerFactory.getLogger(UmcLogisticsCaculateUtil.class);
    private static String addressUrl = "https://api.map.baidu.com/geocoding/v3?";
    private static String caculateUrl = "https://api.map.baidu.com/routematrix/v2/driving?";
    @Value(value="${baidu.AK:o9IssRXni9kvEeFQzQMM7qxe89LGsris}")
    private String baiduAK;
    private static String staticBaiduAK;

    @PostConstruct
    public void init() {
        staticBaiduAK = this.baiduAK;
    }

    public static String getStaticBaiduAK() {
        return staticBaiduAK;
    }

    public static String getLocation(String address) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("address", address);
        params.put("output", "json");
        params.put("ak", staticBaiduAK);
        String returnStr = UmcLogisticsCaculateUtil.requestGetAK(addressUrl, params);
        log.info("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u8fd4\u56de:{}", (Object)returnStr);
        String location = UmcLogisticsCaculateUtil.parseLocationReturn(returnStr);
        return location;
    }

    public static void main(String[] args) throws Exception {
    }

    public static String requestGetAK(String strUrl, Map<String, String> param) throws Exception {
        String line;
        if (strUrl == null || strUrl.length() <= 0 || param == null || param.size() <= 0) {
            throw new ZTBusinessException("\u53c2\u6570\u4e3a\u7a7a");
        }
        StringBuffer queryString = new StringBuffer();
        queryString.append(strUrl);
        for (Map.Entry<String, String> pair : param.entrySet()) {
            queryString.append(pair.getKey() + "=");
            queryString.append(UriUtils.encode((String)pair.getValue()) + "&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        URL url = new URL(queryString.toString());
        System.out.println(queryString.toString());
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.connect();
        InputStreamReader isr = new InputStreamReader(httpConnection.getInputStream());
        BufferedReader reader = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        isr.close();
        return buffer.toString();
    }

    private static String parseLocationReturn(String returnStr) {
        String location = "";
        JSONObject jsonObject = JSON.parseObject((String)returnStr);
        int status = jsonObject.getIntValue("status");
        if (status == 0) {
            JSONObject locationObj;
            JSONObject result = (JSONObject)jsonObject.get((Object)"result");
            if (result != null && (locationObj = (JSONObject)result.get((Object)"location")) != null) {
                float lng = locationObj.getFloat("lng").floatValue();
                float lat = locationObj.getFloat("lat").floatValue();
                location = lat + "," + lng;
            }
        } else {
            return "";
        }
        return location;
    }

    public static double getDistance(String original, String destination) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origins", original);
        params.put("destinations", destination);
        params.put("ak", staticBaiduAK);
        String returnStr = UmcLogisticsCaculateUtil.requestGetAK(caculateUrl, params);
        log.info("\u83b7\u53d6\u91cc\u7a0b\u8fd4\u56de:{}", (Object)returnStr);
        double location = UmcLogisticsCaculateUtil.parseDistanceReturn(returnStr);
        return location;
    }

    private static double parseDistanceReturn(String returnStr) {
        double distance = 0.0;
        JSONObject jsonObject = JSON.parseObject((String)returnStr);
        int status = jsonObject.getIntValue("status");
        if (status == 0) {
            JSONObject element;
            JSONObject locationObj;
            JSONArray result = (JSONArray)jsonObject.get((Object)"result");
            if (result != null && (locationObj = (JSONObject)(element = (JSONObject)result.get(0)).get((Object)"distance")) != null) {
                distance = locationObj.getDouble("value");
            }
        } else {
            return 0.0;
        }
        return distance;
    }
}

