package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.util.List;

/**
 * 标题：DycProBaseCallEsbUtilServiceOrderReqBO
 * 描述：申请售后入参（非京东）
 */
@Data
public class DycProBaseCallEsbUtilServiceOrderReqBO extends DycProBaseCallEsbReqBaseBO {

    private static final long serialVersionUID = 6114197216183768356L;

    /**
     * 供应商识别编码
     */
    private String hsn;

    /**
     * 调用地址
     */
    private String url;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 发货单号
     */
    private String packageId;

    /**
     * 售后服务类型
     */
    private Integer serviceType;

    /**
     * 产品问题描述
     */
    private String questionDesc;

    /**
     * 问题描述图片URL
     */
    private String questionPic;

    /**
     * 是否有包装
     */
    private Boolean isHasPackage;

    /**
     * 包装描述
     */
    private Integer packageDesc;

    /**
     * 是否需要检测报告
     */
    private Boolean isNeedDetectionReport;

    /**
     * 客户信息实体
     */
    private DycProBaseCallEsbUtilServiceOrderCustomerBO customer;

    /**
     * 取件信息实体
     */
    private DycProBaseCallEsbUtilServiceOrderPickwareBO pickware;

    /**
     * 返件信息实体
     */
    private DycProBaseCallEsbUtilServiceOrderReturnwareBO returnware;

    /**
     * 售后服务单商品明细
     */
    private List<DycProBaseCallEsbUtilServiceOrderDetailBO> detail;

}
