package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.util.List;

@Data
public class DycProBaseCallEsbUtilOrderEsPreOrderSubmitReqBO extends DycProBaseCallEsbReqBaseBO {
    private static final long serialVersionUID = 4801696662185096816L;
    /**
     * 供应商识别编码
     */
    private String hsn;
    /**
     * 调用地址
     */
    private String url;

    /**
     * 订单Id
     */
    private Long orderId;

    /**
     * 单据Id
     */
    private Long objId;

    /**
     * 第三方的订单单号
     */
    private String thirdOrder;

    /**
     * 商品信息
     */
    private List<DycProBaseCallEsbUtilOrderEsPreOrderSubmitReqSkuBO> sku;

    /**
     * 收货人
     */
    private String name;

    /**
     * 一级地址
     */
    private Integer province;

    /**
     * 二级地址
     */
    private Integer city;

    /**
     * 三级地址
     */
    private Integer county;

    /**
     * 四级地址(如果该地区有四级地址，则必须传递四级地址，没有四级地址则传0)
     */
    private Integer town;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 邮编
     */
    private String zip;

    /**
     * 座机号
     */
    private String phone;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 备注（少于100字）
     */
    private String remark;

    /**
     * 采购单位id
     */
    private String purchaseId;

    /**
     * 采购单位名称
     */
    private String purchaseName;

    /**
     * 下单人
     */
    private String purchaseAccount;

    /**
     * 下单人联系电话
     */
    private String purchaseMobile;

    /**
     * 开票方式(1为随货开票，0为订单预借，2为集中开票)
     */
    private Integer invoiceState;

    /**
     * 1普通发票2增值税发票
     */
    private Integer invoiceType;

    /**
     * 发票类型：4个人，5单位
     */
    private Integer selectedInvoiceTitle;

    /**
     * 发票抬头 (如果selectedInvoiceTitle=5则此字段必须)
     */
    private String companyName;

    /**
     * 1:明细，3：电脑配件，19:耗材，22：办公用品 备注:若增值发票则只能选1 明细
     */
    private Integer invoiceContent;

    /**
     * 支付方式 (1：货到付款,4：在线支付，5：公司转账，101：金采支付)
     */
    private Integer paymentType;

    /**
     * 使用余额paymentType=4时，此值固定是1 其他支付方式0
     */
    private Integer isUseBalance;

    /**
     * 是否预占库存，0是预占库存（需要调用确认订单接口），1是不预占库存 金融支付必须预占库存传0
     */
    private Integer submitState;

    /**
     * 增值票收票人姓名 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private String invoiceName;

    /**
     * 增值票收票人电话 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private String invoicePhone;

    /**
     * 增值票收票人所在省(京东地址编码) 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private Integer invoiceProvice;

    /**
     * 增值票收票人所在市(京东地址编码) 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private Integer invoiceCity;

    /**
     * 增值票收票人所在区/县(京东地址编码) 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private Integer invoiceCounty;

    /**
     * 增值票收票人所在地址 备注：当invoiceType=2 且invoiceState=1时则此字段必填
     */
    private String invoiceAddress;

    /**
     * 下单价格模式 0: 客户端订单价格快照不做验证对比，还是以京东价格正常下单; 1:必需验证客户端订单价格快照，如果快照与京东价格不一致返回下单失败，需要更新商品价格后，重新下单
     */
    private Integer doOrderPriceMode;

    /**
     * 客户端订单价格快照
     */
    private List<DycProBaseCallEsbUtilOrderEsPreOrderSubmitReqPriceSnapBO> orderPriceSnap;

    /**
     * 大家电配送日期 默认值为-1，0表示当天，1表示明天，2：表示后天; 如果为-1表示不使用大家电预约日历
     */
    private Integer reservingDate;

    /**
     * 大家电安装日期 不支持默认按-1处理，0表示当天，1表示明天，2：表示后天
     */
    private Integer installDate;

    /**
     * 大家电是否选择了安装 是否选择了安装，默认为true，选择了“暂缓安装”，此为必填项，必填值为false
     */
    private Boolean needInstall;

    /**
     * 中小件配送预约日期 格式：yyyy-MM-dd
     */
    private String promiseDate;

    /**
     * 中小件配送预约时间段 时间段如： 9:00-15:00
     */
    private String promiseTimeRange;

    /**
     * 中小件预约时间段的标记
     */
    private Integer promiseTimeRangeCode;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 采购单位
     */
    private String submitOrg;

    /**
     * 销售单ID
     */
    private Long saleVoucherId;

    /**
     * 下单人名称
     */
    private String puchaseAccount;

    /**
     * 三方订单编号（销售单编码）
     */
    private String thirdOrderNo;

    /**
     * 送货日期
     */
    private String deliveryDate;

    /**
     * 机构id
     */
    private String orgId;

    /**
     * 发票抬头
     */
    private String regCompanyName;

    /**
     * 纳税人识别号
     */
    private String regCode;

    /**
     * 专票资质银行账号
     */
    private String regBankAccount;

    /**
     * 专票资质注册银行
     */
    private String regBank;

    /**
     * 专票资质注册电话
     */
    private String regPhone;

    /**
     * 专票资质注册地址
     */
    private String regAddr;

}


