package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO
 * 描述：创建合同订单行明细BO（糖业）
 */
@Data
public class DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO implements Serializable {

    private static final long serialVersionUID = -2692002803853176701L;

    /**
     * 订单行明细ID（销售明细id）
     */
    private Long orderDetailId;

    /**
     * 商品ID（skuId？）
     */
    private Long productionId;

    /**
     * 商品名称（skuName）
     */
    private String productionName;

    /**
     * 商品备注
     * 商城无此数据，不会返回？
     */
    private String productionDesc;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 购买数量
     */
    private BigDecimal productionNum;

    /**
     * 绑定的EPS物料编码
     * m码？
     */
    private String materialCode;

    /**
     * 商品SKU编码（skuCode?）
     */
    private String sku;

    /**
     * 税额
     * 商城无此数据，不会返回？
     */
    private BigDecimal tax;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 商品比价信息（比价单附件？）
     */
    private String extField03;

    /**
     * 单位名称
     */
    private String unit;

    /**
     * 客户个性化配置数据【可做个性设置】
     * 商城无此数据，不会返回？
     */
    private String configureData;

    /**
     * 商品目录
     */
    private String goodsCatalog;

    /**
     *
     */
    private String needDepartment;

    /**
     *
     */
    private Long StoreId;

    /**
     *
     */
    private String StoreCode;

    /**
     * 供应商名称
     */
    private String StoreName;

    /**
     * M码
     */
    private String mroMaterialCode;

    /**
     *
     */
    private String mroMaterialCodeOther;

    /**
     * 是否MRO物料，1是 0否
     */
    private Integer IsMroGoods;

    /**
     *
     */
    private String EcCName;

    /**
     *
     */
    private String EcCCode;

    /**
     *
     */
    private String CatalogModule;

    /**
     * 采购申请单明细ID
     */
    private Long PurchaseApplyDetailId;

    /**
     * 采购申请单明细数量
     */
    private String PurchaseApplyDetailIdNums;
}
